/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import java.util.Stack;

public final class ContextSwitch {
    private static final Stack contextStack = new Stack();
    private static final Trace trace = Trace.getInstance("MI/Core");
    private final ConversationId conversationIdToBeRestored;
    private final ConversationId conversationIdToBeSet;
    private static Thread stackOwner = null;

    private ContextSwitch(ConversationId convIdToBeSet, ConversationId convIdToBeRestored) {
        this.conversationIdToBeRestored = convIdToBeRestored;
        this.conversationIdToBeSet = convIdToBeSet;
    }

    public static ContextSwitch switchContextTo(ConversationId newConversationId) {
        if (newConversationId == null) {
            throw new IllegalArgumentException("Cannot switch context for 'null' conversation id");
        }
        ConversationIdHandler convIdHandler = ConversationIdHandler.getInstance();
        ConversationId id = convIdHandler.getCurrentConversationId();
        if (id == null) {
            throw new IllegalStateException("Cannot switch context because current conversation id is empty");
        }
        Stack stack = contextStack;
        synchronized (stack) {
            if (!contextStack.isEmpty()) {
                if (stackOwner != Thread.currentThread()) {
                    String message = "Thread " + Thread.currentThread().getName() + " wanted to switch the context, but " + "the stack is currently owned by " + stackOwner.getName();
                    trace.log(10, message);
                    throw new RuntimeException(message);
                }
            } else {
                stackOwner = Thread.currentThread();
            }
            try {
                UserManagerImpl.getUserManagerImplInstance().setTemporaryCurrentUser(newConversationId.getUser());
                ApplicationManager.getInstance().setTemporaryMSD(newConversationId.getMsd());
                ContextSwitch context = new ContextSwitch(newConversationId, id);
                contextStack.push(context);
                if (trace.isLogging(80)) {
                    trace.log(80, "Thread " + Thread.currentThread().getName() + " switched context to {0} (stack level {1})", (Object)newConversationId, (Object)new Integer(contextStack.size()));
                }
                ContextSwitch contextSwitch = context;
                return contextSwitch;
            }
            catch (RuntimeException runtimeex) {
                trace.logException(50, "Error while switching context, try to clean up context. ", runtimeex, true);
                if (contextStack.isEmpty()) {
                    ContextSwitch.restoreOriginalContext();
                } else {
                    ConversationId convid = (ConversationId)contextStack.peek();
                    UserManagerImpl.getUserManagerImplInstance().setTemporaryCurrentUser(convid.getUser());
                    ApplicationManager.getInstance().setTemporaryMSD(convid.getMsd());
                }
                throw runtimeex;
            }
        }
    }

    public static ContextSwitch switchContextTo(String newConversationId) {
        ConversationId convId = ConversationIdHandler.getInstance().getConversationId(newConversationId);
        if (convId == null || newConversationId == null) {
            throw new IllegalArgumentException("Unknown conversation id: Cannot switch context to " + newConversationId);
        }
        return ContextSwitch.switchContextTo(convId);
    }

    public static void restoreLastContext(ContextSwitch contextToBeRemoved) {
        Stack stack = contextStack;
        synchronized (stack) {
            if (contextToBeRemoved == null) {
                throw new NullPointerException("contextToBeRemoved is null. ");
            }
            if (contextStack.isEmpty()) {
                throw new IllegalStateException("Context can't be restoreed because stack is empty. ");
            }
            if (Thread.currentThread() != stackOwner) {
                String message = "Thread " + Thread.currentThread().getName() + " wanted to restore the context, but" + "the stack is currently owned by " + stackOwner.getName();
                trace.log(10, message);
                throw new RuntimeException(message);
            }
            ContextSwitch lastContext = (ContextSwitch)contextStack.peek();
            if (lastContext != contextToBeRemoved) {
                trace.log(50, "Cannot restore last context (last item on stack {0} does not correspond to parameter {1})", (Object)lastContext, (Object)contextToBeRemoved);
                throw new IllegalStateException("Wrong context stack state");
            }
            contextStack.pop();
            if (contextStack.isEmpty()) {
                ContextSwitch.restoreOriginalContext();
                stackOwner = null;
            } else {
                ConversationId convid = lastContext.getConversationIdToBeRestored();
                UserManagerImpl.getUserManagerImplInstance().setTemporaryCurrentUser(convid.getUser());
                ApplicationManager.getInstance().setTemporaryMSD(convid.getMsd());
                if (trace.isLogging(80)) {
                    trace.log(80, "Thread " + Thread.currentThread().getName() + " restored context {0} (stack level {1})", (Object)convid, (Object)new Integer(contextStack.size()));
                }
            }
        }
    }

    public static void restoreOriginalContext() {
        Stack stack = contextStack;
        synchronized (stack) {
            if (contextStack.size() > 1) {
                Trace.getInstance("MI/Core").log(60, "Someone has not restored his context. Restoring original context");
            }
            if (!contextStack.isEmpty() && stackOwner != Thread.currentThread()) {
                String message = "Thread " + Thread.currentThread().getName() + " wanted to restore original context, but " + "stack owner is Thread " + stackOwner.getName() + "; do it anyway";
                trace.log(60, message);
            }
            UserManagerImpl.getUserManagerImplInstance().setTemporaryCurrentUser(null);
            ApplicationManager.getInstance().setTemporaryMSD(null);
            contextStack.setSize(0);
            stackOwner = null;
            if (trace.isLogging(80)) {
                trace.log(80, "original context restored");
            }
        }
    }

    public String toString() {
        return this.getConversationIdToBeSet().getId() + " / " + this.getConversationIdToBeRestored().getId() + " - " + super.toString();
    }

    private ConversationId getConversationIdToBeSet() {
        return this.conversationIdToBeSet;
    }

    private ConversationId getConversationIdToBeRestored() {
        return this.conversationIdToBeRestored;
    }
}

