/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.smartsync.FixedDecimal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

public final class ComparatorHelper {
    public static int compareTo(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1.getClass() != o2.getClass()) {
            throw new RuntimeException("Comparing with different data types!");
        }
        if (o1 instanceof String) {
            return ((String)o2).compareTo((String)o1);
        }
        if (o1 instanceof Calendar) {
            long l2;
            long l1 = ((Calendar)o1).getTime().getTime();
            if (l1 < (l2 = ((Calendar)o2).getTime().getTime())) {
                return 1;
            }
            if (l1 > l2) {
                return -1;
            }
            return 0;
        }
        if (o1 instanceof Date) {
            long l2;
            long l1 = ((Date)o1).getTime();
            if (l1 < (l2 = ((Date)o2).getTime())) {
                return 1;
            }
            if (l1 > l2) {
                return -1;
            }
            return 0;
        }
        if (o1 instanceof Integer) {
            return (Integer)o2 - (Integer)o1;
        }
        if (o1 instanceof Boolean) {
            int i1 = (Boolean)o1 != false ? 1 : -1;
            int i2 = (Boolean)o2 != false ? 1 : -1;
            return i2 - i1;
        }
        if (o1 instanceof Long) {
            long l2;
            long l1 = (Long)o1;
            if (l1 < (l2 = ((Long)o2).longValue())) {
                return 1;
            }
            if (l1 > l2) {
                return -1;
            }
            return 0;
        }
        if (o1 instanceof Byte) {
            return (Byte)o2 - (Byte)o1;
        }
        if (o1 instanceof Double) {
            double d2;
            double d1 = (Double)o1;
            if (d1 < (d2 = ((Double)o2).doubleValue())) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }
        if (o1 instanceof Float) {
            float f2;
            float f1 = ((Float)o1).floatValue();
            if (f1 < (f2 = ((Float)o2).floatValue())) {
                return 1;
            }
            if (f1 > f2) {
                return -1;
            }
            return 0;
        }
        if (o1 instanceof Short) {
            return (Short)o2 - (Short)o1;
        }
        if (o1 instanceof Byte[]) {
            Byte[] bytes1 = (Byte[])o1;
            Byte[] bytes2 = (Byte[])o2;
            int i = 0;
            while (i < bytes1.length) {
                if (i >= bytes2.length) {
                    return -1;
                }
                if (bytes1[i] != bytes2[i]) {
                    return bytes2[i] - bytes1[i];
                }
                if (i == bytes1.length - 1 && i < bytes2.length - 1) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        if (o1 instanceof byte[]) {
            byte[] bytes1 = (byte[])o1;
            byte[] bytes2 = (byte[])o2;
            int i = 0;
            while (i < bytes1.length) {
                if (i >= bytes2.length) {
                    return -1;
                }
                if (bytes1[i] != bytes2[i]) {
                    return bytes2[i] - bytes1[i];
                }
                if (i == bytes1.length - 1 && i < bytes2.length - 1) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        if (o1 instanceof FixedDecimal) {
            return ((FixedDecimal)o2).bigDecimalValue().compareTo(((FixedDecimal)o1).bigDecimalValue());
        }
        if (o1 instanceof BigDecimal) {
            return ((BigDecimal)o2).compareTo((BigDecimal)o1);
        }
        if (o1 instanceof BigInteger) {
            return ((BigInteger)o2).compareTo((BigInteger)o1);
        }
        throw new RuntimeException("Data type unsupported for comparator!");
    }
}

