/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;

public class CommunicationServer
implements Runnable {
    private static int serverport = 45000;
    boolean running = false;
    private static final String NEWLINE = "\n";
    private static final Trace trace = Trace.getInstance("MI/ComServer");
    private static final CommunicationServer INSTANCE = new CommunicationServer();
    private static final String CMD_SHUTDOWN = "shutdown";
    private static final String CMD_BYE = "bye";
    private static final String CMD_GETAPPLICATIONS = "getapps";

    public static CommunicationServer getInstance() {
        return INSTANCE;
    }

    public static final void initialize() {
        Configuration config = Configuration.getInstance();
        if (config.getBoolean("MI.CommunicationServer.AlwaysOn", false)) {
            INSTANCE.startCommunicationServer();
        }
    }

    public final void startCommunicationServer() {
        if (!this.running) {
            Thread th = new Thread(this);
            th.start();
        }
    }

    public final void stopCommunicationServer() {
        if (this.running) {
            this.running = false;
        }
    }

    private CommunicationServer() {
        serverport = CommunicationServer.getPort();
    }

    public static int getPort() {
        return Configuration.getInstance().getInt("MobileEngine.CommunicationServer.Port", serverport);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        ServerSocket server = null;
        server = new ServerSocket(serverport);
        server.setSoTimeout(0);
        this.running = true;
        while (this.running) {
            trace.log("Listen for next connection on port " + serverport);
            Socket client = server.accept();
            try {
                String line;
                client.setSoTimeout(300000);
                trace.log(80, "Connection to client established");
                InputStream in = client.getInputStream();
                OutputStream out = client.getOutputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF8"));
                writer.write("Hello.");
                writer.write(NEWLINE);
                writer.flush();
                while (!CMD_BYE.equalsIgnoreCase(line = reader.readLine())) {
                    void var7_9;
                    if (var7_9 == null) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception ex2) {}
                        continue;
                    }
                    trace.log(90, "Client: received command: " + (String)var7_9);
                    writer.write("echo:");
                    writer.write((String)var7_9);
                    writer.write(NEWLINE);
                    writer.flush();
                    if (var7_9.equals("ping")) continue;
                    this.evaluateCommand(var7_9.trim(), writer, client);
                }
                client.close();
            }
            catch (Exception e) {
                client.close();
                client = null;
            }
        }
        Object var10_11 = null;
        if (server == null) return;
        try {
            server.close();
            return;
        }
        catch (IOException ioex) {
            trace.logException("Cannot close communication server: ", (Throwable)ioex, true);
            ioex.printStackTrace(System.err);
        }
        return;
        {
            catch (Exception ex) {
                trace.logException("Exception while running communication server: ", (Throwable)ex, true);
                ex.printStackTrace(System.err);
                Object var10_12 = null;
                if (server == null) return;
                try {
                    server.close();
                    return;
                }
                catch (IOException ioex) {
                    trace.logException("Cannot close communication server: ", (Throwable)ioex, true);
                    ioex.printStackTrace(System.err);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (server == null) throw throwable;
            try {
                server.close();
                throw throwable;
            }
            catch (IOException ioex) {
                trace.logException("Cannot close communication server: ", (Throwable)ioex, true);
                ioex.printStackTrace(System.err);
            }
            throw throwable;
        }
    }

    private void evaluateCommand(String command, Writer writer, Socket client) throws IOException {
        if (CMD_SHUTDOWN.equals(command)) {
            this.writeln("shutdown started", writer);
            try {
                client.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            System.exit(0);
        } else if (CMD_GETAPPLICATIONS.equals(command)) {
            ApplicationManager appman = ApplicationManager.getInstance();
            MobileSolutionDescriptor[] msds = appman.getMobileSolutionDescriptors();
            this.writeln(String.valueOf(msds.length), writer);
            int i = 0;
            while (i < msds.length) {
                this.writeln(this.fillMsdString(msds[i]), writer);
                ++i;
            }
        } else {
            this.writeln("unknown command", writer);
        }
    }

    private void writeln(String msg, Writer writer) throws IOException {
        writer.write(msg);
        writer.write(NEWLINE);
        writer.flush();
    }

    private String fillMsdString(MobileSolutionDescriptor msd) {
        StringBuffer sb = new StringBuffer(50);
        String status = msd.isInstalled() ? "I" : (msd.isIncomplete() ? "T" : "F");
        sb.append(status);
        sb.append(msd.getName()).append("/").append(msd.getVersion());
        return sb.toString();
    }
}

