/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.core.Base64;
import java.util.Random;

class CipherHandler {
    protected CipherHandler() {
    }

    public String encrypt(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        Random pseudoRandomNumberGenerator = new Random();
        int inputLength = input.length();
        char[] result = new char[inputLength * 4];
        int i = 0;
        while (i < inputLength) {
            result[i] = input.charAt(i);
            ++i;
        }
        int i2 = inputLength;
        while (i2 < result.length) {
            result[i2] = (char)pseudoRandomNumberGenerator.nextInt();
            ++i2;
        }
        int round = 0;
        while (round < 3) {
            int offset = (1 + round) * inputLength;
            int i3 = 0;
            while (i3 < inputLength) {
                result[i3] = (char)(result[i3] ^ result[i3 + offset]);
                ++i3;
            }
            ++round;
        }
        return Base64.encode(new String(result));
    }

    public String decrypt(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        char[] inputChars = Base64.decode(input).toCharArray();
        if (inputChars.length != inputChars.length / 4 * 4) {
            throw new IllegalArgumentException("Received a corrupt string to decrypt.");
        }
        int len = inputChars.length / 4;
        char[] result = new char[len];
        int i = 0;
        while (i < len) {
            result[i] = inputChars[i];
            ++i;
        }
        int round = 0;
        while (round < 3) {
            int offset = (1 + round) * len;
            int i2 = 0;
            while (i2 < len) {
                result[i2] = (char)(result[i2] ^ inputChars[i2 + offset]);
                ++i2;
            }
            ++round;
        }
        return new String(result);
    }
}

