/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

public final class Base64 {
    private static final char[] base64chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] ASCIICharToBase64Char = new int[128];

    private Base64() {
    }

    public static String encode(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int len = 2 * value.length();
        byte[] bytes = new byte[len];
        int i = 0;
        while (i < len) {
            char b = value.charAt(i / 2);
            bytes[i] = (byte)(b >> 8 & 0xFF);
            bytes[i + 1] = (byte)(b & 0xFF);
            i += 2;
        }
        return new String(Base64.encode(bytes));
    }

    public static String decode(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        byte[] decodedBytes = Base64.decode(value.toCharArray());
        int size = decodedBytes.length;
        char[] decodedchars = new char[size / 2];
        int i = 0;
        while (i < size) {
            int b = (decodedBytes[i] & 0xFF) << 8;
            decodedchars[i / 2] = (char)(b += decodedBytes[i + 1] & 0xFF);
            i += 2;
        }
        return new String(decodedchars);
    }

    public static char[] encode(byte[] bytes) {
        int byte1;
        int byte0;
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return new char[0];
        }
        int len = bytes.length;
        int numOfCompleteGroups = len / 3;
        int numOfRemainingBytes = len - 3 * numOfCompleteGroups;
        int size = (len + 2) / 3 * 4;
        byte[] encodedBytes = new byte[size];
        int inIndex = 0;
        int outIndex = 0;
        int i = 0;
        while (i < numOfCompleteGroups) {
            byte0 = bytes[inIndex++] & 0xFF;
            byte1 = bytes[inIndex++] & 0xFF;
            int byte2 = bytes[inIndex++] & 0xFF;
            encodedBytes[outIndex++] = (byte)base64chars[byte0 >> 2];
            encodedBytes[outIndex++] = (byte)base64chars[byte0 << 4 & 0x3F | byte1 >> 4];
            encodedBytes[outIndex++] = (byte)base64chars[byte1 << 2 & 0x3F | byte2 >> 6];
            encodedBytes[outIndex++] = (byte)base64chars[byte2 & 0x3F];
            ++i;
        }
        if (numOfRemainingBytes != 0) {
            byte0 = bytes[inIndex++] & 0xFF;
            encodedBytes[outIndex++] = (byte)base64chars[byte0 >> 2];
            if (numOfRemainingBytes == 1) {
                encodedBytes[outIndex++] = (byte)base64chars[byte0 << 4 & 0x3F];
                encodedBytes[outIndex++] = 61;
                encodedBytes[outIndex++] = 61;
            } else {
                byte1 = bytes[inIndex++] & 0xFF;
                encodedBytes[outIndex++] = (byte)base64chars[byte0 << 4 & 0x3F | byte1 >> 4];
                encodedBytes[outIndex++] = (byte)base64chars[byte1 << 2 & 0x3F];
                encodedBytes[outIndex++] = 61;
            }
        }
        char[] chars = new char[size];
        int i2 = 0;
        while (i2 < size) {
            chars[i2] = (char)encodedBytes[i2];
            ++i2;
        }
        return chars;
    }

    public static byte[] decode(char[] chars) {
        int byte2;
        int byte1;
        int byte0;
        if (chars == null) {
            return null;
        }
        if (chars.length == 0) {
            return new byte[0];
        }
        int len = chars.length;
        int numOfCompleteGroups = len / 4;
        if (4 * numOfCompleteGroups != len) {
            throw new IllegalArgumentException("Length of given Base64 encoded character array must be a multiple of four.");
        }
        int numOfPaddingChars = 0;
        if (chars[len - 1] == '=') {
            --numOfCompleteGroups;
            numOfPaddingChars = chars[len - 2] == '=' ? 2 : 1;
        }
        int size = len / 4 * 3 - numOfPaddingChars;
        byte[] decodedBytes = new byte[size];
        int inIndex = 0;
        int outIndex = 0;
        int i = 0;
        while (i < numOfCompleteGroups) {
            byte0 = Base64.getBase64Char(chars[inIndex++]);
            byte1 = Base64.getBase64Char(chars[inIndex++]);
            byte2 = Base64.getBase64Char(chars[inIndex++]);
            int byte3 = Base64.getBase64Char(chars[inIndex++]);
            decodedBytes[outIndex++] = (byte)(byte0 << 2 | byte1 >> 4);
            decodedBytes[outIndex++] = (byte)(byte1 << 4 | byte2 >> 2);
            decodedBytes[outIndex++] = (byte)(byte2 << 6 | byte3);
            ++i;
        }
        if (numOfPaddingChars != 0) {
            byte0 = Base64.getBase64Char(chars[inIndex++]);
            byte1 = Base64.getBase64Char(chars[inIndex++]);
            decodedBytes[outIndex++] = (byte)(byte0 << 2 | byte1 >> 4);
            if (numOfPaddingChars == 1) {
                byte2 = Base64.getBase64Char(chars[inIndex++]);
                decodedBytes[outIndex++] = (byte)(byte1 << 4 | byte2 >> 2);
            }
        }
        return decodedBytes;
    }

    private static int getBase64Char(char c) {
        int currentByte = ASCIICharToBase64Char[c];
        if (currentByte < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return currentByte;
    }

    static {
        int i = 0;
        while (i < 128) {
            Base64.ASCIICharToBase64Char[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < 64) {
            Base64.ASCIICharToBase64Char[Base64.base64chars[i2]] = i2;
            ++i2;
        }
    }
}

