/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.deploy.ClassPathManager;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.apps.DeploymentInstallLog;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.CleanupListWriter;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.InstallationLog;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UnknownApplicationTypeException;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AwtApplicationType
implements ApplicationType {
    private final Trace trace = Trace.getInstance("MI/Deployment");
    private DeploymentMessages deplLog = DeploymentMessages.getInstance();
    private InstallationLog log = new InstallationLog("LOG");

    public void install(String source, MobileSolutionDescriptor applicationInfo) throws InstallationException {
        this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "DOWNLOADING", " " + applicationInfo.getName() + " " + applicationInfo.getVersion() + ": " + applicationInfo.getDescription());
        this.log.addLogEntry("Retrieving application " + applicationInfo.getName() + " from  " + source);
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "Installation: Link sent from backend is ''{0}''", (Object)source);
        }
        String urlString = this.determineURL(source);
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "Installation: Retrieving application ''{0}'' from ''{1}''", (Object)applicationInfo.getName(), (Object)urlString);
        }
        try {
            Configuration config = Configuration.getInstance();
            String libfolder = config.getProperty("MobileEngine.InstallationPath") + File.separator + "lib" + File.separator;
            File jarFile = this.downloadInstallationFile(applicationInfo, urlString);
            if (this.trace.isLogging(90)) {
                this.trace.log(90, "Install application jar into ''{0}''", (Object)libfolder);
                this.trace.log(90, "Destination file for download is {0} ", (Object)jarFile.getAbsolutePath());
            }
            applicationInfo.addInstalledFile(jarFile.getAbsolutePath());
            this.evaluateJar(jarFile, applicationInfo);
            if (applicationInfo.getTargetClassname() == null || "".equals(applicationInfo.getTargetClassname())) {
                this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
                this.log.addLogEntry("AwtApplicationType.install: Cannot find the mandatory manifest file entry \"ApplicationClass\" for application " + applicationInfo.getName());
                AppLog.getInstance("MI/Deployment").log(50, "Error while installing an AWT application (cannot find the mandatory manifest file entry \"ApplicationClass\" for application " + applicationInfo.getName() + "); check application archive");
                IOUtils.deleteDirectoryRecursively(new File(jarFile.getAbsolutePath()));
                throw new InstallationException(9, new Object[]{applicationInfo.getName()}, null);
            }
            ClassPathManager.getInstance().addToClassPath(jarFile.getAbsolutePath());
        }
        catch (HttpConnectionException ex) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", " " + urlString);
            this.log.addLogEntry(ex.getMessage());
            this.log.addLogEntry("Application.install: Failed to download installation file from " + urlString);
            AppLog.getInstance("MI/Deployment").logException(50, "Error while installing an AWT application (failed to download installation file from '" + urlString + "'); check download link", ex, true);
        }
        if (applicationInfo.getPropertyValueForKey("HOMEPAGE.INVISIBLE").equalsIgnoreCase("X")) {
            applicationInfo.setVisible(false);
        } else {
            applicationInfo.setVisible(true);
        }
        applicationInfo.setInstalled(true);
        applicationInfo.setIncomplete(false);
        this.log.addLogEntry("Installation of " + applicationInfo.getName() + " completed successfully");
        this.putDeploymentInstallLogToInbox(applicationInfo);
        this.log.sendToR3();
    }

    public void uninstall(MobileSolutionDescriptor application) throws InstallationException {
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "AWTApplication ''{0}'' will be unistalled", (Object)application.getName());
        }
        InstallationLog log = new InstallationLog("LOG");
        this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLING", " " + application.getName() + " " + application.getVersion() + " " + application.getDescription());
        log.addLogEntry("Removing application " + application.getName());
        try {
            if (application.getType() instanceof AwtApplicationType) {
                application.setIncomplete(true);
                boolean alldone = true;
                String[] files = application.getInstalledFiles();
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < files.length) {
                    if (files[i].toLowerCase().endsWith(".jar")) {
                        ClassPathManager.getInstance().removeFromClassPath(files[i]);
                        log.addLogEntry("DELETING: " + files[i]);
                    }
                    File f = new File(files[i]);
                    boolean deleted = true;
                    if (!f.exists()) {
                        application.removeInstalledFile(files[i]);
                        log.addLogEntry("DELETING: " + files[i]);
                    } else {
                        deleted = f.delete();
                        boolean bl = alldone = alldone && deleted;
                        if (deleted) {
                            application.removeInstalledFile(files[i]);
                            log.addLogEntry("DELETING: " + files[i]);
                        } else {
                            sb.append(f.getAbsolutePath().concat(File.pathSeparator));
                        }
                    }
                    if (this.trace.isLogging(90)) {
                        this.trace.log(90, "Delete file ''{0}'' state = ''{1}''", (Object)f.getAbsolutePath(), (Object)new Boolean(deleted));
                    }
                    ++i;
                }
                if (alldone) {
                    ApplicationManager.getInstance().unregisterMobileSolutionDescriptor(application);
                } else {
                    application.setIncomplete(true);
                    CleanupListWriter.writeToFile(sb.toString());
                }
            }
        }
        catch (UnknownApplicationTypeException uaex) {
            AppLog.getInstance("MI/Deployment").logException(50, "Error while uninstalling application " + application.getName() + " (unknown application type); check application type", uaex, true);
        }
        try {
            ApplicationManager.getInstance().saveMobileSolutionDescriptors();
        }
        catch (IOException ioex) {
            AppLog.getInstance("MI/Deployment").logException("Error while writing application registry; check the device", (Throwable)ioex, true);
        }
        log.sendToR3();
    }

    public String toString() {
        return "AWT";
    }

    private void putDeploymentInstallLogToInbox(MobileSolutionDescriptor applicationInfo) {
        DeploymentInstallLog d = new DeploymentInstallLog(applicationInfo.getName());
        d.appendLines(this.log.getLogEntries());
        DeploymentInbox.getInstance().setApplicationLog(d);
    }

    private String determineURL(String source) throws InstallationException {
        String urlString = null;
        if (!(source.startsWith("http") || source.startsWith("HTTP") || source.toLowerCase().startsWith("file"))) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", source);
            AppLog.getInstance("MI/Core").log(50, "Installation: Failed to download installation file because download link sent was: " + source);
            throw new InstallationException(7, null, null);
        }
        urlString = source;
        return urlString;
    }

    private void evaluateJar(File jarFile, MobileSolutionDescriptor applicationInfo) {
        this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "INSTALLING", " " + applicationInfo.getName() + " " + applicationInfo.getVersion() + ": " + applicationInfo.getDescription());
        boolean isLogging = this.trace.isLogging(80);
        if (isLogging) {
            this.trace.log(80, "Installing jar file ''{0}'' ... ", (Object)jarFile.getName());
        }
        Configuration config = Configuration.getInstance();
        String baseDir = config.getProperty("MobileEngine.InstallationPath");
        try {
            ZipFile zip = new ZipFile(jarFile.getAbsolutePath());
            Enumeration<? extends ZipEntry> jarFileEntries = zip.entries();
            this.trace.log(80, "checking jar file");
            while (jarFileEntries.hasMoreElements()) {
                ZipEntry jarFileEntry = jarFileEntries.nextElement();
                String currentEntryName = jarFileEntry.getName();
                if (isLogging) {
                    this.trace.log(80, "Current JarFileEntry: ''{0}'' ", (Object)currentEntryName);
                }
                if (currentEntryName.toLowerCase().endsWith("meta-inf/manifest.mf")) {
                    currentEntryName = currentEntryName.substring(currentEntryName.lastIndexOf("/") + 1, currentEntryName.length());
                    File tempFile = IOUtils.extractZipFile(zip, jarFileEntry, baseDir + File.separator + currentEntryName);
                    Properties manifestfile = new Properties();
                    if (isLogging) {
                        this.trace.log(80, "Evaluation manifest file ''{0}''", (Object)tempFile.getAbsolutePath());
                    }
                    FileInputStream fis = new FileInputStream(new File(tempFile.getAbsolutePath()));
                    manifestfile.load(fis);
                    fis.close();
                    String newDescr = manifestfile.getProperty("Description", "");
                    this.trace.log(80, "The description is ''{0}''", (Object)newDescr);
                    applicationInfo.setDescription(newDescr);
                    String applClassname = manifestfile.getProperty("ApplicationClass");
                    if (isLogging) {
                        this.trace.log(80, "The class that implement the Application interface: ''{0}''", (Object)applClassname);
                    }
                    applicationInfo.setTargetClassname(applClassname);
                    String ownFrame = manifestfile.getProperty("OwnFrame", "");
                    if (ownFrame.equalsIgnoreCase("true")) {
                        applicationInfo.setOwnFrame(true);
                        if (isLogging) {
                            this.trace.log(80, "The Application uses its own frame");
                        }
                    } else if (isLogging) {
                        this.trace.log(80, "The Application does not use its own frame");
                    }
                    if (!isLogging) continue;
                    this.trace.log(80, "Deletion status of temporary file ''{0}'' is ''{1}''", (Object)tempFile.getAbsolutePath(), (Object)new Boolean(new File(tempFile.getAbsolutePath()).delete()));
                    continue;
                }
                if (!currentEntryName.toLowerCase().endsWith("merepmeta.xml")) continue;
                if (this.trace.isLogging(90)) {
                    this.trace.log(90, "Found 'meRepMeta.XML' within the jar-file");
                }
                SmartSyncDeplAdapter d = (SmartSyncDeplAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.DeplAdapterImpl");
                applicationInfo.setUsingSmartSync(true);
                d.setMetaDataFile(applicationInfo.getName(), zip, jarFileEntry);
                ConversationId convidShared = ConversationIdHandler.getInstance().getConversationId(applicationInfo, UserManagerImpl.getSharedUser());
                ConversationId[] cis = ConversationIdHandler.getInstance().getAllConversationIdsForApplication(applicationInfo);
                if (convidShared == null || cis.length <= 1) continue;
                d.processMetaData(convidShared);
            }
            zip.close();
        }
        catch (IOException ioex) {
            AppLog.getInstance("MI/Deployment").logException("Error while installing an AWT application (cannot open jar file " + jarFile.getAbsolutePath() + "); check the application archive", (Throwable)ioex, true);
        }
    }

    private File downloadInstallationFile(MobileSolutionDescriptor applicationInfo, String urlString) throws HttpConnectionException, InstallationException {
        Configuration config = Configuration.getInstance();
        String libfolder = config.getProperty("MobileEngine.InstallationPath") + File.separator + "lib" + File.separator;
        File jarFile = new File(libfolder + applicationInfo.getName() + applicationInfo.getVersion() + ".jar");
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "Install application jar into ''{0}''", (Object)libfolder);
            this.trace.log(90, "Destination file for download is {0} ", (Object)jarFile.getAbsolutePath());
        }
        if (!applicationInfo.isInstallationFileAlreadyDownloaded()) {
            this.log.addLogEntry("Retrieving application " + applicationInfo.getName() + " from  " + urlString);
            SyncSettings.updateSystemProxySettings();
            IOUtils.httpGet(urlString, jarFile.getAbsolutePath());
            return jarFile;
        }
        String localfile = applicationInfo.getCustomizingValueForKey("LOCALPATH");
        this.trace.log(80, "Installation: Using already downloaded application file: " + localfile);
        this.log.addLogEntry("Installation: Using already downloaded application file: " + localfile);
        File newfile = new File(localfile);
        if (IOUtils.moveFileToDirectory(newfile, new File(libfolder))) {
            return new File(libfolder.concat(newfile.getName()));
        }
        throw new InstallationException(7, null, null);
    }
}

