/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.conf.MEVersion;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.runtime.Application;
import com.sap.ip.me.api.runtime.BatchSupport;
import com.sap.ip.me.api.runtime.jsp.ApplicationHandler;
import com.sap.ip.me.api.services.BufferedUTF8Writer;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.apps.InstallationScenario;
import com.sap.ip.me.core.ApplicationNotAvailableException;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.DeviceAttributeInboundProcessor;
import com.sap.ip.me.core.FrameworkApplicationType;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.InstallationLog;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.StatusUpdater;
import com.sap.ip.me.core.UnknownApplicationTypeException;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.spi.smartsync.SmartSyncAdapter;
import com.sap.ip.mi.ci.ClientInstallerStarter;
import com.sapmarkets.web.liTS.util.reg.RegistrySyncInboundProcessing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ApplicationManager
extends ApplicationHandler {
    public static final int START_OK = 0;
    public static final int LANGUAGE_NOT_SUPPORTED = 1;
    private static final String REG_SYNC_METHOD = "WAF_REGISTRY";
    private static final String REG_DEVICEINFO_METHOD = "DEVICEINFO";
    private static final String ISINIT_KEY = "MobileEngine.Reg.AlreadyInitialized";
    private final String REGISRTY_FILE = "MobileEngine.Registry";
    private final Trace trace = Trace.getInstance("MI/Core");
    SmartSyncAdapter sa;
    private static ApplicationManager instance;
    private Hashtable startedApplications;
    private Application currentApplication;
    private MobileSolutionDescriptor currentMSD;
    private MobileSolutionDescriptor temporaryMSD;
    private Thread temporaryMSDThread;
    private Vector mobileSolutionDescriptors;
    private String frameworkName;
    private Boolean newInstallationPackage = null;

    public ApplicationManager() {
        if (instance != null) {
            throw new RuntimeException("ApplicationManager already initialized");
        }
        instance = this;
        this.startedApplications = new Hashtable();
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "Set current application to 'Framework'");
        }
        try {
            this.loadMobileSolutionDescriptors();
        }
        catch (FileNotFoundException fnfex) {
            Configuration config = Configuration.getInstance();
            if (config.getBoolean(ISINIT_KEY, false)) {
                AppLog.getInstance("MI/Core").log(50, "Exception while loading application registry (file not found); check the device");
            } else {
                this.trace.log(70, "Application registry file cannot be found; empty registry created");
                config.setDefaultProperty(ISINIT_KEY, "true");
            }
            this.mobileSolutionDescriptors = new Vector();
        }
        catch (Exception ioex) {
            AppLog.getInstance("MI/Core").logException(50, "Error while loading application registry, empty registry created; check the device", ioex, true);
            this.mobileSolutionDescriptors = new Vector();
        }
        String frameworkname = this.getFrameworkName();
        MobileSolutionDescriptor appl = this.getMobileSolutionDescriptor(frameworkname);
        if (appl == null) {
            appl = new MobileSolutionDescriptor("", frameworkname, MEVersion.getInitialMainVersion(), "Framework", new FrameworkApplicationType(), "", false, true, false);
            appl.setSharedDataVisible(true);
            this.registerMobileSolutionDescriptor(appl);
        } else if (!appl.getVersion().equals(MEVersion.getInitialMainVersion())) {
            this.mobileSolutionDescriptors.removeElement(appl);
            appl = new MobileSolutionDescriptor("", frameworkname, MEVersion.getInitialMainVersion(), "Framework", new FrameworkApplicationType(), "", false, true, false);
            appl.setSharedDataVisible(true);
            this.registerMobileSolutionDescriptor(appl);
        }
        this.currentMSD = this.getFrameworkMobileSolutionDescriptor();
        this.currentApplication = null;
        InboundProcessorRegistry inboundreg = InboundProcessorRegistry.getInstance();
        RegistrySyncInboundProcessing sip = new RegistrySyncInboundProcessing(REG_SYNC_METHOD);
        inboundreg.register(sip);
        DeviceAttributeInboundProcessor d = new DeviceAttributeInboundProcessor("", REG_DEVICEINFO_METHOD);
        inboundreg.register(d);
        this.sa = (SmartSyncAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.SmartSyncAdapterImpl");
    }

    public static ApplicationManager getInstance() {
        return (ApplicationManager)ApplicationHandler.getSingleton();
    }

    public static boolean isNewInstallationPackageAvailable() {
        boolean result = false;
        boolean suppressUI = Configuration.getInstance().getBoolean("MI.ClientInstaller.SuppressUserInteraction", false);
        if (ApplicationManager.instance.newInstallationPackage == null) {
            MobileSolutionDescriptor[] msds = instance.getMobileSolutionDescriptors();
            int i = 0;
            while (i < msds.length && !result) {
                if (msds[i].isClientInstallerArchive() && (result = msds[i].isIncomplete()) && suppressUI) {
                    ClientInstallerStarter.startClientInstaller();
                    result = false;
                    break;
                }
                ++i;
            }
        }
        ApplicationManager.instance.newInstallationPackage = result ? Boolean.TRUE : Boolean.FALSE;
        return result;
    }

    public static void executeInstallationPackage() {
        ClientInstallerStarter.startClientInstaller();
    }

    public static void scheduleInstallationPackage() {
        ApplicationManager.instance.newInstallationPackage = Boolean.FALSE;
    }

    public void registerStatusUpdater() {
        StatusUpdater updater = new StatusUpdater();
        UserManagerImpl.getUserManagerImplInstance().addLogonListener(updater);
        SyncEventRegistry.getInstance().addSyncEventListener(updater);
    }

    public void updateClientInstallerArchiveStates() {
        MobileSolutionDescriptor[] msds = this.getMobileSolutionDescriptors();
        int i = 0;
        while (i < msds.length) {
            if (msds[i].isClientInstallerArchive() && msds[i].isIncomplete()) {
                this.updateStatus(msds[i]);
            }
            ++i;
        }
    }

    public void updateStatus(MobileSolutionDescriptor msd) {
        StringBuffer sb = new StringBuffer(150);
        sb.append(ClientInstallerStarter.getClientInstallerHome()).append(File.separatorChar);
        sb.append("archives").append(File.separatorChar);
        sb.append(msd.getName()).append(File.separatorChar);
        sb.append(msd.getVersion()).append(File.separatorChar);
        String dir = sb.toString();
        sb.append("finished.txt");
        File f = new File(sb.toString());
        if (f.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF8"));
                String status = reader.readLine();
                String msg = reader.readLine();
                reader.close();
                if (status.startsWith("S")) {
                    msd.setInstalled(true);
                    msd.setIncomplete(false);
                    this.trace.log(70, "Successfully installed application {0}", (Object)msd);
                    String[] files = msd.getInstalledFiles();
                    int j = 0;
                    while (j < files.length) {
                        f = new File(files[j]);
                        if (f.exists()) {
                            boolean success = false;
                            success = !f.isDirectory() ? f.delete() : IOUtils.deleteDirectoryRecursively(f, true);
                            if (success) {
                                this.trace.log(90, "Successfully deleted installation file / folder {0}", (Object)f.getAbsolutePath());
                                msd.removeInstalledFile(files[j]);
                            } else {
                                this.trace.log(90, "Cannot delete installation file / folder {0}", (Object)f.getAbsolutePath());
                            }
                        }
                        ++j;
                    }
                } else if (status.startsWith("A")) {
                    msd.setInstallationFailed();
                    msd.setIncomplete(false);
                    this.trace.log(70, "Installation aborted for application {0} because of: {1}", (Object)msd, (Object)msg);
                }
                InstallationLog.sendInstalltionLogFileToR3(dir + "install.log", msd);
                this.saveMobileSolutionDescriptors();
            }
            catch (Exception ex) {
                this.trace.logException(60, "Cannot update installation status", ex, true);
            }
        }
    }

    public Application startApplication(String appName) throws ApplicationNotAvailableException {
        this.trace.log(80, "Start application {0}", (Object)(appName == null ? "" : appName));
        if (appName != null && ("mobile_engine".equalsIgnoreCase(appName) || "me_settings".equalsIgnoreCase(appName) || "me_trace".equalsIgnoreCase(appName))) {
            this.deactivateCurrentApplication();
            return null;
        }
        Application app = (Application)this.startedApplications.get(appName.toLowerCase());
        MobileSolutionDescriptor msd = app != null ? this.getMobileSolutionDescriptor(appName, null, app) : this.getMobileSolutionDescriptor(appName);
        if (msd == null) {
            throw new ApplicationNotAvailableException(appName, "it", "there is no MSD for this application name");
        }
        if (app == null) {
            app = msd.getApplication();
            this.startedApplications.put(appName.toLowerCase(), app);
            this.trace.log(90, "call init application");
            app.initApplication();
        }
        this.activateApplication(app, msd);
        return app;
    }

    public void deactivateCurrentApplication() {
        if (this.currentApplication != null) {
            this.currentApplication.deactivateApplication();
            if (this.trace.isLogging(90)) {
                this.trace.log(90, "Deactivated application {0}", (Object)this.currentApplication.getApplicationName());
            }
        }
        this.currentApplication = null;
        this.setCurrentMSD(this.getFrameworkMobileSolutionDescriptor());
        this.sa.applicationDeactivated();
    }

    public void registerApplication(String applicationName, Application app) {
        MobileSolutionDescriptor msd = this.getMobileSolutionDescriptor(applicationName, null, app);
        if (msd == null) {
            throw new RuntimeException(applicationName + " cannot be started because there is no MSD for this application name");
        }
        if (this.startedApplications.get(applicationName.toLowerCase()) == null) {
            this.startedApplications.put(applicationName.toLowerCase(), app);
            app.initApplication();
        }
        this.activateApplication(app, msd);
    }

    public boolean applicationHasAlreadyBeenStarted(String applicationName) {
        Enumeration elements = this.startedApplications.elements();
        while (elements.hasMoreElements()) {
            if (!((Application)elements.nextElement()).getApplicationName().equalsIgnoreCase(applicationName)) continue;
            return true;
        }
        return false;
    }

    public void registerMobileSolutionDescriptor(MobileSolutionDescriptor newApplication) {
        AppLog applog = AppLog.getInstance("MI/Core");
        if (newApplication == null) {
            applog.log(50, "Cannot register 'null' application. Current application is not changed.");
            return;
        }
        this.trace.log(80, "Try to register ApplicationInfo: {0}", (Object)newApplication.toString());
        MobileSolutionDescriptor old = this.getMobileSolutionDescriptor(newApplication.getName());
        boolean addElement = true;
        if (old != null) {
            applog.log(60, "There exists a registry entry for application ''{0}'' already", (Object)newApplication.getName());
            if (old.getVersion().equals(newApplication.getVersion())) {
                addElement = false;
            }
        }
        if (addElement) {
            this.mobileSolutionDescriptors.addElement(newApplication);
            try {
                this.saveMobileSolutionDescriptors();
                applog.log(70, "Application ''{0}'' (Version {1}) successfully registered", (Object)newApplication.getName(), (Object)newApplication.getVersion());
            }
            catch (IOException io) {
                String message = "Cannot write application registry";
                applog.logException(10, message, io, true);
                throw new RuntimeException(message);
            }
        }
    }

    public MobileSolutionDescriptor getInstallationSequence() {
        MeIteratorVectorImpl msdIterator = new MeIteratorVectorImpl(this.getMSDsToBeInstalled());
        while (msdIterator.hasNext()) {
            MobileSolutionDescriptor nextMSD = (MobileSolutionDescriptor)msdIterator.next();
            if (!(nextMSD instanceof InstallationScenario)) continue;
            return nextMSD;
        }
        return null;
    }

    public void unregisterMobileSolutionDescriptor(MobileSolutionDescriptor application) {
        AppLog applog = AppLog.getInstance("MI/Core");
        if (application == null) {
            applog.log(50, "Cannot unregister 'null' application");
            return;
        }
        this.mobileSolutionDescriptors.removeElement(application);
        try {
            this.saveMobileSolutionDescriptors();
            applog.log(70, "Application ''{0}'' (Version {1}) successfully unregistered", (Object)application.getName(), (Object)application.getVersion());
        }
        catch (IOException io) {
            String message = "Cannot write application registry";
            applog.logException(10, message, io, true);
            throw new RuntimeException(message);
        }
    }

    public MobileSolutionDescriptor getMobileSolutionDescriptor(String name, String version, Application instance) {
        MobileSolutionDescriptor a = null;
        boolean found = false;
        Enumeration e = this.mobileSolutionDescriptors.elements();
        while (e.hasMoreElements() && !found) {
            a = (MobileSolutionDescriptor)e.nextElement();
            boolean bl = found = a.getName().equalsIgnoreCase(name) && (version == null || a.getVersion().equalsIgnoreCase(version)) || instance != null && instance.getClass().getName().equals(a.getTargetClassname());
        }
        return found ? a : null;
    }

    public MobileSolutionDescriptor getMobileSolutionDescriptor(String name, String version) {
        return this.getMobileSolutionDescriptor(name, version, null);
    }

    public MobileSolutionDescriptor[] getMobileSolutionDescriptors() {
        Object[] apps = new MobileSolutionDescriptor[this.mobileSolutionDescriptors.size()];
        this.mobileSolutionDescriptors.copyInto(apps);
        return apps;
    }

    public MobileSolutionDescriptor getMobileSolutionDescriptor(String name) {
        return this.getMobileSolutionDescriptor(name, null, null);
    }

    public void cleanUpIncompleteApplications() {
        MobileSolutionDescriptor[] apps = this.getApplicationsToBeDeleted();
        InstallationScenario is = (InstallationScenario)this.getInstallationSequence();
        int i = 0;
        while (i < apps.length) {
            MobileSolutionDescriptor appInfo = apps[i];
            if (appInfo != null && !(appInfo instanceof InstallationScenario)) {
                if (is != null && is.isMSDPartOfInstallationScenario(appInfo) && !is.isInstalled()) {
                    Trace.getInstance("MI/Core").log(70, "ApplicationManager.cleanUpIncompleteApplications not cleaning up " + appInfo.getName() + " because it is part of IS " + is.getName());
                } else {
                    this.cleanUpMSD(appInfo);
                }
            }
            ++i;
        }
    }

    public void saveMobileSolutionDescriptors() throws IOException {
        Configuration config = Configuration.getInstance();
        String folder = Configuration.getSettingsFolder();
        String reg = config.getProperty("MobileEngine.Registry");
        StringBuffer regFilename = new StringBuffer(folder.length() + reg.length());
        regFilename.append(folder).append(reg);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(regFilename.toString()));
        out.writeObject(this.mobileSolutionDescriptors);
        out.flush();
        out.close();
    }

    public MobileSolutionDescriptor getFrameworkMobileSolutionDescriptor() {
        return this.getMobileSolutionDescriptor(this.getFrameworkName());
    }

    public String getFrameworkName() {
        if (this.frameworkName != null) {
            return this.frameworkName;
        }
        this.frameworkName = "MOBILEENGINE_JSP";
        if (Configuration.getInstance().getProperty("Runtime", "").equalsIgnoreCase("awt")) {
            this.frameworkName = "MOBILEENGINE_AWT";
        }
        return this.frameworkName;
    }

    public MobileSolutionDescriptor getMobileSolutionDescriptorById(String id) {
        String aid;
        MobileSolutionDescriptor a = null;
        boolean found = false;
        Enumeration e = this.mobileSolutionDescriptors.elements();
        while (e.hasMoreElements() && !found) {
            a = (MobileSolutionDescriptor)e.nextElement();
            aid = a.getId();
            found = aid.equals(id);
        }
        if (!found) {
            e = this.mobileSolutionDescriptors.elements();
            while (e.hasMoreElements() && !found) {
                a = (MobileSolutionDescriptor)e.nextElement();
                aid = a.getId();
                if (!id.startsWith(aid = aid.substring(0, aid.length() - a.getVersion().length()))) continue;
                boolean bl = found = id.length() - aid.length() <= 6;
            }
        }
        return found ? a : null;
    }

    public int checkStartable(String appName, String namespace, String version) {
        MobileSolutionDescriptor msd = this.getMobileSolutionDescriptor(appName, version);
        if (msd == null) {
            return 1;
        }
        return this.checkStartable(msd);
    }

    public int checkStartable(MobileSolutionDescriptor msd) {
        if (msd.getSupportedLanguages() == null) {
            return 0;
        }
        boolean languageCheckOn = Configuration.getInstance().getBoolean("MobileEngine.Setting.LanguageCheck", true);
        boolean currentLanguageSupported = true;
        if (languageCheckOn) {
            String language = Localization.getLanguage();
            String s = msd.getPropertyValueForKey(language);
            if (s == null) {
                currentLanguageSupported = false;
            } else if (s.length() == 0) {
                currentLanguageSupported = false;
            }
            if (!currentLanguageSupported) {
                return 1;
            }
        }
        return 0;
    }

    public void installApplication(MobileSolutionDescriptor msd) throws InstallationException, UnknownApplicationTypeException {
        MobileSolutionDescriptor oldmsd;
        msd.getType().install(msd.getInstallationUrl(), msd);
        if (!msd.isClientInstallerArchive()) {
            msd.setInstalled(true);
            msd.setIncomplete(false);
        }
        if (msd.isInstalled()) {
            DeploymentInbox.getInstance().addMSDToListOfLastInstalled(msd);
        }
        if ((oldmsd = this.getMobileSolutionDescriptor(msd.getName())) != null && msd.getVersion().equalsIgnoreCase(oldmsd.getVersion())) {
            try {
                this.saveMobileSolutionDescriptors();
            }
            catch (IOException e) {
                this.trace.logException(e);
            }
        } else {
            this.registerMobileSolutionDescriptor(msd);
        }
    }

    public Vector getMSDsToBeInstalled() {
        Enumeration e = this.mobileSolutionDescriptors.elements();
        Vector<MobileSolutionDescriptor> v = new Vector<MobileSolutionDescriptor>(5);
        while (e.hasMoreElements()) {
            MobileSolutionDescriptor msd = (MobileSolutionDescriptor)e.nextElement();
            if (msd.isInstalled()) continue;
            v.addElement(msd);
        }
        return v;
    }

    public MobileSolutionDescriptor getCurrentMSD() {
        if (this.temporaryMSD == null) {
            return this.currentMSD;
        }
        if (this.temporaryMSDThread != Thread.currentThread()) {
            return this.currentMSD;
        }
        return this.temporaryMSD;
    }

    public void resetNewInstallationPackageFlag() {
        this.newInstallationPackage = null;
    }

    public boolean isApplicationDeployedForUser(MobileSolutionDescriptor msd, User u) {
        MobileSolutionDescriptor[] msds = ConversationIdHandler.getInstance().getAllMobileSolutionDescriptorsForUser(u);
        int i = 0;
        while (i < msds.length) {
            if (msds[i].equals(msd)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void activateApplication(Application app) {
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "activateApplication() {0}", (Object)app.toString());
        }
        if (app == null) {
            throw new NullPointerException();
        }
        MobileSolutionDescriptor msd = this.getMobileSolutionDescriptor(app.getApplicationName(), null, app);
        this.activateApplication(app, msd);
    }

    protected void register(String applicationName, Application app) {
        this.registerApplication(applicationName, app);
    }

    Application startBatchApplication(String appName) throws ApplicationNotAvailableException {
        Application result = this.startApplication(appName);
        if (result != null && result instanceof BatchSupport) {
            BatchSupport bs = (BatchSupport)((Object)result);
            bs.startBatch();
            Vector batchresult = bs.getBatchResult();
            if (batchresult == null) {
                return null;
            }
            try {
                String instbase = Configuration.getInstallationDirectory();
                StringBuffer fname = new StringBuffer(instbase.length() + 16);
                fname.append(instbase).append(File.separatorChar).append("batchresult.txt");
                BufferedUTF8Writer bw = new BufferedUTF8Writer(fname.toString(), true);
                Enumeration enumeration = batchresult.elements();
                bw.write("Results of the batch application '");
                bw.write(appName);
                bw.write(39);
                bw.newLine();
                Object element = null;
                while (enumeration.hasMoreElements()) {
                    element = enumeration.nextElement();
                    if (element != null) {
                        bw.write(element.toString());
                    } else {
                        bw.write("(null)");
                    }
                    bw.newLine();
                }
                bw.write("End of batch ");
                bw.write(appName);
                bw.write("'  ----------------- ");
                bw.newLine();
                bw.flush();
                bw.close();
            }
            catch (Exception ex) {
                AppLog.getInstance("MI/Core").logException("Cannot save the batch results", (Throwable)ex, true);
                result = null;
            }
        }
        return result;
    }

    void destroyAllRunningApplications() {
        this.currentApplication = null;
        this.setCurrentMSD(this.getFrameworkMobileSolutionDescriptor());
        Enumeration applications = this.startedApplications.elements();
        Application app = null;
        while (applications.hasMoreElements()) {
            try {
                app = (Application)applications.nextElement();
                app.destroyApplication();
            }
            catch (Exception ex) {
                AppLog.getInstance("MI/Core").logException(50, "Cannot destroy application {0} because: {1}", new Object[]{app == null ? "(null)" : app.getApplicationName(), ex.getMessage()}, ex, true);
            }
        }
        this.startedApplications.clear();
    }

    void _unregisterAllMobileSolutionDescriptor() {
        this.mobileSolutionDescriptors.removeAllElements();
        try {
            this.saveMobileSolutionDescriptors();
            this.trace.log(70, "All applications successfully unregistered");
        }
        catch (IOException io) {
            this.trace.logException("Cannot write Registry file", (Throwable)io, true);
        }
    }

    MobileSolutionDescriptor setTemporaryMSD(MobileSolutionDescriptor tempMSD) {
        if (tempMSD != null && this.getMobileSolutionDescriptorById(tempMSD.getId()) == null) {
            throw new IllegalArgumentException("Cannot set unknown MSD (" + tempMSD.toString() + ") as temporary MSD");
        }
        MobileSolutionDescriptor oldTempMSD = this.temporaryMSD;
        this.temporaryMSD = tempMSD;
        this.temporaryMSDThread = tempMSD != null ? Thread.currentThread() : null;
        return oldTempMSD;
    }

    private MobileSolutionDescriptor[] getApplicationsToBeDeleted() {
        MobileSolutionDescriptor[] appsToBeDeleted = new MobileSolutionDescriptor[this.mobileSolutionDescriptors.size()];
        Enumeration e = this.mobileSolutionDescriptors.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            MobileSolutionDescriptor msd = (MobileSolutionDescriptor)e.nextElement();
            if (!msd.isIncomplete() || msd.isClientInstallerArchive()) continue;
            appsToBeDeleted[i] = msd;
            ++i;
        }
        if (i > 0) {
            return appsToBeDeleted;
        }
        MobileSolutionDescriptor[] empty = new MobileSolutionDescriptor[]{};
        return empty;
    }

    private void cleanUpMSD(MobileSolutionDescriptor appInfo) {
        try {
            appInfo.getType().uninstall(appInfo);
            this.unregisterMobileSolutionDescriptor(appInfo);
        }
        catch (UnknownApplicationTypeException uapptype) {
            StringBuffer sb = new StringBuffer(80);
            sb.append("Cannot uninstall application '").append(appInfo.getName()).append("' (Version '");
            sb.append(appInfo.getVersion()).append("'):");
            AppLog.getInstance("MI/Core").logException(60, sb.toString(), uapptype, true);
        }
        catch (InstallationException instex) {
            StringBuffer sb = new StringBuffer(80);
            sb.append("Cannot uninstall application '").append(appInfo.getName()).append("' (Version '");
            sb.append(appInfo.getVersion()).append("'):");
            AppLog.getInstance("MI/Core").logException(60, sb.toString(), instex, true);
        }
    }

    private void activateApplication(Application app, MobileSolutionDescriptor msd) {
        boolean activate = true;
        if (this.currentApplication != null) {
            if (this.currentApplication.equals(app)) {
                activate = false;
            } else {
                this.deactivateCurrentApplication();
            }
        }
        this.currentApplication = app;
        this.currentMSD = msd;
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "Set current application to ''{0}''", (Object)msd.getName());
        }
        if (activate) {
            if (this.trace.isLogging(80)) {
                String appname = msd.getName();
                StringBuffer sb = new StringBuffer(21 + (appname == null ? 4 : appname.length()));
                sb.append("Activate application ").append(appname);
                this.trace.log(80, sb.toString());
            }
            this.sa.applicationActivated();
            this.currentApplication.activateApplication();
        }
    }

    private Application getApplicationForName(String appName) throws ApplicationNotAvailableException {
        MobileSolutionDescriptor ai = this.getMobileSolutionDescriptor(appName);
        if (ai != null) {
            return ai.getApplication();
        }
        throw new ApplicationNotAvailableException(appName, "no target class", null);
    }

    private void loadMobileSolutionDescriptors() throws IOException, ClassNotFoundException {
        Configuration config = Configuration.getInstance();
        String folder = Configuration.getSettingsFolder();
        String reg = config.getProperty("MobileEngine.Registry");
        StringBuffer regFilename = new StringBuffer(folder.length() + reg.length());
        regFilename.append(folder).append(reg);
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(regFilename.toString()));
        this.mobileSolutionDescriptors = (Vector)in.readObject();
    }

    private void setCurrentMSD(MobileSolutionDescriptor newMSD) {
        if (this.temporaryMSD != null && !newMSD.equals(this.currentMSD)) {
            this.trace.log(60, "MSD switch while temporary MSD is set. Current temporary MSD is {0}, current MSD is {1} and new MSD is {2}", this.temporaryMSD, this.currentMSD, newMSD);
        }
        if (!newMSD.equals(this.currentMSD)) {
            this.trace.log(80, "Set current MSD to " + newMSD.toString());
        }
        this.currentMSD = newMSD;
    }
}

