/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.deploy.AddOnInstaller;
import com.sap.ip.me.api.deploy.ClassPathManager;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.apps.DeploymentInstallLog;
import com.sap.ip.me.core.Addon;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.CleanupListWriter;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.InstallationLog;
import com.sap.ip.me.core.JarClassLoader;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UnknownApplicationTypeException;
import com.sap.ip.me.services.os.PIOSConfigAgent;
import com.sap.ip.mi.ci.ClientInstallerStarter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AddonApplicationType
implements ApplicationType {
    private static final String PIOS_CONFIG_UPDATE = "PIOS_CONFIG_UPDATE";
    private static final String CLIENT_INSTALLER_PACKAGE = "PatchArchive";
    private static final String TO_GLOBAL_LIB_DIRECTORY = "GLOBALLIB";
    private static final String EXCTRACTIONFOLDER = "INSTALLATIONDIR";
    private static final String CONFIGURATION_UPDATE = "CONFIGUPDATE";
    private static final String ADDONINSTALLER_CLASS = "ADDONINSTALLER_CLASS";
    private static final String INSTALLERDIR = "addoninstallers";
    private final Trace trace = Trace.getInstance("MI/Deployment");
    private boolean toGlobalLib = true;
    private DeploymentMessages deplLog = DeploymentMessages.getInstance();
    private InstallationLog log = new InstallationLog("LOG");
    private Properties manifestFile;
    private ZipFile zip;

    public void install(String source, MobileSolutionDescriptor applicationInfo) throws InstallationException {
        this.log.addLogEntry("Retrieving addon application " + applicationInfo.getName() + " from  " + source);
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "Installation: Link sent from backend is ''{0}''", (Object)source);
        }
        File addonFile = null;
        addonFile = this.downloadInstallationFile(source, applicationInfo, addonFile);
        this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "INSTALLING", applicationInfo.getName() + " " + applicationInfo.getVersion() + ": " + applicationInfo.getDescription());
        this.extractInstallationFile(applicationInfo, addonFile);
        this.deleteFile(addonFile);
        applicationInfo.setVisible(false);
        this.log.addLogEntry("Installation of " + applicationInfo.getName() + " completed successfully");
        this.putDeploymentInstallLogToInbox(applicationInfo);
        this.log.sendToR3();
    }

    public void uninstall(MobileSolutionDescriptor application) throws InstallationException {
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "AddOn Application ''{0}'' will be unistalled", (Object)application.getName());
        }
        this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLING", application.getName() + " " + application.getVersion() + " " + application.getDescription());
        try {
            if (application.getType() instanceof AddonApplicationType) {
                this.callExternalUnInstaller(application);
            }
            this.deleteMSDFiles(application);
        }
        catch (UnknownApplicationTypeException uaex) {
            AppLog.getInstance("MI/Core").logException(50, "Cannot get application type for addon application " + application.getName(), uaex, true);
            throw new InstallationException("Cannot get application type for addon application " + application.getName(), uaex);
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/Core").logException(50, "Could not call external Uninstaller for addon application " + application.getName(), ex, true);
            throw new InstallationException("Could not call external Uninstaller for addon application " + application.getName(), ex);
        }
        try {
            ApplicationManager.getInstance().saveMobileSolutionDescriptors();
        }
        catch (IOException ioex) {
            AppLog.getInstance("MI/Core").logException(50, "Cannot write application registry", ioex, true);
            throw new InstallationException("Cannot write application registry", ioex);
        }
    }

    public String toString() {
        return "ADDON";
    }

    public void putFileIntoClasspath(File f) {
        if (Configuration.getInstance().getBoolean("MobileEngine.Deployment.UpdateJarList", false)) {
            this.updateListOfJars(f.getAbsolutePath(), false);
        }
    }

    public void takeFileOutOfClasspath(File f) {
        if (Configuration.getInstance().getBoolean("MobileEngine.Deployment.UpdateJarList", false)) {
            this.updateListOfJars(f.getAbsolutePath(), true);
        }
    }

    private String getCIHOME() {
        return ClientInstallerStarter.getClientInstallerHome();
    }

    private void putDeploymentInstallLogToInbox(MobileSolutionDescriptor applicationInfo) {
        DeploymentInstallLog d = new DeploymentInstallLog(applicationInfo.getName());
        d.appendLines(this.log.getLogEntries());
        DeploymentInbox.getInstance().setApplicationLog(d);
    }

    private boolean deleteFile(File f) {
        boolean success = f.delete();
        if (!success) {
            CleanupListWriter.writeToFile(f.getAbsolutePath().concat(File.pathSeparator));
        }
        return success;
    }

    private void updateListOfJars(String absoluteJarFilePath, boolean remove) {
        ClassPathManager jfm = ClassPathManager.getInstance();
        if (remove) {
            jfm.removeFromClassPath(absoluteJarFilePath);
        } else {
            jfm.addToClassPath(absoluteJarFilePath);
        }
    }

    private void deleteMSDFiles(MobileSolutionDescriptor application) {
        application.setIncomplete(true);
        boolean alldone = true;
        String[] files = application.getInstalledFiles();
        int i = 0;
        while (i < files.length) {
            File f = new File(files[i]);
            if (f.isFile() && this.deleteFile(f)) {
                application.removeInstalledFile(files[i]);
            }
            ++i;
        }
        int j = 0;
        while (j < files.length) {
            File f = new File(files[j]);
            if (f.isDirectory() && IOUtils.deleteDirectoryRecursively(f)) {
                application.removeInstalledFile(files[j]);
            }
            ++j;
        }
        File addonfolder = new File(this.getExtractionFolderForAddOn(application));
        if (addonfolder.exists()) {
            IOUtils.deleteDirectoryRecursively(addonfolder);
        }
        if (alldone) {
            ApplicationManager.getInstance().unregisterMobileSolutionDescriptor(application);
        }
    }

    private void extractInstallationFile(MobileSolutionDescriptor applicationInfo, File addonFile) throws InstallationException {
        try {
            this.zip = new ZipFile(addonFile.getAbsolutePath());
            this.manifestFile = this.getManifestFile(this.zip);
            String extractionfolder = this.getInstallationFolder(this.manifestFile);
            boolean configUpdate = this.isItAConfigurationUpdate(this.manifestFile);
            boolean piosUpdate = this.isItAPIOSConfigurationUpdate(this.manifestFile);
            boolean installerPackage = this.isItAInstallerPackage(this.manifestFile);
            if (extractionfolder.length() == 0) {
                extractionfolder = this.getExtractionFolderForAddOn(applicationInfo);
                this.toGlobalLib = false;
            }
            Enumeration<? extends ZipEntry> addonFileEntries = this.zip.entries();
            while (addonFileEntries.hasMoreElements()) {
                ZipEntry addonFileEntry = addonFileEntries.nextElement();
                if (addonFileEntry.getName().toLowerCase().endsWith("meta-inf/manifest.mf")) continue;
                String filename = addonFileEntry.getName().replace('/', File.separatorChar);
                String filepath = extractionfolder.concat(filename);
                File currentlyExtractedFile = null;
                if (addonFileEntry.isDirectory()) {
                    if (!installerPackage || configUpdate) {
                        currentlyExtractedFile = new File(filepath);
                        currentlyExtractedFile.mkdirs();
                    }
                } else if (!installerPackage || installerPackage && configUpdate && filepath.endsWith(".config")) {
                    currentlyExtractedFile = IOUtils.extractZipFile(this.zip, addonFileEntry, filepath);
                } else if (addonFileEntry.getName().startsWith("Installer/")) {
                    currentlyExtractedFile = IOUtils.extractZipFile(this.zip, addonFileEntry, filepath);
                    File f = new File(this.getCIHOME());
                    IOUtils.moveFileToDirectory(currentlyExtractedFile, f);
                }
                if (!installerPackage) {
                    applicationInfo.addInstalledFile(filepath);
                }
                if (this.toGlobalLib && Configuration.getInstance().getBoolean("MobileEngine.Deployment.UpdateJarList", false) && new File(filepath).isFile()) {
                    this.updateListOfJars(filepath, false);
                }
                if (configUpdate && filepath.endsWith(".config")) {
                    Properties p = new Properties();
                    p.load(new FileInputStream(filepath));
                    this.updateDefaultClientConfiguration(p);
                }
                if (piosUpdate && filepath.endsWith(".cfg")) {
                    Properties piosProps = new Properties();
                    piosProps.load(new FileInputStream(filepath));
                    PIOSConfigAgent.updatePIOSConfig(piosProps);
                }
                if (installerPackage || !filepath.toLowerCase().endsWith(".cab")) continue;
                this.callWinCELoaderForFile(new File(filepath));
            }
            this.zip.close();
            if (installerPackage) {
                this.moveAddOnToCI_HOME(applicationInfo, addonFile);
                applicationInfo.setClientInstallerArchive();
                applicationInfo.setIncomplete(true);
            }
            this.callExternalInstaller(applicationInfo);
        }
        catch (IOException ioex) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.log.addLogEntry(ioex.getMessage());
            this.log.addLogEntry("Application.install: Failed to extract addon installation file for " + applicationInfo.getName() + " " + applicationInfo.getVersion());
            AppLog.getInstance("MI/Core").logException(50, "Installation: Failed to extract installation file from ''" + applicationInfo.getName() + " " + applicationInfo.getVersion() + "''", ioex, true);
            throw new InstallationException(8, null, null);
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/Core").logException("Problems while loading external installer of ADDON", (Throwable)ex, true);
            throw new InstallationException("Problems while loading external installer of ADDON", ex);
        }
    }

    private void moveAddOnToCI_HOME(MobileSolutionDescriptor applicationInfo, File addonFile) {
        String cihomePath = this.getCIHOME();
        String addonpath = cihomePath.concat(File.separator).concat("archives").concat(File.separator).concat(applicationInfo.getName()).concat(File.separator).concat(applicationInfo.getVersion()).concat(File.separator);
        File ciHomeAddOnDir = new File(addonpath);
        if (!ciHomeAddOnDir.exists()) {
            ciHomeAddOnDir.mkdirs();
        }
        IOUtils.moveFileToDirectory(addonFile, ciHomeAddOnDir);
        applicationInfo.addInstalledFile(ciHomeAddOnDir.getAbsolutePath() + File.separatorChar + addonFile.getName());
        applicationInfo.addInstalledFile(ciHomeAddOnDir.getAbsolutePath());
    }

    private boolean isItAInstallerPackage(Properties manifestFile2) {
        return this.manifestFile.getProperty(CLIENT_INSTALLER_PACKAGE, "").equals("X");
    }

    private String getExtractionFolderForAddOn(MobileSolutionDescriptor msd) {
        String addonFolder = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "addons" + File.separator;
        return addonFolder.concat(msd.getName()).concat(File.separator);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void callExternalInstaller(MobileSolutionDescriptor msd) throws Exception {
        String installerName = this.getAddOnInstallerClassname(this.manifestFile);
        if ("".equals(installerName)) {
            this.trace.log(80, "There is no external installer for AddOn " + msd.getName());
            return;
        }
        this.trace.log(80, "Trying to load external Installer with name " + installerName);
        JarClassLoader jcl = new JarClassLoader(this.zip.getName());
        this.trace.log(90, "Trying to load external Installer via classloader " + jcl);
        Class c = jcl.loadClass(installerName);
        this.trace.log(90, "Trying to call external Installer via class " + c);
        Object installer = c.newInstance();
        this.trace.log(90, "Trying to call external Installer via object " + installer);
        if (installer instanceof AddOnInstaller) {
            this.trace.log(90, installer + " is instance of AddOnInstaller");
            ((AddOnInstaller)installer).install(msd.getInstalledFiles());
            File original = new File(this.zip.getName());
            String originalFileName = this.zip.getName().substring(this.zip.getName().lastIndexOf(File.separator) + 1, this.zip.getName().length());
            File copy = new File(Configuration.getSettingsFolder().concat(INSTALLERDIR).concat(File.separator).concat(originalFileName));
            IOUtils.copyFile(original, copy, 1024);
            Addon addon = new Addon(msd.getNamespace(), msd.getName(), msd.getVersion());
            addon.setInstallerClassName(installerName);
            addon.setInstallationZipFilePath(copy.getAbsolutePath());
            IOUtils.serializeObjectToFile(new File(this.getInstallerFileName(msd)), addon);
            return;
        }
        this.trace.log(90, installer + " is not an instance of AddOnInstaller, therefore no call is done !!! ");
        throw new Exception(installerName + "is not an instance of AddOnInstaller");
    }

    private void callExternalUnInstaller(MobileSolutionDescriptor msd) throws Exception {
        File f = new File(this.getInstallerFileName(msd));
        if (f.exists()) {
            this.trace.log(80, f.getAbsolutePath() + " exists, trying to call external Installer");
            Object addon = IOUtils.readSerializedObjectFromFile(f);
            this.trace.log(90, "Reading external Installer information via addon object " + addon);
            if (addon instanceof Addon) {
                this.trace.log(90, addon + " is instance of Addon, reading info from object");
                this.trace.log(90, "Trying to create a JarClassLoader for file " + ((Addon)addon).getInstallationZipFilePath());
                JarClassLoader jcl = new JarClassLoader(((Addon)addon).getInstallationZipFilePath());
                this.trace.log(90, "Succesfully created JarClassLoader " + jcl);
                Class c = jcl.loadClass(((Addon)addon).getInstallerClassName());
                this.trace.log(90, "Loaded class " + c);
                Object installer = c.newInstance();
                this.trace.log(90, "Created new object " + installer);
                if (installer instanceof AddOnInstaller) {
                    this.trace.log(90, "Calling uninstall in object " + installer.getClass().getName().concat("@").concat(Integer.toHexString(installer.hashCode())));
                    ((AddOnInstaller)installer).uninstall(msd.getInstalledFiles());
                    this.deleteFile(f);
                    this.deleteFile(new File(((Addon)addon).getInstallationZipFilePath()));
                } else {
                    this.trace.log(90, installer.getClass().getName().concat("@").concat(Integer.toHexString(installer.hashCode())) + " is not an instance of AddOnInstaller");
                }
            }
        } else {
            this.trace.log(80, f.getAbsolutePath() + " does not exist, therefore no external installer will be called");
        }
    }

    private String getInstallerFileName(MobileSolutionDescriptor msd) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(Configuration.getSettingsFolder());
        sb.append(INSTALLERDIR);
        sb.append(File.separator);
        sb.append(msd.getNamespace());
        sb.append("_");
        sb.append(msd.getName());
        sb.append("_");
        sb.append(msd.getVersion());
        sb.append(".installer");
        return sb.toString();
    }

    private File downloadInstallationFile(String source, MobileSolutionDescriptor applicationInfo, File addonFile) throws InstallationException {
        File addonDir = null;
        String addonFolder = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "addons" + File.separator;
        addonDir = new File(addonFolder);
        if (!addonDir.exists()) {
            addonDir.mkdir();
        }
        if (!applicationInfo.isInstallationFileAlreadyDownloaded()) {
            String urlString = this.validateDownloadLink(source);
            if (this.trace.isLogging(80)) {
                this.trace.log(80, "Installation: Retrieving application ''{0}'' from ''{1}''", (Object)applicationInfo.getName(), (Object)urlString);
            }
            try {
                addonFile = new File(addonFolder + source.substring(source.lastIndexOf("/") + 1, source.length()));
                if (this.trace.isLogging(90)) {
                    this.trace.log(90, "Install addon application into ''{0}''", (Object)addonFolder);
                    this.trace.log(90, "Destination file for download is {0} ", (Object)addonFile.getAbsolutePath());
                }
                SyncSettings.updateSystemProxySettings();
                IOUtils.httpGet(urlString, addonFile.getAbsolutePath());
            }
            catch (HttpConnectionException ex) {
                this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
                this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", urlString);
                this.log.addLogEntry(ex.getMessage());
                this.log.addLogEntry("Application.install: Failed to download addon installation file from " + urlString);
                AppLog.getInstance("MI/Core").logException(50, "Installation: Failed to download installation file from ''" + urlString + "''", ex, true);
                throw new InstallationException(7, null, null);
            }
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "DOWNLOADING", applicationInfo.getName() + " " + applicationInfo.getVersion() + ": " + applicationInfo.getDescription());
            return addonFile;
        }
        this.log.addLogEntry("Retrieving addon application " + applicationInfo.getName() + " from  " + applicationInfo.getCustomizingValueForKey("LOCALPATH"));
        File newfile = new File(applicationInfo.getCustomizingValueForKey("LOCALPATH"));
        if (IOUtils.moveFileToDirectory(newfile, addonDir)) {
            return new File(addonDir.getAbsolutePath().concat(File.separator).concat(newfile.getName()));
        }
        throw new InstallationException(7, null, null);
    }

    private String validateDownloadLink(String source) throws InstallationException {
        String urlString = null;
        if (!(source.startsWith("http") || source.startsWith("HTTP") || source.toLowerCase().startsWith("file"))) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", source);
            AppLog.getInstance("MI/Core").log(50, "Installation: Failed to download installation file because download link sent was: " + source);
            throw new InstallationException(7, null, null);
        }
        urlString = source;
        return urlString;
    }

    private Properties getManifestFile(ZipFile zip) {
        String baseDir = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
        Enumeration<? extends ZipEntry> entries = zip.entries();
        Properties manifestfile = new Properties();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String currentEntryName = ze.getName();
            try {
                if (!currentEntryName.toLowerCase().endsWith("meta-inf/manifest.mf")) continue;
                currentEntryName = currentEntryName.substring(currentEntryName.lastIndexOf("/") + 1, currentEntryName.length());
                File tempFile = IOUtils.extractZipFile(zip, ze, baseDir + File.separator + currentEntryName);
                if (this.trace.isLogging(80)) {
                    this.trace.log(80, "Evaluation manifest file ''{0}''", (Object)tempFile.getAbsolutePath());
                }
                FileInputStream fis = new FileInputStream(new File(tempFile.getAbsolutePath()));
                manifestfile.load(fis);
                fis.close();
                this.deleteFile(tempFile);
                break;
            }
            catch (IOException ioex) {
                AppLog.getInstance("MI/Core").logException(50, "Cannot read manifest file", ioex, true);
            }
        }
        return manifestfile;
    }

    private String getInstallationFolder(Properties manifestfile) {
        if (manifestfile.getProperty(TO_GLOBAL_LIB_DIRECTORY, "").equalsIgnoreCase("X")) {
            this.toGlobalLib = true;
            return Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "lib" + File.separator;
        }
        String instFolder = manifestfile.getProperty(EXCTRACTIONFOLDER, "");
        if (!"".equals(instFolder)) {
            instFolder = instFolder + File.separator;
            File tempdir = new File(instFolder);
            if (!(instFolder.startsWith("\\") || instFolder.startsWith("/") || tempdir.isAbsolute())) {
                instFolder = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + instFolder;
            }
            this.toGlobalLib = false;
            return instFolder;
        }
        return "";
    }

    private boolean isItAConfigurationUpdate(Properties manifestFile) {
        return manifestFile.getProperty(CONFIGURATION_UPDATE, "").equals("X");
    }

    private boolean isItAPIOSConfigurationUpdate(Properties manifesFile) {
        return this.manifestFile.getProperty(PIOS_CONFIG_UPDATE, "").equals("X");
    }

    private String getAddOnInstallerClassname(Properties manifestfile) {
        return manifestfile.getProperty(ADDONINSTALLER_CLASS, "");
    }

    private void updateDefaultClientConfiguration(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Configuration.getInstance().setDefaultProperty(key, props.getProperty(key));
        }
    }

    private void callWinCELoaderForFile(File cab) {
        Trace t = Trace.getInstance("MI/Deployment");
        if (Configuration.getJVMVendorName().equalsIgnoreCase("NSIcom")) {
            Process p = null;
            this.log.addLogEntry("Trying to call Wceload for file " + cab.getAbsolutePath());
            try {
                try {
                    p = Runtime.getRuntime().exec("Wceload " + cab.getAbsolutePath());
                    int exitVal = p.waitFor();
                    t.log("Process exitValue: " + exitVal);
                    t.log("Successfully called Wceload for file " + cab.getAbsolutePath());
                    this.log.addLogEntry("Successfully called Wceload for file " + cab.getAbsolutePath());
                    p.getInputStream().close();
                    p.getOutputStream().close();
                    p.getErrorStream().close();
                }
                catch (IOException ioex) {
                    if (t.isLogging(90)) {
                        Trace.getInstance("MI/Core").logException(ioex);
                    }
                    Object var7_7 = null;
                    p.destroy();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (t.isLogging(90)) {
                        Trace.getInstance("MI/Core").logException(e);
                    }
                    Object var7_8 = null;
                    p.destroy();
                }
                Object var7_6 = null;
                p.destroy();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                p.destroy();
                throw throwable;
            }
        } else {
            t.log(this.getClass().getName() + ".callWinCELoaderForFile(" + cab.getAbsolutePath() + ") is doing nothing as JVM Vendor is not NSIcom but " + Configuration.getJVMVendorName());
        }
    }
}

