/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.ccms.sat;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.ccms.sat.SatInboundProcessor;
import com.sap.ip.me.ccms.sat.SatLine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Stack;

public class SatLog
extends PerformanceLog {
    private static final String SAT_SYNC_METHOD = "MI_SAT_SYNC";
    private BufferedWriter satLogOut;
    private Stack satLogStack = new Stack();

    protected void instanceMethodStarted() {
        super.instanceMethodStarted();
        SatLog.satMethodStarted("Performance Log (null)");
    }

    protected Object instanceMethodStarted(Object self) {
        Object obj = super.instanceMethodStarted(self);
        SatLog.satMethodStarted(self.getClass().getName());
        return obj;
    }

    protected void instanceMethodFinished(String text) {
        super.instanceMethodFinished(text);
        SatLog.satMethodFinished("Performance Log", text);
    }

    protected void instanceMethodFinished(Object traceTag, String text) {
        super.instanceMethodFinished(traceTag, text);
        SatLog.satMethodFinished("Performance Log (Master)", text);
    }

    private static void satMethodStarted(String methodName) {
        if (SatLog.isActive()) {
            SatLog satLog;
            SatLog satLog2 = satLog = SatLog.getSatLogInstance();
            synchronized (satLog2) {
                satLog.push(satLog.createSatLine(methodName, ""));
            }
        }
    }

    private static void satMethodFinished(String methodName, String descr) {
        if (SatLog.isActive()) {
            SatLog satLog;
            SatLog satLog2 = satLog = SatLog.getSatLogInstance();
            synchronized (satLog2) {
                SatLine satLine = satLog.pop();
                long grossTime = System.currentTimeMillis() - satLine.getStartDate();
                satLine.setGrossTime(grossTime + 1L);
                satLine.setUserName(UserManager.getInstance().getCurrentUser().getUniqueName());
                satLine.setDescr(descr);
                try {
                    satLog.satLogOut.write(satLine.toString());
                    satLog.satLogOut.newLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isActive() {
        Configuration config = Configuration.getInstance();
        return config.getBoolean("MobileEngine.Trace.SAT.Enabled", false);
    }

    public static void setActive(boolean newStatus) {
        if (SatLog.isActive() && !newStatus) {
            try {
                SatLog.getSatLogInstance().satLogOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SatLog.getSatLogInstance().satLogOut = null;
        }
        Configuration config = Configuration.getInstance();
        config.setBoolean("MobileEngine.Trace.SAT.Enabled", newStatus);
    }

    /*
     * WARNING - void declaration
     */
    public static void sendToR3() {
        if (SatLog.traceFileExists()) {
            SatInboundProcessor.registerItself();
            try {
                String line;
                OutboundContainer cont = OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.USER_SHARED, SAT_SYNC_METHOD, "R");
                Configuration config = Configuration.getInstance();
                if (SatLog.isActive()) {
                    SatLog.getSatLogInstance().satLogOut.flush();
                }
                StringBuffer j2eeAddress = new StringBuffer(255);
                j2eeAddress.append(config.getProperty("MobileEngine.Sync.Gateway.Protocol")).append("://").append(config.getProperty("MobileEngine.Sync.Gateway.Host")).append(":").append(config.getProperty("MobileEngine.Sync.Gateway.Port"));
                cont.addItem("j2eeAddress", j2eeAddress.toString());
                StringBuffer sb = new StringBuffer(255);
                sb.append(config.getProperty("MobileEngine.InstallationPath")).append(File.separatorChar).append("log").append(File.separatorChar).append("sat.trc");
                BufferedReader logReader = new BufferedReader(new FileReader(sb.toString()));
                while ((line = logReader.readLine()) != null) {
                    void var5_7;
                    int numberOfSubstrings = var5_7.length() / 255;
                    int i = 0;
                    while (i <= numberOfSubstrings) {
                        if (i == numberOfSubstrings) {
                            cont.addItem(Integer.toString(i), var5_7.substring(i * 255));
                        } else {
                            cont.addItem(Integer.toString(i), var5_7.substring(i * 255, i * 255 + 255));
                        }
                        ++i;
                    }
                }
                logReader.close();
                cont.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SyncException s) {
                s.printStackTrace();
                Trace.getInstance("MI/Core").logException("SyncException while creating MI_SAT_SYNC container", (Throwable)s, false);
            }
        }
    }

    public static void deleteTraceOnClient() {
        if (SatLog.isActive()) {
            SatLog.setActive(false);
            Configuration config = Configuration.getInstance();
            StringBuffer sb = new StringBuffer(256);
            sb.append(config.getProperty("MobileEngine.InstallationPath")).append(File.separatorChar).append("log").append(File.separatorChar).append("sat.trc");
            File logFile = new File(sb.toString());
            if (logFile.exists()) {
                logFile.delete();
            }
            SatLog.setActive(true);
        } else {
            Configuration config = Configuration.getInstance();
            StringBuffer sb = new StringBuffer(256);
            sb.append(config.getProperty("MobileEngine.InstallationPath")).append(File.separatorChar).append("log").append(File.separatorChar).append("sat.trc");
            File logFile = new File(sb.toString());
            if (logFile.exists()) {
                logFile.delete();
            }
        }
    }

    public static boolean traceFileExists() {
        Configuration config = Configuration.getInstance();
        StringBuffer sb = new StringBuffer(256);
        sb.append(config.getProperty("MobileEngine.InstallationPath")).append(File.separatorChar).append("log").append(File.separatorChar).append("sat.trc");
        File logFile = new File(sb.toString());
        return logFile.exists();
    }

    protected static SatLog getSatLogInstance() {
        SatLog instance = (SatLog)PerformanceLog.getInstance();
        if (instance.satLogOut == null) {
            Configuration config = Configuration.getInstance();
            StringBuffer sb = new StringBuffer(256);
            sb.append(config.getProperty("MobileEngine.InstallationPath")).append(File.separatorChar).append("log").append(File.separatorChar).append("sat.trc");
            try {
                File logFile = new File(sb.toString());
                if (!logFile.exists()) {
                    new File(logFile.getParent()).mkdirs();
                }
                instance.satLogOut = new BufferedWriter(new FileWriter(sb.toString(), true));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (SatLog)PerformanceLog.getInstance();
    }

    private SatLine createSatLine(String methodName, String description) {
        SatLog satLog = SatLog.getSatLogInstance();
        return new SatLine(satLog.getCurrentDepth(), methodName, System.currentTimeMillis(), description);
    }

    private void push(SatLine satLine) {
        this.satLogStack.push(satLine);
    }

    private SatLine pop() {
        return (SatLine)this.satLogStack.pop();
    }

    private int getCurrentDepth() {
        return this.satLogStack.size();
    }
}

