/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.ccms.maxdbstatus;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.core.SecurityManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCConnectMaxDB {
    private static String jdbcDriverClass = null;
    private static final Configuration conf = Configuration.getInstance();
    private static Connection connection = null;
    static final int NO_JDBC_TRANSACTION_MANAGER = -1;
    static final int NO_JDBC_DRIVER_DEFINED = -2;
    static final int NO_JDBC_DRIVER_AVAILABLE = -3;
    static final int DB_URL_NOT_DEFINED = -4;
    static final int DB_CONNECTION_NOT_POSSIBLE = -5;
    static final int UNDEFINED_RESULT = -1000;

    public static int getStatus(String queryString) {
        if (jdbcDriverClass == null) {
            String runtimeImplClass = conf.getProperty("MobileEngine.Persist.Implementation.TransactionManager");
            if (!runtimeImplClass.endsWith("JDBCTransactionManager")) {
                return -1;
            }
            try {
                jdbcDriverClass = conf.getProperty("MobileEngine.Persist.Jdbc.Driver");
                if (jdbcDriverClass == null) {
                    JDBCConnectMaxDB.throwErrorMessage("Error : JDBC Driver not defined in config File");
                    return -2;
                }
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException e) {
                JDBCConnectMaxDB.throwErrorMessage("Error : JDBC Driver not available");
                return -3;
            }
            String maxDBUrl = conf.getProperty("MobileEngine.Persist.Jdbc.DbUrl");
            String maxDBUser = conf.getProperty("MobileEngine.Persist.Jdbc.DbUser");
            String maxDBUserPassword = SecurityManager.getInstance().getDBPassword();
            if (maxDBUrl == null) {
                JDBCConnectMaxDB.throwErrorMessage("Error : DB Url not defined");
                return -4;
            }
            try {
                connection = DriverManager.getConnection(maxDBUrl, maxDBUser, maxDBUserPassword);
            }
            catch (SQLException e1) {
                JDBCConnectMaxDB.throwErrorMessage("Error : DB Connection not possible.");
                JDBCConnectMaxDB.throwErrorMessage("Error : " + e1);
                return -5;
            }
        }
        try {
            Statement stmt = connection.createStatement();
            ResultSet res = stmt.executeQuery(queryString);
            if (res.next()) {
                int result = res.getInt(1);
                return result;
            }
        }
        catch (SQLException e2) {
            JDBCConnectMaxDB.throwErrorMessage("Error : SQL Exception.");
            JDBCConnectMaxDB.throwErrorMessage("Error : " + e2);
        }
        return -1000;
    }

    private static void throwErrorMessage(String messageText) {
        AppLog.getInstance("MI/CCMS").log(50, messageText);
    }
}

