/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.ccms;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.ccms.Alert;
import java.io.File;

public class TraceAlert
implements Alert {
    private static final String ATTRIBUTE_TRACEFILE_SIZE = "TracefileSize";
    private int alertValue;
    private String alertName = "TracefileSize";

    public void compare(int value) {
    }

    public int getAlertValue() {
        Configuration config = Configuration.getInstance();
        String traceFileName = config.getProperty("MobileEngine.Trace.Filename");
        if (traceFileName.startsWith("/")) {
            traceFileName = Configuration.getInstallationDirectory() + traceFileName;
        }
        File tmpFile = new File(traceFileName);
        try {
            long alertValueLongType = tmpFile.length();
            long maxTracefileLength = config.getLong("MobileEngine.Trace.Filesize", -2L);
            this.alertValue = maxTracefileLength > 0L ? (int)(alertValueLongType * 100L / (maxTracefileLength * 1024L)) : -1;
        }
        catch (SecurityException securityexption) {
            Trace.getInstance("MI/CCMS").log(60, "Trace file size cannot be evaluated ({0}); check configuration of the trace file on client", (Object)securityexption.getLocalizedMessage());
            this.alertValue = 100;
        }
        return this.alertValue;
    }

    public void setAlertValue(int value) {
        this.alertValue = value;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }
}

