/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.ccms;

import com.sap.ip.me.api.services.MultiObjectFileStorage;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.ccms.Alert;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.sync.SyncEventRegistryImpl;

public class LastSuccessfulSyncAlert
implements SyncEventListener,
Alert {
    private static final String ATTRIBUTE_LAST_SUCCESSFUL_SYNC = "LastSuccessfulSync";
    boolean currentSyncSuccessful = false;
    private static final String KEY_VALUE = "0001";
    private static final String FAILURE_FLAG = "0002";
    private static final String LSSA_SYNC_FAILURE = "Failure";
    private static final String LSSA_SYNC_SUCCESS = "Success";
    private transient MultiObjectFileStorage aMultiObjectFileStorage = null;
    String alertName = "LastSuccessfulSync";
    int alertValue = -1;

    public LastSuccessfulSyncAlert() {
        ((SyncEventRegistryImpl)SyncEventRegistry.getInstance()).addSyncEventListener(this, ConversationIdHandler.getSharedFrameworkConversationId());
        this.aMultiObjectFileStorage = MultiObjectFileStorage.createInstance(ATTRIBUTE_LAST_SUCCESSFUL_SYNC);
        this.setAlertValue(-1);
    }

    public void compare(int value) {
    }

    public String getAlertName() {
        return this.alertName;
    }

    public int getAlertValue() {
        String lastSyncStatus = (String)this.aMultiObjectFileStorage.read(FAILURE_FLAG, true);
        if (lastSyncStatus.equals(LSSA_SYNC_FAILURE)) {
            long lastSuccessfulSyncTimestamp = (Long)this.aMultiObjectFileStorage.read(KEY_VALUE, true);
            long currentTimestamp = System.currentTimeMillis();
            return (int)((currentTimestamp - lastSuccessfulSyncTimestamp) / 60000L);
        }
        return -1;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setAlertValue(int value) {
        this.alertValue = value;
    }

    public void actionPerformed(SyncEvent syncEvent) {
        if (syncEvent.getType() == 0) {
            this.currentSyncSuccessful = false;
        } else if (syncEvent.getType() == 2) {
            this.currentSyncSuccessful = true;
        } else if (syncEvent.getType() == 1) {
            if (this.currentSyncSuccessful) {
                this.aMultiObjectFileStorage.write(FAILURE_FLAG, LSSA_SYNC_SUCCESS);
                long dateLong = System.currentTimeMillis();
                this.aMultiObjectFileStorage.write(KEY_VALUE, new Long(dateLong));
            } else {
                this.aMultiObjectFileStorage.write(FAILURE_FLAG, LSSA_SYNC_FAILURE);
            }
        }
    }
}

