/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.ccms;

import com.sap.ip.me.api.services.DateFormatter;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.Serializable;
import java.util.Date;

public class CcmsFormatter
implements Serializable {
    public static int DEVID_LENGTH = 36;
    public static int USERID_LENGTH = 12;
    public static int ATTRIBUT_NAME_LENGTH = 50;
    public static int ATTRIBUT_VALUE_LENGTH = 8;
    public static int SOURCE_SYSTEM_LENGTH = 12;
    public static int TIMESTAMP_LENGTH = 15;
    public static final String CLIENT = "CLIENT";

    public String getDeviceID() {
        String deviceIDTemp = ConversationIdHandler.getDeviceId();
        String formattedString = this.format(deviceIDTemp, DEVID_LENGTH);
        return formattedString;
    }

    public String getUserID() {
        User user = UserManagerImpl.getUserManagerImplInstance().getCurrentLogonUser();
        String formattedUserID = this.format(user.getUniqueID(), USERID_LENGTH);
        return formattedUserID;
    }

    public String getUTCTime() {
        String utcTime = DateFormatter.getCurrentDateABAP() + DateFormatter.getTimeABAP(new Date()) + "000";
        String formattedUTCTime = this.format(utcTime, TIMESTAMP_LENGTH);
        return formattedUTCTime;
    }

    public String format(String value, int format) {
        if (format > value.length()) {
            StringBuffer stringBufferTmp = new StringBuffer();
            stringBufferTmp.setLength(format - value.length());
            String spaces = new String(this.fillWithSpaces(stringBufferTmp));
            String formattedString = value.concat(spaces);
            return formattedString;
        }
        return value.substring(0, format);
    }

    public String format(int value, int format) {
        String stringValue = String.valueOf(value);
        return this.format(stringValue, format);
    }

    private StringBuffer fillWithSpaces(StringBuffer orgString) {
        char space = ' ';
        int i = 0;
        while (i < orgString.length()) {
            orgString.setCharAt(i, space);
            ++i;
        }
        return orgString;
    }
}

