/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.ccms;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.ccms.Alert;
import com.sap.ip.me.ccms.AlertInboundProcessor;
import com.sap.ip.me.ccms.CcmsFormatter;
import com.sap.ip.me.ccms.LastSuccessfulSyncAlert;
import com.sap.ip.me.ccms.TraceAlert;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.sync.SyncEventRegistryImpl;
import java.io.Serializable;
import java.util.Vector;

public class AlertManager
implements SyncEventListener,
Serializable {
    private static final String INBOUND_CONTAINER = "INBOUND_CONTAINER";
    private static final String METHOD_NAME = "CLIENT_ALERT";
    private static AlertManager instance = null;
    private transient Vector alertsVec = null;
    private transient CcmsFormatter formatter = null;

    protected AlertManager() {
        ((SyncEventRegistryImpl)SyncEventRegistry.getInstance()).addSyncEventListener(this, ConversationIdHandler.getSharedFrameworkConversationId());
        AlertInboundProcessor alertInboundProcessor = new AlertInboundProcessor(METHOD_NAME);
        InboundProcessorRegistry.getInstance().register(alertInboundProcessor);
        this.register(new TraceAlert());
        this.register(new LastSuccessfulSyncAlert());
    }

    public static AlertManager getInstance() {
        if (instance == null) {
            instance = new AlertManager();
        }
        return instance;
    }

    public void register(Alert anAlert, String alertName) {
        if (this.alertsVec == null) {
            this.alertsVec = new Vector();
        }
        anAlert.setAlertName(alertName);
        this.alertsVec.addElement(anAlert);
    }

    public void register(Alert anAlert) {
        if (anAlert != null) {
            this.register(anAlert, anAlert.getAlertName());
        }
    }

    public void actionPerformed(SyncEvent syncEvent) {
        boolean sendAlertIfUserSyncFinished = Configuration.getInstance().getBoolean("MobileEngine.Sync.AllowUserSyncFinishedEvent", true);
        if (sendAlertIfUserSyncFinished && syncEvent.getType() == 10 || !sendAlertIfUserSyncFinished && syncEvent.getType() == 0) {
            CcmsFormatter ccmsFormatter = this.getCcmsFormatter();
            String deviceID = ccmsFormatter.getDeviceID();
            String userID = ccmsFormatter.getUserID();
            if (deviceID.trim().length() > 0) {
                try {
                    if (!InboundProcessorRegistry.getInstance().isAlreadyInOutboundQueue(METHOD_NAME, VisibilityType.SEPARATED)) {
                        OutboundContainer cont = OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.SEPARATED, METHOD_NAME, "R");
                        int i = 0;
                        while (i < this.alertsVec.size()) {
                            Alert tmp = (Alert)this.alertsVec.elementAt(i);
                            if (tmp.getAlertValue() != -1) {
                                cont.addItem(INBOUND_CONTAINER, deviceID + userID + ccmsFormatter.getUTCTime() + ccmsFormatter.format(tmp.getAlertName(), CcmsFormatter.ATTRIBUT_NAME_LENGTH) + ccmsFormatter.format(tmp.getAlertValue(), CcmsFormatter.ATTRIBUT_VALUE_LENGTH) + ccmsFormatter.format("CLIENT", CcmsFormatter.SOURCE_SYSTEM_LENGTH));
                            }
                            ++i;
                        }
                        cont.close();
                    } else {
                        OutboundContainer cont = OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.SEPARATED, METHOD_NAME, "R");
                        int i = 0;
                        while (i < this.alertsVec.size()) {
                            Alert tmp = (Alert)this.alertsVec.elementAt(i);
                            if (tmp instanceof LastSuccessfulSyncAlert && tmp.getAlertValue() != -1) {
                                cont.addItem(INBOUND_CONTAINER, deviceID + userID + ccmsFormatter.getUTCTime() + ccmsFormatter.format(tmp.getAlertName(), CcmsFormatter.ATTRIBUT_NAME_LENGTH) + ccmsFormatter.format(tmp.getAlertValue(), CcmsFormatter.ATTRIBUT_VALUE_LENGTH) + ccmsFormatter.format("CLIENT", CcmsFormatter.SOURCE_SYSTEM_LENGTH));
                            }
                            ++i;
                        }
                        cont.close();
                    }
                }
                catch (SyncException s) {
                    AppLog.getInstance("MI/CCMS").logException(50, s);
                }
                catch (NumberFormatException nFex) {
                    AppLog.getInstance("MI/CCMS").logException(60, nFex);
                }
                catch (Exception ex) {
                    AppLog.getInstance("MI/CCMS").logException(50, (Throwable)ex, true);
                }
            }
        }
    }

    public boolean isRegistered(String anAlert) {
        boolean result = false;
        int i = 0;
        while (i < this.alertsVec.size()) {
            Alert element = (Alert)this.alertsVec.elementAt(i);
            if (element.getAlertName() == anAlert) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public boolean removeAlert(Alert anAlert) {
        boolean result = false;
        if (this.isRegistered(anAlert.getAlertName())) {
            int i = 0;
            while (i < this.alertsVec.size()) {
                Alert element = (Alert)this.alertsVec.elementAt(i);
                if (element.getAlertName() == anAlert.getAlertName()) {
                    this.alertsVec.removeElementAt(i);
                }
                ++i;
            }
            this.alertsVec.removeElement(anAlert);
            if (!this.isRegistered(anAlert.getAlertName())) {
                result = true;
            }
        }
        return false;
    }

    private CcmsFormatter getCcmsFormatter() {
        if (this.formatter == null) {
            this.formatter = new CcmsFormatter();
        }
        return this.formatter;
    }
}

