/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTDialog;
import com.sap.ip.me.awtapps.home.Advanced;
import com.sap.ip.me.awtapps.home.HomeFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class TraceSettingsDialog
extends AWTDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 160;
    public static final int CENTER_PANEL_COUNT_ROWS = 3;
    public static final int CENTER_PANEL_COUNT_COLS = 1;
    public static final String TRACELEVEL_0_KEY = "TRACELEVEL_0";
    public static final String TRACELEVEL_10_KEY = "TRACELEVEL_10";
    public static final String TRACELEVEL_50_KEY = "TRACELEVEL_50";
    public static final String TRACELEVEL_60_KEY = "TRACELEVEL_60";
    public static final String TRACELEVEL_70_KEY = "TRACELEVEL_70";
    public static final String TRACELEVEL_80_KEY = "TRACELEVEL_80";
    public static final String TRACELEVEL_90_KEY = "TRACELEVEL_90";
    private static Advanced advanced = null;
    private Button ok;
    private Button cancel;
    private String TRACE_LEVEL_KEY = "TRACE_LEVEL";
    private String TRACE_ON_KEY = "TRACE_TITLE";
    private Choice levelChoice;
    private Panel centerPanel;
    private Panel southPanel;
    private Checkbox traceOnOff;
    private final Trace trace = Trace.getInstance("MI/FrameworkApplications");
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());
    int traceLevelCancel = 0;
    boolean logOnCancel = false;

    public TraceSettingsDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        this.saveForCancel();
        this.setLayout(new BorderLayout());
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(new GridLayout(3, 1));
        this.southPanel = new Panel();
        this.add("Center", this.centerPanel);
        this.add("South", this.southPanel);
        this.centerPanel.add(new Label(this.resLang.getString(this.TRACE_LEVEL_KEY), 0));
        this.levelChoice = new Choice();
        this.levelChoice.addItem(this.resLang.getString(TRACELEVEL_0_KEY));
        this.levelChoice.addItem(this.resLang.getString(TRACELEVEL_10_KEY));
        this.levelChoice.addItem(this.resLang.getString(TRACELEVEL_50_KEY));
        this.levelChoice.addItem(this.resLang.getString(TRACELEVEL_60_KEY));
        this.levelChoice.addItem(this.resLang.getString(TRACELEVEL_70_KEY));
        this.levelChoice.addItem(this.resLang.getString(TRACELEVEL_80_KEY));
        this.levelChoice.addItem(this.resLang.getString(TRACELEVEL_90_KEY));
        this.centerPanel.add(this.levelChoice);
        this.traceOnOff = new Checkbox(this.resLang.getString(this.TRACE_ON_KEY), this.trace.isOn());
        this.centerPanel.add(this.traceOnOff);
        this.ok = new Button(this.getOkButtonText());
        this.southPanel.add(this.ok);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.fillControls();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.getCancelButtonText())) {
                this.doCancel();
                this.exitDialogEscape();
                return false;
            }
            if (sButton.equals(this.getOkButtonText())) {
                ((Component)this).setVisible(false);
                this.writeSettings();
                return false;
            }
        }
        return true;
    }

    protected void writeSettings() {
        if (this.traceOnOff.getState()) {
            this.trace.switchOn(true);
        } else {
            this.trace.switchOn(false);
        }
        int level = this.trace.getEffectiveSeverity();
        String selItem = this.levelChoice.getSelectedItem();
        if (this.levelChoice.getSelectedItem().equals(this.resLang.getString(TRACELEVEL_0_KEY))) {
            level = 1000;
        } else if (this.levelChoice.getSelectedItem().equals(this.resLang.getString(TRACELEVEL_10_KEY))) {
            level = 10;
        } else if (this.levelChoice.getSelectedItem().equals(this.resLang.getString(TRACELEVEL_50_KEY))) {
            level = 50;
        } else if (this.levelChoice.getSelectedItem().equals(this.resLang.getString(TRACELEVEL_60_KEY))) {
            level = 60;
        } else if (this.levelChoice.getSelectedItem().equals(this.resLang.getString(TRACELEVEL_70_KEY))) {
            level = 70;
        } else if (this.levelChoice.getSelectedItem().equals(this.resLang.getString(TRACELEVEL_80_KEY))) {
            level = 80;
        } else if (this.levelChoice.getSelectedItem().equals(this.resLang.getString(TRACELEVEL_90_KEY))) {
            level = 90;
        }
        this.trace.setEffectiveSeverity(level);
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 160;
    }

    private void fillControls() {
        int curTraceLevel = this.trace.getEffectiveSeverity();
        if (curTraceLevel == 1000) {
            this.levelChoice.select(this.resLang.getString(TRACELEVEL_0_KEY));
        }
        if (curTraceLevel == 90) {
            this.levelChoice.select(this.resLang.getString(TRACELEVEL_90_KEY));
        }
        if (curTraceLevel == 80) {
            this.levelChoice.select(this.resLang.getString(TRACELEVEL_80_KEY));
        }
        if (curTraceLevel == 50) {
            this.levelChoice.select(this.resLang.getString(TRACELEVEL_50_KEY));
        }
        if (curTraceLevel == 70) {
            this.levelChoice.select(this.resLang.getString(TRACELEVEL_70_KEY));
        }
        if (curTraceLevel == 10) {
            this.levelChoice.select(this.resLang.getString(TRACELEVEL_10_KEY));
        }
        if (curTraceLevel == 60) {
            this.levelChoice.select(this.resLang.getString(TRACELEVEL_60_KEY));
        }
    }

    private void saveForCancel() {
        this.traceLevelCancel = this.trace.getEffectiveSeverity();
        this.logOnCancel = this.trace.isOn();
    }

    private void doCancel() {
        this.trace.setEffectiveSeverity(this.traceLevelCancel);
        if (this.logOnCancel) {
            this.trace.switchOn(true);
        } else {
            this.trace.switchOn(false);
        }
    }
}

