/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.PasswordSyncDialog;
import com.sap.ip.me.awtapps.home.Settings;
import com.sap.ip.me.core.UserManagerImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.text.MessageFormat;

public class SyncPasswordDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT_WITH_REMINDER = 220;
    public static final int PREFERRED_HEIGHT_WITHOUT_REMINDER = 180;
    public static final int passwordTextFieldLength = 11;
    public static final int CENTER_PANEL_COUNT_ROWS = 6;
    public static final int CENTER_PANEL_COUNT_COLS = 1;
    public static final String PASSWORD_LABEL_TEXT = "xfld_SYNC_PASSWORD";
    public static final String REMINDER_LABEL_TEXT = "xckl_REMIND_PASSWORD";
    public static final String xtit_CHANGE_SYNC_PASSWORD = "xtit_CHANGE_SYNC_PASSWORD";
    private static Settings settings = null;
    private int preferredHeight = 180;
    private Button ok;
    private Button cancel;
    private Button syncPasswordButton;
    private TextField passwordField;
    private Label reminderBitLabel;
    private Checkbox reminderCheckbox;
    private Panel northPanel;
    private Panel centerPanel;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());
    private boolean withReminder;
    private HomeFrame homeFrame;

    public SyncPasswordDialog(HomeFrame p_parent, String name, String infMsg, boolean withReminderPara) {
        super(p_parent, name, true);
        this.homeFrame = p_parent;
        this.withReminder = withReminderPara;
        this.preferredHeight = this.withReminder ? 220 : 180;
        if (settings == null) {
            settings = new Settings();
        }
        this.containerPanel.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        this.northPanel = new Panel();
        this.northPanel.setLayout(gridbag);
        this.centerPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        Label labelPw = new Label(this.resLang.getString(PASSWORD_LABEL_TEXT), 0);
        gridbag.setConstraints(labelPw, c);
        this.northPanel.add(labelPw);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.passwordField = new TextField(11);
        this.passwordField.setEchoChar('*');
        gridbag.setConstraints(this.passwordField, c);
        this.northPanel.add(this.passwordField);
        if (this.withReminder) {
            c.fill = 1;
            c.weightx = 1.0;
            c.gridwidth = 0;
            Label label = new Label(this.resLang.getString(REMINDER_LABEL_TEXT), 0);
            gridbag.setConstraints(label, c);
            this.northPanel.add(label);
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.reminderCheckbox = new Checkbox("");
            gridbag.setConstraints(this.reminderCheckbox, c);
            this.northPanel.add(this.reminderCheckbox);
        }
        this.ok = new Button(this.getOkButtonText());
        this.syncPasswordButton = new Button(this.getSyncPasswordButtonText());
        this.cancel = new Button(this.getCancelButtonText());
        this.centerPanel.add(this.ok);
        this.centerPanel.add(this.syncPasswordButton);
        this.centerPanel.add(this.cancel);
        this.fillControls();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.getOkButtonText())) {
                if (!this.checkSyncPassword()) {
                    this.homeFrame.syncPasswordCheckResultMessage(false);
                } else {
                    this.exitDialogOk();
                    this.homeFrame.syncPasswordCheckResultMessage(true);
                }
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                this.homeFrame.syncPasswordCheckResultMessage(false);
                return false;
            }
            if (sButton.equals(this.getSyncPasswordButtonText())) {
                this.actionSyncPassword();
                return false;
            }
        }
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(240, this.preferredHeight);
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return this.preferredHeight;
    }

    protected void writeSettings() {
        if (!this.checkSyncPassword()) {
            this.homeFrame.syncPasswordCheckResultMessage(false);
        } else {
            ((Component)this).setVisible(false);
            this.homeFrame.syncPasswordCheckResultMessage(true);
        }
    }

    private boolean checkSyncPassword() {
        String syncPassword = this.passwordField.getText();
        UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
        try {
            userManager.setSyncPasswordOfCurrentUser(syncPassword);
        }
        catch (SyncPasswordException e) {
            String message = null;
            switch (e.getMessageId()) {
                case 1: {
                    message = this.resLang.getString("xmsg_EMPTY_SYNC_PASSWORD");
                    break;
                }
                case 2: {
                    message = e.getMessage();
                    break;
                }
                case 3: {
                    message = MessageFormat.format(this.resLang.getString("xmsg_INVALID_SYNC_PASS_LEN"), e.getMessageParameters());
                    break;
                }
                case 0: {
                    message = e.getMessage();
                    break;
                }
                default: {
                    message = this.resLang.getString("xmsg_UNKNOWN_ERROR");
                }
            }
            this.showMessage(message);
            this.passwordField.setText("");
            return false;
        }
        return true;
    }

    private void fillControls() {
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }

    private TextField initLabelTextFieldGridBag(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut, GridBagLayout gridbag, GridBagConstraints c) {
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label label = new Label(labelText, 2);
        gridbag.setConstraints(label, c);
        intoPanel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        gridbag.setConstraints(p, c);
        intoPanel.add(p);
        return textField;
    }

    private String getSyncPasswordButtonText() {
        return HomeFrame.addEllipsis(this.resLang.getString(xtit_CHANGE_SYNC_PASSWORD));
    }

    private void actionSyncPassword() {
        PasswordSyncDialog passwordSyncDialog = new PasswordSyncDialog((Frame)HomeFrame.getInstance(), this.getSyncPasswordButtonText().substring(0, this.getSyncPasswordButtonText().length() - 3), "userActionInfo");
        HomeFrame.getInstance().showDialog(passwordSyncDialog, false);
    }
}

