/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.Settings;
import com.sap.ip.me.core.ConversationIdHandler;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class SettingsDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 230;
    public static final int gatewayTextFieldLength = 11;
    public static final int clientTextFieldLength = 11;
    public static final int languageTextFieldLength = 11;
    public static final int CENTER_PANEL_COUNT_ROWS = 6;
    public static final int CENTER_PANEL_COUNT_COLS = 2;
    public static final String DEVICE_ID_LABEL_TEXT = "DEPLOYMENTID";
    public static final String GATEWAY_LABEL_TEXT = "GATEWAY";
    public static final String PROXY_BIT_LABEL_TEXT = "PROXY";
    public static final String xfld_PROXY = "xfld_PROXY";
    public static final String CLIENT_LABEL_TEXT = "CLIENT";
    public static final String LANGUAGE_LABEL_TEXT = "LANGUAGE";
    private static Settings settings = null;
    private Button ok;
    private Button cancel;
    private TextField deviceIDChoice;
    private TextField gatewayTextField;
    private Label proxyBitLabel;
    private Checkbox proxyBitCheckbox;
    private TextField clientTextField;
    private Panel centerPanel;
    private Panel southPanel;
    private Panel northPanel;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public SettingsDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        if (settings == null) {
            settings = new Settings();
        }
        this.containerPanel.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        this.northPanel = new Panel();
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(gridbag);
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        this.containerPanel.add("South", this.southPanel);
        this.deviceIDChoice = this.initLabelTextFieldGridBag(this.centerPanel, this.resLang.getString(DEVICE_ID_LABEL_TEXT), 11, false, gridbag, c);
        this.deviceIDChoice.setEnabled(false);
        this.deviceIDChoice.setBackground(Color.lightGray);
        this.gatewayTextField = this.initLabelTextFieldGridBag(this.centerPanel, this.resLang.getString(GATEWAY_LABEL_TEXT), 11, false, gridbag, c);
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label label = new Label(this.resLang.getString(xfld_PROXY), 2);
        gridbag.setConstraints(label, c);
        this.centerPanel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.proxyBitCheckbox = new Checkbox("");
        gridbag.setConstraints(this.proxyBitCheckbox, c);
        this.centerPanel.add(this.proxyBitCheckbox);
        this.clientTextField = this.initLabelTextFieldGridBag(this.centerPanel, this.resLang.getString(CLIENT_LABEL_TEXT), 11, false, gridbag, c);
        this.ok = new Button(this.getOkButtonText());
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.ok);
        this.southPanel.add(this.cancel);
        this.fillControls();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.getOkButtonText())) {
                this.exitDialogOk();
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
        }
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(240, 230);
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 230;
    }

    protected void writeSettings() {
        settings.setClient(this.clientTextField.getText());
        settings.setGateway(this.gatewayTextField.getText());
        settings.setProxyUsed(this.proxyBitCheckbox.getState());
    }

    private void fillControls() {
        this.deviceIDChoice.setText(ConversationIdHandler.getDeviceId());
        this.gatewayTextField.setText(settings.getGateway());
        this.proxyBitCheckbox.setState(settings.getProxyUsed());
        this.clientTextField.setText(settings.getClient());
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }

    private TextField initLabelTextFieldGridBag(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut, GridBagLayout gridbag, GridBagConstraints c) {
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label label = new Label(labelText, 2);
        gridbag.setConstraints(label, c);
        intoPanel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        gridbag.setConstraints(p, c);
        intoPanel.add(p);
        return textField;
    }
}

