/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.core.SyncSettings;

public class Settings {
    public String getGateway() {
        return SyncSettings.getSyncGateway();
    }

    public void setGateway(String gateway) {
        String protocol = this.getGatewayProtocol(gateway);
        String host = this.getGatewayHost(protocol, gateway);
        String port = this.getGatewayPort(protocol, host, gateway);
        String system = this.getGatewaySystem(protocol, host, port, gateway);
        Configuration configuration = Configuration.getInstance();
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.Protocol", protocol);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.Host", host);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.Port", port);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.System", system);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway", SyncSettings.getSyncGateway());
    }

    public boolean getProxyUsed() {
        Configuration configuration = Configuration.getInstance();
        return configuration.getBoolean("MobileEngine.Sync.Proxyused", false);
    }

    public void setProxyUsed(boolean b) {
        Configuration configuration = Configuration.getInstance();
        configuration.setDefaultProperty("MobileEngine.Sync.Proxyused", "" + b);
    }

    public String getClient() {
        Configuration configuration = Configuration.getInstance();
        return configuration.getProperty("MobileEngine.Sync.Client");
    }

    public void setClient(String client) {
        Configuration configuration = Configuration.getInstance();
        configuration.setDefaultProperty("MobileEngine.Sync.Client", client);
    }

    private String getGatewayProtocol(String gatewayURL) {
        try {
            if (gatewayURL.equals("")) {
                return "";
            }
            return gatewayURL.substring(0, gatewayURL.indexOf(":"));
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    private String getGatewayHost(String gatewayProtocol, String gatewayURL) {
        try {
            if (gatewayURL.equals("")) {
                return "";
            }
            String lastString = gatewayURL.substring((gatewayProtocol + "://").length());
            return lastString.substring(0, lastString.indexOf(":"));
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    private String getGatewayPort(String gatewayProtocol, String gatewayHost, String gatewayURL) {
        try {
            if (gatewayURL.equals("")) {
                return "";
            }
            String lastString = gatewayURL.substring((gatewayProtocol + "://" + gatewayHost + ":").length());
            return lastString.substring(0, lastString.indexOf("/"));
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    private String getGatewaySystem(String gatewayProtocol, String gatewayHost, String gatewayPort, String gatewayURL) {
        try {
            if (gatewayURL.equals("")) {
                return "";
            }
            String lastString = gatewayProtocol + "://" + gatewayHost + ":" + gatewayPort + "/meSync/servlet/meSync?~sysid=";
            return gatewayURL.substring(lastString.length(), gatewayURL.length() - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }
}

