/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.Message;
import com.sap.ip.me.awtapps.home.Settings;
import com.sap.ip.me.core.ChangePasswordException;
import com.sap.ip.me.core.UserManagerImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;

public class PasswordSyncDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 200;
    public static final int userTextFieldLength = 12;
    public static final int passwordTextFieldLength = 12;
    public static final int clientTextFieldLength = 12;
    public static final int CENTER_PANEL_COUNT_ROWS = 3;
    public static final int CENTER_PANEL_COUNT_COLS = 2;
    public static final String xfld_UserName_KEY = "xfld_UserName";
    public static final String OLD_PASSWORD_KEY = "xfld_OldPassword";
    public static final String NEW_PASSWORD_KEY = "xfld_NewPassword";
    public static final String CONFIRM_PASSWORD_KEY = "xfld_ConfirmPassword";
    public static final String PASSWORDS_DIFFERENT_KEY = "xmsg_PASSWORDS_DIFFERENT";
    public static final String PASSWORD_WRONG_KEY = "xmsg_PASSWORD_WRONG";
    public static final String xmsg_ONLINE_NOTE = "xmsg_ONLINE_NOTE";
    public static final String xmsg_SUCC_SYNC_PASS_CHANGE = "xmsg_SUCC_SYNC_PASS_CHANGE";
    private static Settings settings = null;
    private Button ok;
    private Button cancel;
    private TextField passwordTextField;
    private TextField newPasswordTextField;
    private TextField passwordConfirmTextField;
    private Panel northPanel;
    private Panel centerPanel;
    private Panel southPanel;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public PasswordSyncDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        if (settings == null) {
            settings = new Settings();
        }
        this.containerPanel.setLayout(new BorderLayout());
        this.northPanel = new Panel();
        this.northPanel.setLayout(new GridLayout(3, 2));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(new GridLayout(1, 1));
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        this.containerPanel.add("South", this.southPanel);
        this.passwordTextField = this.initLabelTextField(this.northPanel, this.resLang.getString(OLD_PASSWORD_KEY), 12);
        this.passwordTextField.setEchoChar('*');
        this.newPasswordTextField = this.initLabelTextField(this.northPanel, this.resLang.getString(NEW_PASSWORD_KEY), 12);
        this.newPasswordTextField.setEchoChar('*');
        this.passwordConfirmTextField = this.initLabelTextField(this.northPanel, this.resLang.getString(CONFIRM_PASSWORD_KEY), 12);
        this.passwordConfirmTextField.setEchoChar('*');
        String displayText = this.resLang.getString(xmsg_ONLINE_NOTE);
        TextArea textArea = new TextArea(displayText, 3, 80, 2);
        textArea.setEditable(false);
        this.centerPanel.add(textArea);
        this.ok = new Button(this.getOkButtonText());
        this.southPanel.add(this.ok);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.fillControls();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.getOkButtonText())) {
                if (this.changePassword()) {
                    this.exitDialog();
                }
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
        }
        return true;
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 200;
    }

    protected void exitDialogOk() {
        if (this.changePassword()) {
            this.exitDialog();
        }
    }

    protected void exitDialog() {
        ((Component)this).setVisible(false);
    }

    protected void writeSettings() {
    }

    void showPasswordsNotEqualMessage() {
        Message message = new Message((Frame)HomeFrame.getInstance(), 1, "userActionInfo", this.resLang.getString(PASSWORDS_DIFFERENT_KEY));
        ((Component)message).setSize(240, 120);
        Point p = HomeFrame.getCenteredWindowOrigin(240, 120);
        ((Component)message).setLocation(p.x, p.y);
        message.setResizable(true);
        message.show();
        message.dispose();
    }

    void showPasswordWrongMessage() {
        Message message = new Message((Frame)HomeFrame.getInstance(), 1, "userActionInfo", this.resLang.getString(PASSWORD_WRONG_KEY));
        ((Component)message).setSize(240, 120);
        Point p = HomeFrame.getCenteredWindowOrigin(240, 120);
        ((Component)message).setLocation(p.x, p.y);
        message.setResizable(true);
        message.show();
        message.dispose();
    }

    void showPasswordSuccessMessage() {
        Message message = new Message((Frame)HomeFrame.getInstance(), 1, "userActionInfo", this.resLang.getString(xmsg_SUCC_SYNC_PASS_CHANGE));
        ((Component)message).setSize(240, 120);
        Point p = HomeFrame.getCenteredWindowOrigin(240, 120);
        ((Component)message).setLocation(p.x, p.y);
        message.setResizable(true);
        message.show();
        message.dispose();
    }

    private boolean changePassword() {
        String oldPassword = this.passwordTextField.getText();
        String newPassword = this.newPasswordTextField.getText();
        String newPasswordConfirmation = this.passwordConfirmTextField.getText();
        try {
            UserManagerImpl um = UserManagerImpl.getUserManagerImplInstance();
            um.changeSyncPassword(oldPassword, newPassword, newPasswordConfirmation);
            this.showPasswordSuccessMessage();
            return true;
        }
        catch (ChangePasswordException e) {
            this.showMessage(e.getLocalizedMessage());
            this.newPasswordTextField.setText("");
            this.passwordConfirmTextField.setText("");
            this.passwordTextField.setText("");
            return false;
        }
    }

    private boolean passwordsEqual() {
        if (this.newPasswordTextField.getText() == null || this.passwordConfirmTextField.getText() == null) {
            if (Trace.getInstance("MI/API/Runtime/AWT").isLogging(60)) {
                Trace.getInstance("MI/API/Runtime/AWT").log(60, "Null pointer in method PasswordSyncDialog::passwordsEqual");
            }
            return false;
        }
        return this.newPasswordTextField.getText().equals(this.passwordConfirmTextField.getText());
    }

    private void fillControls() {
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = new Panel(new FlowLayout());
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }
}

