/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.Message;
import com.sap.ip.me.awtapps.home.PasswordDialog;
import com.sap.ip.me.awtapps.home.PasswordSyncDialog;
import com.sap.ip.me.awtapps.home.Settings;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;

public class PasswordManageDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 120;
    public static final int userTextFieldLength = 12;
    public static final int passwordTextFieldLength = 12;
    public static final int clientTextFieldLength = 12;
    public static final int CENTER_PANEL_COUNT_ROWS = 2;
    public static final int CENTER_PANEL_COUNT_COLS = 1;
    public static final String xfld_UserName_KEY = "xfld_UserName";
    public static final String OLD_PASSWORD_KEY = "xfld_OldPassword";
    public static final String NEW_PASSWORD_KEY = "xfld_NewPassword";
    public static final String CONFIRM_PASSWORD_KEY = "xfld_ConfirmPassword";
    public static final String PASSWORDS_DIFFERENT_KEY = "xmsg_PASSWORDS_DIFFERENT";
    public static final String xtit_CHANGE_LOC_PASSWORD = "xtit_CHANGE_LOC_PASSWORD";
    public static final String xtit_CHANGE_SYNC_PASSWORD = "xtit_CHANGE_SYNC_PASSWORD";
    public static final String PASSWORD_WRONG_KEY = "xmsg_PASSWORD_WRONG";
    private static Settings settings = null;
    private Button ok;
    private Button localPasswordButton;
    private Button syncPasswordButton;
    private TextField newPasswordTextField;
    private TextField passwordConfirmTextField;
    private Panel centerPanel;
    private Panel southPanel;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public PasswordManageDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        if (settings == null) {
            settings = new Settings();
        }
        this.containerPanel.setLayout(new BorderLayout());
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(new GridLayout(2, 1));
        this.southPanel = new Panel();
        this.containerPanel.add("Center", this.centerPanel);
        this.containerPanel.add("South", this.southPanel);
        this.localPasswordButton = new Button(this.getLocalPasswordButtonText());
        this.syncPasswordButton = new Button(this.getSyncPasswordButtonText());
        Panel p1 = new Panel();
        Panel p2 = new Panel();
        p1.add(this.localPasswordButton);
        p2.add(this.syncPasswordButton);
        this.centerPanel.add(p1);
        this.centerPanel.add(p2);
        this.ok = new Button(this.getOkButtonText());
        this.southPanel.add(this.ok);
        this.fillControls();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.getOkButtonText())) {
                this.exitDialog();
                return true;
            }
            if (sButton.equals(this.getLocalPasswordButtonText())) {
                this.actionLocalPassword();
                return false;
            }
            if (sButton.equals(this.getSyncPasswordButtonText())) {
                this.actionSyncPassword();
                return false;
            }
        }
        return true;
    }

    private void actionLocalPassword() {
        PasswordDialog passwordDialog = new PasswordDialog((Frame)HomeFrame.getInstance(), this.getLocalPasswordButtonText().substring(0, this.getLocalPasswordButtonText().length() - 3), "userActionInfo");
        HomeFrame.getInstance().showDialog(passwordDialog, false);
    }

    private void actionSyncPassword() {
        PasswordSyncDialog passwordSyncDialog = new PasswordSyncDialog((Frame)HomeFrame.getInstance(), this.getSyncPasswordButtonText().substring(0, this.getSyncPasswordButtonText().length() - 3), "userActionInfo");
        HomeFrame.getInstance().showDialog(passwordSyncDialog, false);
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 120;
    }

    protected void exitDialogOk() {
    }

    protected void exitDialog() {
        ((Component)this).setVisible(false);
    }

    protected void writeSettings() {
    }

    void showPasswordsNotEqualMessage() {
        Message message = new Message((Frame)HomeFrame.getInstance(), 1, "userActionInfo", this.resLang.getString(PASSWORDS_DIFFERENT_KEY));
        ((Component)message).setSize(240, 120);
        Point p = HomeFrame.getCenteredWindowOrigin(240, 120);
        ((Component)message).setLocation(p.x, p.y);
        message.setResizable(true);
        message.show();
        message.dispose();
    }

    void showPasswordWrongMessage() {
        Message message = new Message((Frame)HomeFrame.getInstance(), 1, "userActionInfo", this.resLang.getString(PASSWORD_WRONG_KEY));
        ((Component)message).setSize(240, 120);
        Point p = HomeFrame.getCenteredWindowOrigin(240, 120);
        ((Component)message).setLocation(p.x, p.y);
        message.setResizable(true);
        message.show();
        message.dispose();
    }

    private boolean passwordsEqual() {
        if (this.newPasswordTextField.getText() == null || this.passwordConfirmTextField.getText() == null) {
            if (Trace.getInstance("MI/API/Runtime/AWT").isLogging(60)) {
                Trace.getInstance("MI/API/Runtime/AWT").log(60, "Null pointer in method PasswordManageDialog::passwordsEqual");
            }
            return false;
        }
        return this.newPasswordTextField.getText().equals(this.passwordConfirmTextField.getText());
    }

    private void fillControls() {
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = new Panel(new FlowLayout());
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }

    private String getLocalPasswordButtonText() {
        return HomeFrame.addEllipsis(this.resLang.getString(xtit_CHANGE_LOC_PASSWORD));
    }

    private String getSyncPasswordButtonText() {
        return HomeFrame.addEllipsis(this.resLang.getString(xtit_CHANGE_SYNC_PASSWORD));
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 401 && evt.key == 27) {
            return true;
        }
        if (evt.id == 201) {
            return true;
        }
        return super.handleEvent(evt);
    }
}

