/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.user.LogonException;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.LoginDialog;
import com.sap.ip.me.awtapps.home.Message;
import com.sap.ip.me.awtapps.home.Settings;
import com.sap.ip.me.core.UserManagerImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;

public class NewUserDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 245;
    public static final int userTextFieldLength = 12;
    public static final int userNameTextFieldLength = 12;
    public static final int clientTextFieldLength = 12;
    public static final int CENTER_PANEL_COUNT_ROWS = 4;
    public static final int CENTER_PANEL_COUNT_COLS = 2;
    public static final int passwordTextFieldLength = 12;
    public static final String xfld_UserName_KEY = "xfld_UserName";
    public static final String xbut_Create = "xbut_create";
    public static final String xbut_Logon = "xbut_logon";
    public static final String OLD_PASSWORD_KEY = "xfld_OldPassword";
    public static final String PASSWORD_KEY = "xfld_PASSWORD";
    public static final String CONFIRM_PASSWORD_KEY = "xfld_ConfirmPassword";
    public static final String PASSWORDS_DIFFERENT_KEY = "xmsg_PASSWORDS_DIFFERENT";
    public static final String PASSWORD_WRONG_KEY = "xmsg_PASSWORD_WRONG";
    public static final String xmsg_USER_ALREADY_EXISTS = "xmsg_USER_ALREADY_EXISTS";
    private static Settings settings = null;
    private Button ok;
    private Button create;
    private Button createAndLogon;
    private Button cancel;
    private TextField userNameTextField;
    private TextField passwordTextField;
    private TextField passwordConfirmTextField;
    private Panel centerPanel;
    private Panel southPanel;
    private LoginDialog loginDialog = null;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public NewUserDialog(Frame p_parent, String name, String infMsg, String userNamePara, LoginDialog loginDialogPara) {
        super(p_parent, name, true);
        this.loginDialog = loginDialogPara;
        if (settings == null) {
            settings = new Settings();
        }
        this.containerPanel.setLayout(new BorderLayout());
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(new GridLayout(4, 2));
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.centerPanel);
        this.containerPanel.add("Center", this.southPanel);
        this.create = new Button(this.resLang.getString(xbut_Create));
        this.southPanel.add(this.create);
        this.createAndLogon = new Button(this.getCreateAndLogonButtonText());
        this.southPanel.add(this.createAndLogon);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.userNameTextField = this.initLabelTextField(this.centerPanel, this.resLang.getString(xfld_UserName_KEY), 12);
        this.userNameTextField.setText(userNamePara);
        this.passwordTextField = this.initLabelTextField(this.centerPanel, this.resLang.getString(PASSWORD_KEY), 12);
        this.passwordTextField.setEchoChar('*');
        this.passwordConfirmTextField = this.initLabelTextField(this.centerPanel, this.resLang.getString(CONFIRM_PASSWORD_KEY), 12);
        this.passwordConfirmTextField.setEchoChar('*');
        this.fillControls();
    }

    private String getCreateAndLogonButtonText() {
        return this.resLang.getString(xbut_Create) + " + " + this.resLang.getString(xbut_Logon);
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.resLang.getString(xbut_Create))) {
                this.exitDialogOk();
                return false;
            }
            if (sButton.equals(this.getCreateAndLogonButtonText())) {
                this.exitDialogOk();
                this.loginDialog.sendWord(this.passwordTextField.getText());
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
        }
        return true;
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 245;
    }

    protected void exitDialogOk() {
        if (!this.passwordsEqual()) {
            this.showPasswordsNotEqualMessage();
            this.passwordTextField.setText("");
            this.passwordConfirmTextField.setText("");
            return;
        }
        try {
            UserManagerImpl.getUserManagerImplInstance().addNewUser(this.userNameTextField.getText(), this.passwordTextField.getText(), this.passwordConfirmTextField.getText());
        }
        catch (LogonException e) {
            this.passwordTextField.setText("");
            this.passwordConfirmTextField.setText("");
            switch (e.getMessageId()) {
                case 0: {
                    this.showMessage(this.resLang.getString("xmsg_INVALID_LOGIN"));
                    this.userNameTextField.setText("");
                    break;
                }
                case 1: {
                    this.showMessage(this.resLang.getString("xmsg_INVALID_PASSWORD"));
                    break;
                }
                case 4: {
                    this.showMessage(this.resLang.getString(xmsg_USER_ALREADY_EXISTS));
                    this.userNameTextField.setText("");
                    break;
                }
                default: {
                    this.showMessage(this.resLang.getString("xmsg_LOGIN_FAILED"));
                }
            }
            return;
        }
        this.exitDialog();
    }

    protected void exitDialog() {
        this.loginDialog.sendLoginName(this.userNameTextField.getText());
        ((Component)this).setVisible(false);
    }

    protected void writeSettings() {
    }

    void showPasswordsNotEqualMessage() {
        Message message = new Message((Frame)HomeFrame.getInstance(), 1, "userActionInfo", this.resLang.getString(PASSWORDS_DIFFERENT_KEY));
        ((Component)message).setSize(240, 120);
        Point p = HomeFrame.getCenteredWindowOrigin(240, 120);
        ((Component)message).setLocation(p.x, p.y);
        message.setResizable(true);
        message.show();
        message.dispose();
    }

    void showPasswordWrongMessage() {
        Message message = new Message((Frame)HomeFrame.getInstance(), 1, "userActionInfo", this.resLang.getString(PASSWORD_WRONG_KEY));
        ((Component)message).setSize(240, 120);
        Point p = HomeFrame.getCenteredWindowOrigin(240, 120);
        ((Component)message).setLocation(p.x, p.y);
        message.setResizable(true);
        message.show();
        message.dispose();
    }

    private void fillControls() {
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = new Panel(new FlowLayout());
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }

    private boolean passwordsEqual() {
        if (this.passwordTextField.getText() == null || this.passwordConfirmTextField.getText() == null) {
            if (Trace.getInstance("MI/API/Runtime/AWT").isLogging(60)) {
                Trace.getInstance("MI/API/Runtime/AWT").log(60, "Null pointer in method PasswordDialog::passwordsEqual");
            }
            return false;
        }
        return this.passwordTextField.getText().equals(this.passwordConfirmTextField.getText());
    }
}

