/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.user.LogonException;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.awtapps.home.AWTDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.NewUserDialog;
import com.sap.ip.me.awtapps.home.PasswordDialog;
import com.sap.ip.me.awtapps.home.PasswordServerDialog;
import com.sap.ip.me.awtapps.home.Settings;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Vector;

public class LoginDialog
extends AWTDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 250;
    public static final int userTextFieldLength = 12;
    public static final int passwordTextFieldLength = 12;
    public static final int languageTextFieldLength = 12;
    public static final int clientTextFieldLength = 12;
    public static final int CENTER_PANEL_COUNT_ROWS = 4;
    public static final int CENTER_PANEL_COUNT_COLS = 2;
    public static final String xfld_UserName_KEY = "xfld_UserName";
    public static final String xbut_logon = "xbut_logon";
    public static final String xbut_NEW_USER = "xbut_NEW_USER";
    public static final String xtit_NEW_USER = "xtit_NEW_USER";
    public static final String xmsg_USER_UNKNOWN = "xmsg_USER_UNKNOWN";
    public static final String xmsg_USER_ALREADY_EXISTS = "xmsg_USER_ALREADY_EXISTS";
    public static final String xmsg_EMPTY_USER_NAME = "xmsg_EMPTY_USER_NAME";
    public static final String xmsg_RESERVED_USER_NAME = "xmsg_RESERVED_USER_NAME";
    public static final String xmsg_INVALID_USER_NAME = "xmsg_INVALID_USER_NAME";
    public static final String xmsg_EMPTY_LOCAL_PASSWORD = "xmsg_EMPTY_LOCAL_PASSWORD";
    public static final String xmsg_INVALID_LOC_PASS_LENG = "xmsg_INVALID_LOC_PASS_LENG";
    public static final String xmsg_WRONG_USER_OR_PASS = "xmsg_WRONG_USER_OR_PASS";
    public static final String xmsg_LOC_PASS_CONF_DIFFERS = "xmsg_LOC_PASS_CONF_DIFFERS";
    public static final String xmsg_NEW_LOC_PASS_CONF_DIF = "xmsg_NEW_LOC_PASS_CONF_DIF";
    public static final String xlnk_CHANGE_PASSWORD = "xlnk_CHANGE_PASSWORD";
    public static final String xtit_CHANGE_LOC_PASSWORD = "xtit_CHANGE_LOC_PASSWORD";
    public static final String PASSWORD_KEY = "xfld_PASSWORD";
    private static Settings settings = null;
    private Button ok;
    private Button cancel;
    private Button newUser;
    private Button changePasswordButton;
    private TextField userTextField;
    private TextField passwordTextField;
    private TextField languageTextField;
    private Choice languageChoice;
    private Panel centerPanel;
    private Panel southPanel;
    private Frame parent = null;
    private String sentLoginName = "";
    private String sentWord = "";
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public LoginDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        this.parent = p_parent;
        if (settings == null) {
            settings = new Settings();
        }
        this.setLayout(new BorderLayout());
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(new GridLayout(4, 2));
        this.southPanel = new Panel(new FlowLayout());
        this.add("North", this.centerPanel);
        this.add("Center", this.southPanel);
        this.userTextField = this.initLabelTextField(this.centerPanel, this.resLang.getString(xfld_UserName_KEY), 12);
        this.passwordTextField = this.initLabelTextField(this.centerPanel, this.resLang.getString(PASSWORD_KEY), 12);
        this.passwordTextField.setEchoChar('*');
        this.centerPanel.add(new Label(this.resLang.getString("LANGUAGE"), 2));
        this.languageChoice = new Choice();
        this.centerPanel.add(this.languageChoice);
        this.ok = new Button(this.resLang.getString(xbut_logon));
        this.southPanel.add(this.ok);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.newUser = new Button(HomeFrame.addEllipsis(this.resLang.getString(xbut_NEW_USER)));
        this.southPanel.add(this.newUser);
        this.changePasswordButton = new Button(HomeFrame.addEllipsis(this.resLang.getString(xlnk_CHANGE_PASSWORD)));
        this.southPanel.add(this.changePasswordButton);
        this.fillControls();
        this.addNotify();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.resLang.getString(xbut_logon))) {
                this.actionOk();
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
            if (sButton.equals(HomeFrame.addEllipsis(this.resLang.getString(xbut_NEW_USER)))) {
                this.StartNewUserDialog();
                if (this.sentWord.length() > 0) {
                    this.passwordTextField.setText(this.sentWord);
                    this.actionOk();
                }
                return false;
            }
            if (sButton.equals(HomeFrame.addEllipsis(this.resLang.getString(xlnk_CHANGE_PASSWORD)))) {
                if (this.actionOk()) {
                    if (HomeFrame.isLocalPwSameAsSyncPw()) {
                        this.userActionPassword();
                    } else {
                        this.actionLocalPassword();
                    }
                }
                return false;
            }
        }
        return true;
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 250;
    }

    protected void exitAndSaveDialogOk() {
        ((Component)this).setVisible(false);
        this.writeSettings();
    }

    protected void exitDialogOk() {
        this.actionOk();
    }

    protected void writeSettings() {
    }

    private boolean actionOk() {
        try {
            UserManager.getInstance().logOnUser(this.userTextField.getText(), this.passwordTextField.getText());
        }
        catch (LogonException e) {
            this.passwordTextField.setText("");
            this.showMessage(e.getLocalizedMessage());
            return false;
        }
        String selLang = this.languageChoice.getSelectedItem().toLowerCase();
        Localization.setLanguage(selLang);
        HomeFrame.getInstance().languageHasChanged();
        this.exitAndSaveDialogOk();
        return true;
    }

    private void fillControls() {
        Vector v = Localization.getAllLanguages();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.languageChoice.addItem((String)e.nextElement());
        }
        String langStr = Localization.getLanguage();
        this.languageChoice.select(langStr);
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = new Panel(new FlowLayout());
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }

    private void StartNewUserDialog() {
        this.sentLoginName = "";
        this.sentWord = "";
        NewUserDialog newUserDialog = new NewUserDialog(this.parent, this.resLang.getString(xtit_NEW_USER), "userActionInfo", this.userTextField.getText(), this);
        ((Component)newUserDialog).setSize(newUserDialog.getPrefWidth(), newUserDialog.getPrefHeight());
        Point p = HomeFrame.getCenteredWindowOrigin(newUserDialog.getPrefWidth(), newUserDialog.getPrefHeight());
        ((Component)newUserDialog).setLocation(p.x, p.y);
        newUserDialog.setResizable(false);
        newUserDialog.show();
        newUserDialog.dispose();
        this.userTextField.setText(this.sentLoginName);
        this.passwordTextField.requestFocus();
    }

    public void sendLoginName(String loginName) {
        this.sentLoginName = loginName;
    }

    public void sendWord(String word) {
        this.sentWord = word;
    }

    private void actionLocalPassword() {
        PasswordDialog passwordDialog = new PasswordDialog((Frame)HomeFrame.getInstance(), this.getLocalPasswordButtonText().substring(0, this.getLocalPasswordButtonText().length() - 3), "userActionInfo");
        HomeFrame.getInstance().showDialog(passwordDialog, false);
    }

    private String getLocalPasswordButtonText() {
        return HomeFrame.addEllipsis(this.resLang.getString(xtit_CHANGE_LOC_PASSWORD));
    }

    private void userActionPassword() {
        PasswordServerDialog passwordServerDialog = new PasswordServerDialog((Frame)HomeFrame.getInstance(), this.resLang.getString(xlnk_CHANGE_PASSWORD), "userActionInfo");
        HomeFrame.getInstance().showDialog(passwordServerDialog, false);
    }
}

