/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.Settings;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class LocaleSettingsDialog
extends AWTScrollDialog
implements ItemListener {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 230;
    public static final int gatewayTextFieldLength = 11;
    public static final int clientTextFieldLength = 11;
    public static final int languageTextFieldLength = 11;
    public static final int CENTER_PANEL_COUNT_ROWS = 5;
    public static final int CENTER_PANEL_COUNT_COLS = 2;
    public static final String CLIENT_LABEL_TEXT = "CLIENT";
    public static final String COUNTRY_LABEL_TEXT = "xfld_COUNTRY";
    public static final String TIMEZONE_LABEL_TEXT = "xfld_TIMEZONE";
    public static final String DAYLIGHTSAVINGFLAG_LABEL_TEXT = "xfld_DAYLIGHTSAVINGFLAG";
    public static final String xmsg_YES = "xmsg_YES";
    public static final String xmsg_NO = "xmsg_NO";
    private static Settings settings = null;
    private Button ok;
    private Button cancel;
    private Choice languageChoice;
    private Choice countryChoice;
    private Choice timeZoneChoice;
    private Label dsfLabel;
    private TextField clientTextField;
    private TextField languageTextField;
    private Panel centerPanel;
    private Panel southPanel;
    private Panel northPanel;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());
    private String countryCancel = "";
    private String languageCancel = "";
    private TimeZone timeZoneCancel = null;
    private Vector vCountries = null;

    public LocaleSettingsDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        this.saveForCancel();
        if (settings == null) {
            settings = new Settings();
        }
        this.containerPanel.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        this.northPanel = new Panel();
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(gridbag);
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        this.containerPanel.add("South", this.southPanel);
        this.languageChoice = new Choice();
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label labelLang = new Label(this.resLang.getString("LANGUAGE"), 2);
        gridbag.setConstraints(labelLang, c);
        this.centerPanel.add(labelLang);
        c.weightx = 1.0;
        c.gridwidth = 0;
        boolean flowOut = false;
        Panel languagePanel = null;
        languagePanel = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        languagePanel.add(this.languageChoice);
        gridbag.setConstraints(languagePanel, c);
        this.centerPanel.add(languagePanel);
        this.countryChoice = new Choice();
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label labelCountry = new Label(this.resLang.getString(COUNTRY_LABEL_TEXT), 2);
        gridbag.setConstraints(labelCountry, c);
        this.centerPanel.add(labelCountry);
        c.weightx = 1.0;
        c.gridwidth = 0;
        flowOut = false;
        Panel countryPanel = null;
        countryPanel = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        countryPanel.add(this.countryChoice);
        gridbag.setConstraints(countryPanel, c);
        this.centerPanel.add(countryPanel);
        this.timeZoneChoice = new Choice();
        this.timeZoneChoice.addItemListener(this);
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label labelTimeZone = new Label(this.resLang.getString(TIMEZONE_LABEL_TEXT), 2);
        gridbag.setConstraints(labelTimeZone, c);
        this.centerPanel.add(labelTimeZone);
        c.weightx = 1.0;
        c.gridwidth = 0;
        flowOut = false;
        Panel timeZonePanel = null;
        timeZonePanel = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        timeZonePanel.add(this.timeZoneChoice);
        gridbag.setConstraints(timeZonePanel, c);
        this.centerPanel.add(timeZonePanel);
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.dsfLabel = new Label(this.resLang.getString(DAYLIGHTSAVINGFLAG_LABEL_TEXT), 1);
        gridbag.setConstraints(this.dsfLabel, c);
        this.centerPanel.add(this.dsfLabel);
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.ok = new Button(this.getOkButtonText());
        this.southPanel.add(this.ok);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.fillControls();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (!(source instanceof Choice)) {
            return;
        }
        Choice choice = (Choice)source;
        if (choice != this.timeZoneChoice) {
            return;
        }
        String s = e.getSource().toString();
        if (e.getStateChange() == 1) {
            TimeZone timeZone = TimeZone.getTimeZone(this.timeZoneChoice.getSelectedItem());
            String saveTime = this.resLang.getString(xmsg_NO);
            saveTime = timeZone.useDaylightTime() ? this.resLang.getString(xmsg_YES) : this.resLang.getString(xmsg_NO);
            this.dsfLabel.setText(this.resLang.getString(DAYLIGHTSAVINGFLAG_LABEL_TEXT) + ": " + saveTime);
        }
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.getOkButtonText())) {
                this.actionOk();
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.doCancel();
                this.exitDialogEscape();
                return false;
            }
        }
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(240, 230);
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 230;
    }

    protected void writeSettings() {
        this.readControls();
    }

    protected void exitAndSaveDialogOk() {
        ((Component)this).setVisible(false);
        this.writeSettings();
    }

    private void fillControls() {
        this.languageChoice.removeAll();
        Vector vL = Localization.getAllLanguages();
        Enumeration e = vL.elements();
        while (e.hasMoreElements()) {
            this.languageChoice.addItem((String)e.nextElement());
        }
        String langStr = Localization.getLanguage();
        this.languageChoice.select(langStr);
        this.countryChoice.removeAll();
        this.vCountries = Localization.getAllCountriesSorted();
        String countryStr = Localization.getCountry();
        int selIndex = 0;
        int l = 0;
        while (l < this.vCountries.size()) {
            String[] sa = (String[])this.vCountries.elementAt(l);
            this.countryChoice.addItem(sa[1]);
            String isoCountry = sa[0];
            if (countryStr.equals(isoCountry)) {
                selIndex = l;
            }
            ++l;
        }
        this.countryChoice.select(selIndex);
        this.timeZoneChoice.removeAll();
        Vector vT = Localization.getAllTimezones();
        Enumeration e2 = vT.elements();
        while (e2.hasMoreElements()) {
            this.timeZoneChoice.addItem((String)e2.nextElement());
        }
        TimeZone timeZone = Localization.getTimeZone();
        String timeZoneStr = timeZone.getID();
        this.timeZoneChoice.select(timeZoneStr);
        String saveTime = this.resLang.getString(xmsg_NO);
        saveTime = timeZone.useDaylightTime() ? this.resLang.getString(xmsg_YES) : this.resLang.getString(xmsg_NO);
        this.dsfLabel.setText(this.resLang.getString(DAYLIGHTSAVINGFLAG_LABEL_TEXT) + ": " + saveTime);
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }

    private TextField initLabelTextFieldGridBag(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut, GridBagLayout gridbag, GridBagConstraints c) {
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label label = new Label(labelText, 2);
        gridbag.setConstraints(label, c);
        intoPanel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        gridbag.setConstraints(p, c);
        intoPanel.add(p);
        return textField;
    }

    private void readControls() {
        String selLang = this.languageChoice.getSelectedItem().toLowerCase();
        Localization.setLanguage(selLang);
        HomeFrame.getInstance().languageHasChanged();
        String[] sa = (String[])this.vCountries.elementAt(this.countryChoice.getSelectedIndex());
        String countryIsoStr = sa[0];
        Localization.setCountry(countryIsoStr);
        String timeZone = this.timeZoneChoice.getSelectedItem();
        Localization.setTimeZone(TimeZone.getTimeZone(timeZone));
    }

    private void actionOk() {
        String selLang = this.languageChoice.getSelectedItem().toLowerCase();
        Localization.setLanguage(selLang);
        HomeFrame.getInstance().languageHasChanged();
        this.exitAndSaveDialogOk();
    }

    private void doCancel() {
        Localization.setCountry(this.countryCancel);
        Localization.setLanguage(this.languageCancel);
        Localization.setTimeZone(this.timeZoneCancel);
        HomeFrame.getInstance().languageHasChanged();
    }

    private void saveForCancel() {
        this.countryCancel = Localization.getCountry();
        this.languageCancel = Localization.getLanguage();
        this.timeZoneCancel = Localization.getTimeZone();
    }
}

