/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.apps.DeploymentInstallLog;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class InstallLogDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 300;
    public static final int BODY_AREA_ROWS = 8;
    private final String ACTION_OK = "ok";
    private Panel northPanel = new Panel();
    private Panel centerPanel = new Panel();
    private Panel southPanel = new Panel();
    private Button btnOk;
    private Font headerFont;
    private Button[] details;
    private ScrollPane scrollPanel = null;
    private DeploymentInbox depInbox = DeploymentInbox.getInstance();
    private String appName;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());
    private boolean logExists = true;

    public InstallLogDialog(Frame p_parent, String name, String appName) {
        super(p_parent, name, true);
        this.appName = appName;
        DeploymentInstallLog log = this.depInbox.getApplicationLog(appName);
        String[] contents = null;
        boolean cols = true;
        int rows = 1;
        if (log != null) {
            contents = log.getAllLines();
            rows = contents.length;
        } else {
            this.logExists = false;
        }
        this.initLayout(rows, 1);
        this.setTitle();
        if (this.logExists) {
            this.populateContents(contents);
        } else {
            this.populateMsgNoLog();
        }
        this.setFooter();
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 300;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    private void setFooter() {
        this.btnOk = new Button(this.resLang.getString("xbut_OK"));
        this.btnOk.setActionCommand("ok");
        this.southPanel.add(this.btnOk);
        this.btnOk.addActionListener(new EventHandler());
    }

    private void setTitle() {
        Label title = new Label(this.resLang.getString("xtit_INSTLOG") + " - " + this.appName);
        title.setFont(this.headerFont);
        this.northPanel.add(title);
    }

    private void initLayout(int rows, int cols) {
        this.headerFont = new Font("Arial", 1, 12);
        this.setLayout(new BorderLayout());
        if (++rows < 8) {
            rows = 8;
        }
        GridLayout gridLayout = new GridLayout(rows, cols);
        this.centerPanel.setLayout(gridLayout);
        this.scrollPanel = new ScrollPane(0);
        this.scrollPanel.add(this.centerPanel);
        this.add("North", this.northPanel);
        this.add("Center", this.scrollPanel);
        this.add("South", this.southPanel);
    }

    private void populateContents(String[] contents) {
        int noOfRows = contents.length;
        String line = null;
        int i = 0;
        while (i < noOfRows) {
            line = contents[i];
            this.centerPanel.add(new Label(line));
            ++i;
        }
        int i2 = noOfRows + 1;
        while (i2 < 8) {
            this.centerPanel.add(new Label(" "));
            ++i2;
        }
    }

    private void populateMsgNoLog() {
        this.centerPanel.add(new Label(this.resLang.getString("xmsg_NO_LOG")));
    }

    private String[] generateInstantTestData(int noOfRecords) {
        String[] lines = new String[noOfRecords];
        int i = 0;
        while (i < noOfRecords) {
            lines[i] = this.appName + " TestLine " + (i + 1);
            ++i;
        }
        return lines;
    }

    private void performOkClicked() {
        ((Component)this).setVisible(false);
    }

    public class EventHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("ok")) {
                InstallLogDialog.this.performOkClicked();
            }
        }
    }
}

