/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.Settings;
import com.sap.ip.me.core.SyncSettings;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class GatewayDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 230;
    public static final int portTextFieldLength = 11;
    public static final int systemTextFieldLength = 11;
    public static final int languageTextFieldLength = 11;
    public static final int CENTER_PANEL_COUNT_ROWS = 6;
    public static final int CENTER_PANEL_COUNT_COLS = 2;
    public static final String PROXYHOST_ID_LABEL_TEXT = "PROXYHOST";
    public static final String PORT_LABEL_TEXT = "PORT";
    public static final String PROTOCOL_BIT_TEXT = "xfld_PROTOCOL";
    public static final String SYSTEM_LABEL_TEXT = "xfld_SYSTEM";
    public static final String LANGUAGE_LABEL_TEXT = "LANGUAGE";
    public static final String HTTP_TEXT = "http";
    public static final String HTTPS_TEXT = "https";
    private static Settings settings = null;
    private Button ok;
    private Button cancel;
    private TextField proyhostTextField;
    private TextField portTextField;
    private Label proxyBitLabel;
    private Checkbox proxyBitCheckbox;
    private Choice protocolChoice;
    private TextField systemTextField;
    private Panel centerPanel;
    private Panel southPanel;
    private Panel northPanel;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public GatewayDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        if (settings == null) {
            settings = new Settings();
        }
        this.containerPanel.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        this.northPanel = new Panel();
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(gridbag);
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        this.containerPanel.add("South", this.southPanel);
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label label = new Label(this.resLang.getString(PROTOCOL_BIT_TEXT), 2);
        gridbag.setConstraints(label, c);
        this.centerPanel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.protocolChoice = new Choice();
        gridbag.setConstraints(this.protocolChoice, c);
        this.centerPanel.add(this.protocolChoice);
        this.proyhostTextField = this.initLabelTextFieldGridBag(this.centerPanel, this.resLang.getString(PROXYHOST_ID_LABEL_TEXT), 11, false, gridbag, c);
        this.portTextField = this.initLabelTextFieldGridBag(this.centerPanel, this.resLang.getString(PORT_LABEL_TEXT), 11, false, gridbag, c);
        this.systemTextField = this.initLabelTextFieldGridBag(this.centerPanel, this.resLang.getString(SYSTEM_LABEL_TEXT), 11, false, gridbag, c);
        this.ok = new Button(this.getOkButtonText());
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.ok);
        this.southPanel.add(this.cancel);
        this.fillControls();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.getOkButtonText())) {
                this.exitDialogOk();
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
        }
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(240, 230);
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 230;
    }

    protected void writeSettings() {
        String host = this.proyhostTextField.getText();
        String port = this.portTextField.getText();
        String protocol = this.protocolChoice.getSelectedItem();
        String system = this.systemTextField.getText();
        Configuration configuration = Configuration.getInstance();
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.Protocol", protocol);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.Host", host);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.Port", port);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway.System", system);
        configuration.setDefaultProperty("MobileEngine.Sync.Gateway", SyncSettings.getSyncGateway());
    }

    private void fillControls() {
        String protocol = Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.Protocol", "");
        String host = Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.Host", "");
        String port = Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.Port", "");
        String system = Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.System", "");
        this.proyhostTextField.setText(host);
        this.portTextField.setText(port);
        this.protocolChoice.addItem(HTTP_TEXT);
        this.protocolChoice.addItem(HTTPS_TEXT);
        if (protocol != null) {
            if (protocol.equals(HTTP_TEXT)) {
                this.protocolChoice.select(HTTP_TEXT);
            } else {
                this.protocolChoice.select(HTTPS_TEXT);
            }
        }
        this.systemTextField.setText(system);
    }

    private TextField initLabelTextField(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut) {
        intoPanel.add(new Label(labelText, 2));
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        intoPanel.add(p);
        return textField;
    }

    private TextField initLabelTextFieldGridBag(Panel intoPanel, String labelText, int textFieldLength, boolean flowOut, GridBagLayout gridbag, GridBagConstraints c) {
        c.fill = 1;
        c.weightx = 0.0;
        c.gridwidth = -1;
        Label label = new Label(labelText, 2);
        gridbag.setConstraints(label, c);
        intoPanel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        Panel p = null;
        p = flowOut ? new Panel(new FlowLayout()) : new Panel(new GridLayout(1, 1, 5, 5));
        TextField textField = new TextField(textFieldLength);
        p.add(textField);
        gridbag.setConstraints(p, c);
        intoPanel.add(p);
        return textField;
    }
}

