/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.About;
import com.sap.ip.me.awtapps.home.DiscSyncProcess;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.sync.DiscSyncException;
import com.sap.ip.me.sync.MediaType;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class DiscSyncTargetDialog
extends AWTScrollDialog
implements ItemListener {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 180;
    public static final int TEXT_AREA_ROWS = 7;
    public static final int TEXT_AREA_COLS = 28;
    public static final int portTextFieldLength = 17;
    public static final String xbut_add = "xbut_add";
    public static final String xbut_clearList = "xbut_clearList";
    public static final String xbut_back = "xbut_back";
    public static final String xbut_JSP_SYNC = "xbut_JSP_SYNC";
    public static final String xtit_discsync_targetsize = "xtit.discsync.targetsize";
    public static final String xfld_discsync_media = "xfld.discsync.media";
    public static final String xfld_discsync_mediasize = "xfld.discsync.mediasize";
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int NEXT = 3;
    public static final int BACK = 4;
    private static About about = null;
    private Button cancel;
    private Panel northPanel;
    private Panel centerPanel;
    private Panel southPanel;
    private TextField newSyncProcessField;
    private Button clearButton;
    private Button backButton;
    private Button syncButton;
    private Choice mediaChooser;
    private Choice unitChooser;
    private MediaType[] mTypes;
    private Frame parent;
    private DiscSyncProcess discSyncProcess;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public DiscSyncTargetDialog(Frame p_parent, String name, String infMsg, DiscSyncProcess dsp) {
        super(p_parent, name, true);
        this.parent = p_parent;
        this.discSyncProcess = dsp;
        this.containerPanel.setLayout(new BorderLayout());
        this.northPanel = new Panel();
        this.northPanel.setLayout(new GridLayout(4, 1));
        this.centerPanel = new Panel(new BorderLayout());
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        Label mediaLabel = new Label(this.resLang.getString(xfld_discsync_media), 0);
        this.northPanel.add(mediaLabel);
        this.mediaChooser = new Choice();
        this.mTypes = dsp.getDiscSyncController().getConfiguration().getMediaTypes();
        int i = 0;
        while (i < this.mTypes.length) {
            this.mediaChooser.addItem(this.mTypes[i].toString());
            ++i;
        }
        this.northPanel.add(this.mediaChooser);
        this.mediaChooser.addItemListener(this);
        Label localmeLabel = new Label(this.resLang.getString(xfld_discsync_mediasize), 0);
        this.northPanel.add(localmeLabel);
        Panel northInputPanel = new Panel(new BorderLayout());
        this.northPanel.add(northInputPanel);
        this.newSyncProcessField = new TextField(17);
        northInputPanel.add("Center", this.newSyncProcessField);
        this.newSyncProcessField.setEnabled(false);
        this.unitChooser = new Choice();
        String[] units = dsp.getDiscSyncController().getConfiguration().getUnits();
        int i2 = 0;
        while (i2 < units.length) {
            this.unitChooser.addItem(units[i2]);
            ++i2;
        }
        northInputPanel.add("East", this.unitChooser);
        this.unitChooser.setEnabled(false);
        this.clearButton = new Button(this.resLang.getString(xbut_clearList));
        Panel flPanel = new Panel(new FlowLayout());
        Panel centerCenterPanel = new Panel();
        centerCenterPanel.add(this.southPanel);
        this.centerPanel.add("North", flPanel);
        this.centerPanel.add("Center", centerCenterPanel);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.backButton = new Button(this.resLang.getString(xbut_back));
        this.southPanel.add(this.backButton);
        this.syncButton = new Button(this.resLang.getString(xbut_JSP_SYNC));
        this.southPanel.add(this.syncButton);
        this.setControls(this.discSyncProcess.getDiscSyncController().getConfiguration().getCurrentMediaType());
    }

    private boolean doSync() {
        String userSize;
        MediaType selectedMediaType = this.getSelectedMediaType();
        if (selectedMediaType != null && selectedMediaType.isUserDefined() && (userSize = this.newSyncProcessField.getText()).length() > 0) {
            try {
                this.discSyncProcess.getDiscSyncController().getConfiguration().setCurrentMediaSize(this.newSyncProcessField.getText(), this.unitChooser.getSelectedIndex());
            }
            catch (DiscSyncException discSyncExc) {
                this.showMessage(discSyncExc.getLocalizedMessage());
                if (this.discSyncProcess.getDiscSyncController().getConfiguration().getCurrentMediaType().isUserDefined()) {
                    long size = this.discSyncProcess.getDiscSyncController().getConfiguration().getCurrentMediaType().getSize();
                    this.newSyncProcessField.setText(Long.toString(size));
                    this.unitChooser.select(0);
                }
                return false;
            }
        }
        try {
            this.discSyncProcess.getDiscSyncController().callSync();
            return true;
        }
        catch (DiscSyncException discSyncExc) {
            this.showMessage(discSyncExc.getLocalizedMessage());
            return false;
        }
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.resLang.getString(xbut_JSP_SYNC))) {
                if (this.doSync()) {
                    ((Component)this).setVisible(false);
                    this.discSyncProcess.sendReturnValuesStep2(3);
                }
                return false;
            }
            if (sButton.equals(this.resLang.getString(xbut_back))) {
                ((Component)this).setVisible(false);
                this.discSyncProcess.sendReturnValuesStep2(4);
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
        }
        return true;
    }

    protected void exitDialogEscape() {
        this.discSyncProcess.sendReturnValuesStep2(2);
        ((Component)this).setVisible(false);
    }

    private MediaType getSelectedMediaType() {
        MediaType selectedMediaType = null;
        String mediaChooserName = this.mediaChooser.getSelectedItem();
        if (mediaChooserName != null) {
            int i = 0;
            while (i < this.mTypes.length) {
                String name = this.mTypes[i].toString();
                if (name != null && name.equals(this.mediaChooser.getSelectedItem())) {
                    selectedMediaType = this.mTypes[i];
                }
                ++i;
            }
        }
        return selectedMediaType;
    }

    private void setMediaChooser(MediaType mediaType) {
        this.mediaChooser.select(mediaType.toString());
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (!(source instanceof Choice)) {
            return;
        }
        Choice choice = (Choice)source;
        if (choice != this.mediaChooser) {
            return;
        }
        MediaType selectedMediaType = this.getSelectedMediaType();
        String s = e.getSource().toString();
        this.setControls(selectedMediaType);
    }

    private void setControls(MediaType selectedMediaType) {
        if (selectedMediaType != null) {
            this.setMediaChooser(selectedMediaType);
            if (selectedMediaType.isUserDefined()) {
                this.newSyncProcessField.setEnabled(true);
                this.unitChooser.setEnabled(true);
                long size = selectedMediaType.getSize();
                this.newSyncProcessField.setText(Long.toString(size));
                this.unitChooser.select(0);
            } else {
                this.newSyncProcessField.setEnabled(false);
                this.unitChooser.setEnabled(false);
                this.discSyncProcess.getDiscSyncController().getConfiguration().setCurrentMediaSize(selectedMediaType.getSize());
                this.newSyncProcessField.setText("");
            }
        }
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 180;
    }
}

