/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.About;
import com.sap.ip.me.awtapps.home.DiscSyncProcess;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.sync.DiscSyncException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.util.Vector;

public class DiscSyncResultDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 280;
    public static final int GRID_ROWS = 3;
    public static final int TEXT_AREA_ROWS = 8;
    public static final int TEXT_AREA_COLS = 28;
    public static final int portTextFieldLength = 17;
    public static final String xfld_targetFiles = "xfld.discsync.target";
    public static final String xbut_browse = "xbut.discsync.browse";
    public static final String xbut_add = "xbut.discsync.add";
    public static final String xbut_clearList = "xbut.discsync.clearList";
    public static final String xbut_back = "xbut.discsync.back";
    public static final String xbut_next = "xbut.discsync.close";
    public static final String xfld_discsync_syncstate = "xfld.discsync.syncstate";
    public static final String xfld_discsync_SYNCSUCCESSFULL = "SYNCSUCCESSFULL";
    public static final String xfld_discsync_filestocopy = "xfld.discsync.filestocopy";
    public static final String xbut_discsync_copyfile = "xbut.discsync.copyfile";
    public static final String xmsg_JSP_SYNC_SUCCESS = "xmsg_JSP_SYNC_SUCCESS";
    public static final String xmsg_discsync_syncfailed = "xmsg.discsync.syncfailed";
    public static final String xmsg_discsync_cancelcopy = "xmsg.discsync.cancelcopy";
    private static About about = null;
    private Button cancel;
    private Button copy;
    private Panel northPanel;
    private Panel centerPanel;
    private Panel southPanel;
    private Label syncStatus;
    private Label syncStatusMsg;
    private Label targetFiles;
    private TextArea textArea;
    private TextField newSyncProcessField;
    private Button backButton;
    private Button nextButton;
    private Vector fileList = new Vector();
    Frame parent;
    DiscSyncProcess discSyncProcess;
    String[] downloadableFileList;
    int indexOfCopiedFile = 0;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public DiscSyncResultDialog(Frame p_parent, String name, String infMsg, DiscSyncProcess dsp) {
        super(p_parent, name, true);
        this.parent = p_parent;
        this.discSyncProcess = dsp;
        this.downloadableFileList = this.discSyncProcess.getDiscSyncController().getConfiguration().getDownloadableFiles();
        this.containerPanel.setLayout(new BorderLayout());
        this.northPanel = new Panel();
        this.northPanel.setLayout(new GridLayout(3, 1));
        this.centerPanel = new Panel(new BorderLayout());
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        Font localStandardFont = this.getFont();
        Font localFont = new Font(localStandardFont.getName(), 1, 12);
        Label localmeLabel = new Label(this.resLang.getString(xfld_targetFiles), 0);
        this.northPanel.add(localmeLabel);
        Panel northInputPanel = new Panel(new BorderLayout());
        this.northPanel.add(northInputPanel);
        this.newSyncProcessField = new TextField(17);
        northInputPanel.add("Center", this.newSyncProcessField);
        Panel bp = new Panel(new BorderLayout());
        Label l1 = new Label(this.resLang.getString(xfld_discsync_filestocopy), 0);
        l1.setFont(localFont);
        bp.add("West", l1);
        this.copy = new Button(this.resLang.getString(xbut_discsync_copyfile));
        Label l2 = new Label("L2", 0);
        bp.add("East", this.copy);
        this.northPanel.add(bp);
        Panel centerCenterPanel = new Panel();
        this.textArea = new TextArea(8, 28);
        this.textArea.setEditable(false);
        centerCenterPanel.add(this.textArea);
        centerCenterPanel.add(this.southPanel);
        this.centerPanel.add("Center", centerCenterPanel);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.backButton = new Button(this.resLang.getString(xbut_back));
        this.backButton.setEnabled(false);
        this.southPanel.add(this.backButton);
        this.nextButton = new Button(this.resLang.getString(xbut_next));
        this.southPanel.add(this.nextButton);
        this.fillControls();
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.resLang.getString(xbut_next))) {
                this.exitDialogOk();
                return false;
            }
            if (sButton.equals(this.resLang.getString(xbut_back))) {
                ((Component)this).setVisible(false);
                this.discSyncProcess.sendReturnValuesStep3(4, this.fileList);
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
            if (sButton.equals(this.resLang.getString(xbut_discsync_copyfile))) {
                this.copyFile();
                return false;
            }
            if (sButton.equals(this.resLang.getString(xbut_browse))) {
                FileDialog fd = new FileDialog(this.parent, "FileDialog");
                ((Component)fd).setVisible(true);
                String fileName = fd.getFile();
                String dir = fd.getDirectory();
                String pathAndName = dir.concat(fileName);
                this.newSyncProcessField.setText(pathAndName);
                return false;
            }
        }
        return true;
    }

    protected void exitDialogEscape() {
        if (!this.isCopyProcessCompleted()) {
            if (this.showQMessage(this.resLang.getString(xmsg_discsync_cancelcopy))) {
                this.discSyncProcess.sendReturnValuesStep3(2, this.fileList);
                ((Component)this).setVisible(false);
            }
        } else {
            this.discSyncProcess.sendReturnValuesStep3(2, this.fileList);
            ((Component)this).setVisible(false);
        }
    }

    protected void exitDialogOk() {
        if (this.isCopyProcessCompleted()) {
            this.discSyncProcess.getDiscSyncController().getConfiguration().setSourceLocation(this.newSyncProcessField.getText());
        } else if (this.showQMessage(this.resLang.getString(xmsg_discsync_cancelcopy))) {
            ((Component)this).setVisible(false);
            this.discSyncProcess.sendReturnValuesStep3(5, this.fileList);
        }
    }

    private void copyFile() {
        if (this.isCopyProcessCompleted()) {
            return;
        }
        String downloadableFile = this.downloadableFileList[this.indexOfCopiedFile];
        try {
            this.discSyncProcess.getDiscSyncController().copyFileToMedia(downloadableFile);
            ++this.indexOfCopiedFile;
            this.fillTargetFileListControl();
            if (this.isCopyProcessCompleted()) {
                this.copy.setEnabled(false);
            }
        }
        catch (DiscSyncException discSyncExc) {
            this.showMessage(discSyncExc.getLocalizedMessage());
        }
    }

    private boolean isCopyProcessCompleted() {
        int listLength = this.downloadableFileList.length;
        if (listLength <= 0 || listLength == this.indexOfCopiedFile) {
            return true;
        }
        return this.indexOfCopiedFile == listLength;
    }

    private void fillTargetFileListControl() {
        this.textArea.setText("");
        int i = 0;
        while (i < this.downloadableFileList.length) {
            if (i == this.indexOfCopiedFile) {
                this.textArea.append("  ->\t");
            } else {
                this.textArea.append("\t");
            }
            this.textArea.append(this.downloadableFileList[i]);
            this.textArea.append("\n");
            ++i;
        }
    }

    private void fillControls() {
        this.newSyncProcessField.setText(this.discSyncProcess.getDiscSyncController().getConfiguration().getSourceLocation());
        this.fillTargetFileListControl();
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 280;
    }
}

