/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.apps.SyncProtocol;
import com.sap.ip.me.awtapps.home.DiscSyncAddDialog;
import com.sap.ip.me.awtapps.home.DiscSyncResultDialog;
import com.sap.ip.me.awtapps.home.DiscSyncTargetDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.sync.DiscSyncController;
import java.awt.Frame;
import java.util.Vector;

public class DiscSyncProcess {
    public static final int NO_STATE = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int NEXT = 3;
    public static final int BACK = 4;
    public static final int FINISH = 5;
    private MEResourceBundle resLang = null;
    private Vector syncFileList = new Vector();
    private Vector targetFileList = new Vector();
    private int navigationCodeStep1 = 0;
    private int navigationCodeStep2 = 0;
    private int navigationCodeStep3 = 0;
    private int state = 0;
    public static final int STATE_STEP1 = 0;
    public static final int STATE_STEP2 = 1;
    public static final int STATE_STEP3 = 2;
    public static final String xmsg_JSP_SYNC_SUCCESS = "xmsg_JSP_SYNC_SUCCESS";
    public static final String xmsg_discsync_syncfailed = "xmsg.discsync.syncfailed";
    private DiscSyncController discSyncController;

    public DiscSyncProcess() {
        this.resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());
        this.discSyncController = new DiscSyncController();
    }

    public DiscSyncController getDiscSyncController() {
        return this.discSyncController;
    }

    private boolean isCanceled() {
        return this.navigationCodeStep1 == 2 || this.navigationCodeStep2 == 2 || this.navigationCodeStep3 == 2;
    }

    void doDiscSyncProcess(HomeFrame frame) {
        do {
            switch (this.state) {
                case 0: {
                    this.doAddDialog(frame);
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.doTargetDialog(frame);
                    this.state = 2;
                    if (this.navigationCodeStep2 != 4) break;
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.doResultDialog(frame);
                    if (this.navigationCodeStep3 != 4) break;
                    this.state = 1;
                }
            }
        } while (!this.isCanceled() && this.navigationCodeStep3 != 5);
    }

    void doAddDialog(HomeFrame frame) {
        DiscSyncAddDialog discSyncAddDialog = new DiscSyncAddDialog((Frame)frame, this.resLang.getString("xtit.discsync.filetoclient"), "userActionInfo", this);
        frame.showDialog(discSyncAddDialog, false);
    }

    void doTargetDialog(HomeFrame frame) {
        DiscSyncTargetDialog discSyncTargetDialog = new DiscSyncTargetDialog((Frame)frame, this.resLang.getString("xtit.discsync.targetsize"), "userActionInfo", this);
        frame.showDialog(discSyncTargetDialog, false);
    }

    void doResultDialog(HomeFrame frame) {
        boolean isSyncSuccessfull = new SyncProtocol().hasToBeDisplayed();
        if (isSyncSuccessfull) {
            frame.createAndDisplayMsgBox("", 3, this.resLang.getString(xmsg_JSP_SYNC_SUCCESS));
        } else {
            frame.createAndDisplayMsgBox("", 1, this.resLang.getString(xmsg_discsync_syncfailed));
        }
        DiscSyncResultDialog discSyncResultDialog = new DiscSyncResultDialog((Frame)frame, this.resLang.getString("xtit.discSync.filestodisc"), "userActionInfo", this);
        frame.showDialog(discSyncResultDialog, false);
    }

    public void sendReturnValuesStep1(int navigationCode) {
        this.navigationCodeStep1 = navigationCode;
    }

    public void sendReturnValuesStep2(int navigationCode) {
        this.navigationCodeStep2 = navigationCode;
    }

    public void sendReturnValuesStep3(int navigationCode, Vector fileList) {
        this.navigationCodeStep3 = navigationCode;
        this.targetFileList = fileList;
    }
}

