/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.About;
import com.sap.ip.me.awtapps.home.DiscSyncProcess;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.sync.DiscSyncException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.io.File;
import java.util.Vector;

public class DiscSyncAddDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 280;
    public static final int TEXT_AREA_ROWS = 7;
    public static final int TEXT_AREA_COLS = 28;
    public static final int portTextFieldLength = 17;
    public static final String xfld_addSourceFile = "xfld.discsync.addSourceFil";
    public static final String xbut_browse = "xbut.discsync.browse";
    public static final String xbut_add = "xbut.discsync.add";
    public static final String xbut_clearList = "xbut.discsync.clearList";
    public static final String xbut_back = "xbut.discsync.back";
    public static final String xbut_next = "xbut.discsync.next";
    public static final String xmsg_discsync_askclearlist = "xmsg.discsync.askclearlist";
    private static About about = null;
    private Button cancel;
    private String text1 = "";
    private Panel northPanel;
    private Panel centerPanel;
    private Panel southPanel;
    private TextArea textArea;
    private TextField newSyncProcessField;
    private Button addButton;
    private Button browseButton;
    private Button clearButton;
    private Button backButton;
    private Button nextButton;
    private Vector fileList = new Vector();
    Frame parent;
    DiscSyncProcess discSyncProcess;
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public DiscSyncAddDialog(Frame p_parent, String name, String infMsg, DiscSyncProcess dsp) {
        super(p_parent, name, true);
        this.parent = p_parent;
        this.discSyncProcess = dsp;
        if (about == null) {
            about = new About();
        }
        this.text1 = this.resLang.getString(xfld_addSourceFile);
        this.containerPanel.setLayout(new BorderLayout());
        this.northPanel = new Panel();
        this.northPanel.setLayout(new GridLayout(2, 1));
        this.centerPanel = new Panel(new BorderLayout());
        this.southPanel = new Panel();
        this.containerPanel.add("North", this.northPanel);
        this.containerPanel.add("Center", this.centerPanel);
        Label localmeLabel = new Label(this.text1, 0);
        this.northPanel.add(localmeLabel);
        Panel northInputPanel = new Panel(new BorderLayout());
        this.northPanel.add(northInputPanel);
        this.newSyncProcessField = new TextField(17);
        northInputPanel.add("Center", this.newSyncProcessField);
        this.browseButton = new Button(this.resLang.getString(xbut_browse));
        northInputPanel.add("East", this.browseButton);
        this.addButton = new Button(this.resLang.getString(xbut_add));
        this.clearButton = new Button(this.resLang.getString(xbut_clearList));
        Panel flPanel = new Panel(new FlowLayout());
        flPanel.add(this.addButton);
        flPanel.add(this.clearButton);
        this.clearButton.setEnabled(false);
        Panel centerCenterPanel = new Panel();
        this.textArea = new TextArea(7, 28);
        this.textArea.setEditable(false);
        centerCenterPanel.add(this.textArea);
        centerCenterPanel.add(this.southPanel);
        this.centerPanel.add("North", flPanel);
        this.centerPanel.add("Center", centerCenterPanel);
        this.cancel = new Button(this.getCancelButtonText());
        this.southPanel.add(this.cancel);
        this.backButton = new Button(this.resLang.getString(xbut_back));
        this.backButton.setEnabled(false);
        this.southPanel.add(this.backButton);
        this.nextButton = new Button(this.resLang.getString(xbut_next));
        this.southPanel.add(this.nextButton);
        this.fillControls();
    }

    private boolean fileExists(String pathAndFilename) {
        File file = new File(pathAndFilename);
        return file.exists();
    }

    private String addFileToList(String sourceFile) {
        String s = null;
        try {
            s = this.discSyncProcess.getDiscSyncController().uploadFile(sourceFile);
        }
        catch (DiscSyncException discSyncExc) {
            this.showMessage(discSyncExc.getLocalizedMessage());
            s = null;
        }
        return s;
    }

    private void action_next() {
        try {
            this.discSyncProcess.getDiscSyncController().checkCompleteness();
            ((Component)this).setVisible(false);
            this.discSyncProcess.sendReturnValuesStep1(3);
        }
        catch (DiscSyncException discSyncExc) {
            this.showMessage(discSyncExc.getLocalizedMessage());
        }
    }

    private void fillControls() {
        String[] fileNames = this.discSyncProcess.getDiscSyncController().getConfiguration().getUploadedFiles();
        int i = 0;
        while (i < fileNames.length) {
            this.textArea.append(fileNames[i]);
            this.textArea.append("\n");
            ++i;
        }
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            Button localButton = (Button)evt.target;
            String sButton = localButton.getLabel();
            if (sButton.equals(this.resLang.getString(xbut_next))) {
                this.action_next();
                return false;
            }
            if (sButton.equals(this.getCancelButtonText())) {
                this.exitDialogEscape();
                return false;
            }
            if (sButton.equals(this.resLang.getString(xbut_clearList))) {
                if (this.showQMessage(this.resLang.getString(xmsg_discsync_askclearlist))) {
                    this.textArea.setText("");
                    this.fileList.removeAllElements();
                    this.discSyncProcess.getDiscSyncController().cleanUploadedFilesList();
                    this.nextButton.setEnabled(true);
                    this.clearButton.setEnabled(false);
                }
                return false;
            }
            if (sButton.equals(this.resLang.getString(xbut_add))) {
                String fileName = this.newSyncProcessField.getText();
                String syncFileName = this.addFileToList(fileName);
                if (syncFileName != null) {
                    this.textArea.append(syncFileName);
                    this.textArea.append("\n");
                    this.newSyncProcessField.setText("");
                    this.nextButton.setEnabled(this.discSyncProcess.getDiscSyncController().isDiscSyncSetComplete());
                    this.clearButton.setEnabled(true);
                }
                return false;
            }
            if (sButton.equals(this.resLang.getString(xbut_browse))) {
                FileDialog fd = new FileDialog(this.parent, "FileDialog");
                ((Component)fd).setVisible(true);
                String fileName = fd.getFile();
                String dir = fd.getDirectory();
                if (fileName != null && dir != null) {
                    String pathAndName = dir.concat(fileName);
                    this.newSyncProcessField.setText(pathAndName);
                }
                return false;
            }
        }
        return true;
    }

    protected void exitDialogEscape() {
        this.discSyncProcess.sendReturnValuesStep1(2);
        ((Component)this).setVisible(false);
    }

    protected void exitDialogOk() {
        this.action_next();
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 280;
    }
}

