/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.awtapps.home;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.awtapps.home.AWTDialog;
import com.sap.ip.me.awtapps.home.AWTScrollDialog;
import com.sap.ip.me.awtapps.home.HomeFrame;
import com.sap.ip.me.awtapps.home.InstallLogDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;

public class DeploymentInboxDialog
extends AWTScrollDialog {
    public static final int PREFERRED_WIDTH = 240;
    public static final int PREFERRED_HEIGHT = 300;
    public static final int BODY_AREA_ROWS = 8;
    private final String ACTION_OK = "ok";
    private final String ACTION_APP = "apps";
    Font mouseEnteredFont;
    Font mouseExitedFont;
    private ScrollPane scrollPanel = null;
    private boolean isExist = true;
    private Panel northPanel = new Panel();
    private Panel centerPanel = new Panel();
    private Panel southPanel = new Panel();
    private Button btnOk;
    private Font headerFont;
    private Button[] details;
    private Frame parent = null;
    private DeploymentInbox depInbox = DeploymentInbox.getInstance();
    private MEResourceBundle resLang = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine", HomeFrame.getAWTLocale(), this.getClass().getClassLoader());

    public DeploymentInboxDialog(Frame p_parent, String name, String infMsg) {
        super(p_parent, name, true);
        this.parent = p_parent;
        Vector isState = this.depInbox.getInstallScenarioStatus();
        Vector applications = null;
        int cols = 1;
        int rows = 1;
        if (isState == null) {
            this.isExist = false;
        } else {
            cols = 2;
            applications = this.depInbox.getAllAppStatus();
            rows = applications.size();
        }
        this.initLayout(rows, cols);
        this.setTitle();
        if (!this.isExist) {
            this.populateMessageNOIS();
        } else {
            this.setHeader();
            this.populateContents2(applications);
        }
        this.setFooter();
    }

    public int getPrefWidth() {
        return 240;
    }

    public int getPrefHeight() {
        return 300;
    }

    private void setFooter() {
        this.btnOk = new Button(this.resLang.getString("xbut_OK"));
        this.btnOk.setActionCommand("ok");
        this.southPanel.add(this.btnOk);
        this.btnOk.addActionListener(new ActionHandler());
    }

    private void setTitle() {
        String strTitle = this.isExist ? this.resLang.getString("xtit_DEPINBOX") + " - " + this.depInbox.getInstallationSequenceName() : this.resLang.getString("xtit_DEPINBOX");
        Label title = new Label(strTitle);
        title.setFont(this.headerFont);
        this.northPanel.add(title);
    }

    private void setHeader() {
        Label header1 = new Label(this.resLang.getString("xfld_APPNAME"));
        header1.setFont(this.headerFont);
        Label header2 = new Label(this.resLang.getString("xfld_APPSTATUS"));
        header2.setFont(this.headerFont);
        this.centerPanel.add(header1);
        this.centerPanel.add(header2);
    }

    private void initLayout(int rows, int cols) {
        this.setLayout(new BorderLayout());
        if (++rows < 8) {
            rows = 8;
        }
        GridLayout gridLayout = new GridLayout(rows, cols);
        this.centerPanel.setLayout(gridLayout);
        this.scrollPanel = new ScrollPane(0);
        this.scrollPanel.add(this.centerPanel);
        this.add("North", this.northPanel);
        this.add("Center", this.scrollPanel);
        this.add("South", this.southPanel);
        this.headerFont = new Font("Arial", 1, 12);
        Hashtable hashEntered = new Hashtable();
    }

    private void populateContents2(Vector applications) {
        int noOfRows = applications.size();
        Label[] apps = new Label[noOfRows];
        String appName = null;
        String appStatus = null;
        Vector application = null;
        int i = 0;
        while (i < noOfRows) {
            application = (Vector)applications.elementAt(i);
            appName = (String)application.elementAt(0);
            appStatus = (String)application.elementAt(1);
            apps[i] = new Label(appName);
            apps[i].setName("apps");
            apps[i].setFont(this.mouseExitedFont);
            apps[i].setForeground(new Color(255, 153, 0));
            apps[i].addMouseListener(new MouseHandler());
            this.centerPanel.add(apps[i]);
            this.centerPanel.add(new Label(this.resLang.getString("xmsg_DEP_STATUS_" + appStatus)));
            ++i;
        }
        int i2 = noOfRows + 1;
        while (i2 < 8) {
            this.centerPanel.add(new Label(" "));
            this.centerPanel.add(new Label(" "));
            ++i2;
        }
    }

    private void populateMessageNOIS() {
        Label noIS = new Label(this.resLang.getString("xmsg_NO_IS"));
        this.centerPanel.add(noIS);
    }

    private void performOkClicked() {
        ((Component)this).setVisible(false);
    }

    private void performMouseMoved(int mode) {
        if (mode == 0) {
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(12));
        }
    }

    private void performApplicationClicked(String appName) {
        InstallLogDialog installLog = new InstallLogDialog(this.parent, this.resLang.getString("xtit_INSTLOG") + " - " + appName, appName);
        this.showDialog(installLog, false);
    }

    private void showDialog(AWTDialog dialog, boolean resizeable) {
        ((Component)dialog).setSize(dialog.getPrefWidth(), dialog.getPrefHeight());
        Point p = HomeFrame.getCenteredWindowOrigin(dialog.getPrefWidth(), dialog.getPrefHeight());
        ((Component)dialog).setLocation(p.x, p.y);
        dialog.setResizable(resizeable);
        dialog.show();
        dialog.dispose();
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            Label srcLabel = null;
            String appName = null;
            if (src instanceof Label && (srcLabel = (Label)src).getName().equals("apps")) {
                appName = srcLabel.getText();
                Font currentFont = srcLabel.getFont();
                Font newFont = new Font(currentFont.getName(), 0, currentFont.getSize());
                srcLabel.setFont(newFont);
                DeploymentInboxDialog.this.performApplicationClicked(appName);
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            Object src = e.getSource();
            Label srcLabel = null;
            Object appName = null;
            if (src instanceof Label && (srcLabel = (Label)src).getName().equals("apps")) {
                Font currentFont = srcLabel.getFont();
                Font newFont = new Font(currentFont.getName(), 2, currentFont.getSize());
                srcLabel.setFont(newFont);
                DeploymentInboxDialog.this.performMouseMoved(1);
            }
        }

        public void mouseExited(MouseEvent e) {
            Object src = e.getSource();
            Label srcLabel = null;
            Object appName = null;
            if (src instanceof Label && (srcLabel = (Label)src).getName().equals("apps")) {
                Font currentFont = srcLabel.getFont();
                Font newFont = new Font(currentFont.getName(), 0, currentFont.getSize());
                srcLabel.setFont(newFont);
                DeploymentInboxDialog.this.performMouseMoved(0);
            }
        }
    }

    public class ActionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("ok")) {
                DeploymentInboxDialog.this.performOkClicked();
            } else {
                DeploymentInboxDialog.this.performApplicationClicked(actionCommand);
            }
        }
    }
}

