/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.core.InstallationLog;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class Trace {
    private static final String TRACE = "/trace/trace.jsp";
    private static final String TRACE_LIST = "/trace/list.jsp";
    public static final String EVENT_TRACE = "tracetrace";
    public static final String EVENT_TRACE_DISPLAY = "tracedisplay";
    public static final String EVENT_TRACE_TOOGLE = "tracetoogle";
    public static final String EVENT_TRACE_RESET = "tracereset";
    public static final String EVENT_TRACE_CHANGE_LEVEL = "tracechangeTraceLevel";
    public static final String EVENT_TRACE_SEND_TO_R3 = "tracesendToR3";
    public static final String EVENT_TRACE_SEND_PRINT_PERFORMANCE_LOG = "traceprintPerformanceLog";
    public static final String PORT = "PORT";
    public static final String TRACE_ON_OFF = "TRACE_ON_OFF";
    public static final String TRACE_ON_OFF_RADIO = "TRACE_ON_OFF_RADIO";
    public static final String TRACE_FILE_EXIST = "TRACE_FILE_EXIST";
    public static final String TRACE_FILE = "TRACE_FILE_LINE";
    public static final String TRACE_LEVEL = "TRACE_LEVEL";
    public static final String TRACE_SENT = "TRACE_SENT";
    public static final String TRACE_REFRESH = "TRACE_REFRESH";
    public static final String TRACE_LEVEL_LIST = "TRACE_LEVEL_LIST";
    private static final String[][] traceList = new String[][]{{Integer.toString(1000), "TRACELEVEL_0"}, {Integer.toString(10), "TRACELEVEL_10"}, {Integer.toString(50), "TRACELEVEL_50"}, {Integer.toString(60), "TRACELEVEL_60"}, {Integer.toString(70), "TRACELEVEL_70"}, {Integer.toString(80), "TRACELEVEL_80"}, {Integer.toString(90), "TRACELEVEL_90"}};
    public static final String URL_PATTERN = "/me/servlet/com.sap.ip.me.apps.jsp.ControllerServlet?action=";
    private final com.sap.ip.me.api.logging.Trace tr = com.sap.ip.me.api.logging.Trace.getInstance("MI");

    public String doTrace(HttpServletRequest request) {
        if (this.tr.isOn()) {
            request.getSession().setAttribute(TRACE_ON_OFF, (Object)"X");
        } else {
            request.getSession().setAttribute(TRACE_ON_OFF, (Object)" ");
        }
        request.getSession().setAttribute(PORT, (Object)this.getPort());
        request.getSession().setAttribute(TRACE_SENT, (Object)" ");
        request.getSession().setAttribute(TRACE_REFRESH, (Object)" ");
        request.getSession().setAttribute(TRACE_LEVEL, (Object)Integer.toString(this.tr.getEffectiveSeverity()));
        request.getSession().setAttribute(TRACE_LEVEL_LIST, (Object)traceList);
        return "/jsp/trace/trace.jsp";
    }

    private String getPort() {
        return Configuration.getInstance().getProperty("MobileEngine.Runtime.Port", "4444");
    }

    public String doTraceDisplayList(HttpServletRequest request) {
        request.getSession().setAttribute(PORT, (Object)this.getPort());
        request.getSession().setAttribute(TRACE_LEVEL, (Object)Integer.toString(this.tr.getEffectiveSeverity()));
        Vector traceLines = this.tr.read();
        request.getSession().removeAttribute(TRACE_FILE);
        if (traceLines == null) {
            request.getSession().setAttribute(TRACE_FILE_EXIST, (Object)" ");
        } else {
            request.getSession().setAttribute(TRACE_FILE_EXIST, (Object)"X");
            request.getSession().setAttribute(TRACE_FILE, traceLines.elements());
        }
        return "/jsp/trace/list.jsp";
    }

    public String doTraceReset(HttpServletRequest request) {
        this.tr.reset();
        request.getSession().setAttribute(PORT, (Object)this.getPort());
        request.getSession().setAttribute(TRACE_LEVEL, (Object)Integer.toString(this.tr.getEffectiveSeverity()));
        request.getSession().setAttribute(TRACE_SENT, (Object)" ");
        request.getSession().setAttribute(TRACE_REFRESH, (Object)"X");
        request.getSession().removeAttribute(TRACE_FILE);
        request.getSession().setAttribute(TRACE_ON_OFF, (Object)(this.tr.isOn() ? "X" : " "));
        return "/jsp/trace/trace.jsp";
    }

    public String doSetTraceSettings(HttpServletRequest request) {
        this.tr.setEffectiveSeverity(Integer.parseInt(request.getParameter(TRACE_LEVEL)));
        request.getSession().setAttribute(TRACE_LEVEL, (Object)Integer.toString(this.tr.getEffectiveSeverity()));
        request.getSession().setAttribute(TRACE_SENT, (Object)" ");
        request.getSession().setAttribute(TRACE_REFRESH, (Object)" ");
        if (request.getParameter(TRACE_ON_OFF_RADIO).equals("ON")) {
            this.tr.switchOn(true);
            request.getSession().setAttribute(TRACE_ON_OFF, (Object)"X");
        } else {
            this.tr.switchOn(false);
            request.getSession().setAttribute(TRACE_ON_OFF, (Object)" ");
        }
        return "/jsp/trace/trace.jsp";
    }

    public String doSendTraceToR3(HttpServletRequest request) {
        InstallationLog.sendLogToBackend();
        request.getSession().setAttribute(PORT, (Object)this.getPort());
        request.getSession().setAttribute(TRACE_SENT, (Object)"X");
        request.getSession().setAttribute(TRACE_REFRESH, (Object)" ");
        request.getSession().setAttribute(TRACE_LEVEL, (Object)Integer.toString(this.tr.getEffectiveSeverity()));
        return "/jsp/trace/trace.jsp";
    }

    public String doPrintPerformanceLog(HttpServletRequest request) {
        PerformanceLog.print();
        PerformanceLog.reset();
        return "/jsp/trace/trace.jsp";
    }
}

