/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.runtime.jsp.ParameterConverter;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UserManagerImpl;
import java.text.MessageFormat;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Settings {
    public static final String EVENT_SETTINGS = "settingssettings";
    public static final String EVENT_SETTINGS_UPDATE = "settingsupdate";
    public static final String EVENT_SETTINGS_CHECK_CHANGES = "settingscheckchanges";
    public static final String EVENT_SETTINGS_CHANGE_SYNC_PASSWORD = "settingschangesyncpassword";
    public static final String EVENT_SETTINGS_EXTENDED = "settingsextended";
    public static final String SYNC_PROXY = "SYNC_PROXY";
    public static final String SYNC_USER = "SYNC_USER";
    public static final String SYNC_PASSWORD = "SYNC_PASSWORD";
    public static final String SYNC_CLIENT = "SYNC_CLIENT";
    public static final String SYNC_LANGUAGE = "SYNC_LANGUAGE";
    public static final String SYNC_PROTOCOL = "SYNC_PROTOCOL";
    public static final String SYNC_HOST = "SYNC_HOST";
    public static final String SYNC_SYSTEM = "SYNC_SYSTEM";
    public static final String SYNC_PORT = "SYNC_PORT";
    public static final String CURRENT_LANGUAGE = "CURRENT_LANGUAGE";
    public static final String LANGUAGE_LIST = "LANGUAGE_LIST";
    public static final String PROXYHOST = "PROXYHOST";
    public static final String PROXYPORT = "PROXYPORT";
    public static final String DEPL_ID = "DEPL_ID";
    public static final String COUNTRY = "COUNTRY";
    public static final String CURRENT_COUNTRY_LONG = "COUNTRY_LONG";
    public static final String CURRENT_COUNTRY = "CURRENT_COUNTRY";
    public static final String COUNTRY_LIST = "COUNTRY_LIST";
    public static final String TIMEZONE = "TIMEZONE";
    public static final String CURRENT_TIMEZONE = "CURRENT_TIMEZONE";
    public static final String TIMEZONE_LIST = "TIMEZONE_LIST";
    public static final String DAYLIGHT_SAVING = "DAYLIGHT_SAVING";
    public static final String CONNECTIONQUALITY = "CONNECTIONQUALITY";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final String SPACE = " ";
    public static final String URL_PATTERN = "/me/servlet/com.sap.ip.me.apps.jsp.ControllerServlet?action=";
    private MEResourceBundle resource = null;
    private HttpServletRequest request;
    private ParameterConverter converter;
    private HttpSession session;

    public Settings(MEResourceBundle resource, ParameterConverter converter) {
        this.resource = resource;
        this.converter = converter;
        this.request = converter.getRequest();
        this.session = this.request.getSession();
    }

    public String doUpdateSettings() {
        Configuration config = Configuration.getInstance();
        boolean isRestartNecessary = false;
        this.request.setAttribute(SYNC_USER, (Object)this.converter.getParameter(SYNC_USER));
        String client = this.request.getParameter(SYNC_CLIENT);
        config.setDefaultProperty("MobileEngine.Sync.Client", client);
        this.request.setAttribute(SYNC_CLIENT, (Object)client);
        if (SyncPasswordHandlingOption.ONCE == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            this.request.setAttribute("SyncPasswordEntryField", (Object)"X");
            if (this.request.getParameter("SyncPasswordChangeButton") == null) {
                String syncPassword = this.converter.getParameter(SYNC_PASSWORD);
                UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
                if (syncPassword.length() > 0) {
                    try {
                        userManager.setSyncPasswordOfCurrentUser(syncPassword);
                        this.request.setAttribute("SyncPasswordChangeButton", (Object)"X");
                    }
                    catch (SyncPasswordException e) {
                        String message = null;
                        switch (e.getMessageId()) {
                            case 1: {
                                message = this.resource.getString("xmsg_EMPTY_SYNC_PASSWORD");
                                break;
                            }
                            case 2: {
                                message = e.getMessage();
                                break;
                            }
                            case 3: {
                                message = MessageFormat.format(this.resource.getString("xmsg_INVALID_SYNC_PASS_LEN"), e.getMessageParameters());
                                break;
                            }
                            case 0: {
                                message = e.getMessage();
                                break;
                            }
                            default: {
                                message = this.resource.getString("xmsg_UNKNOWN_ERROR");
                            }
                        }
                        this.request.setAttribute("MESSAGE", (Object)message);
                    }
                }
            } else if (this.request.getAttribute("ChangeSyncPasswordButtonPressed") == null) {
                this.request.setAttribute("SyncPasswordChangeButton", (Object)"X");
            }
        }
        String language = this.converter.getParameter(SYNC_LANGUAGE);
        String country = this.converter.getParameter(COUNTRY);
        if (!language.equals(Localization.getLanguage())) {
            Localization.setLanguage(language);
            this.request.getSession().setAttribute(COUNTRY_LIST, (Object)this.getAllCountries());
        }
        if (!country.equals(Localization.getCountry())) {
            Localization.setCountry(country);
        }
        this.request.setAttribute(CURRENT_LANGUAGE, (Object)language);
        this.request.setAttribute(CURRENT_COUNTRY, (Object)country);
        String timezone = this.converter.getParameter(TIMEZONE);
        Localization.setTimeZone(TimeZone.getTimeZone(timezone));
        this.request.setAttribute(CURRENT_TIMEZONE, (Object)TimeZone.getTimeZone(timezone));
        if (Localization.getTimeZone().useDaylightTime()) {
            this.session.setAttribute(DAYLIGHT_SAVING, (Object)"X");
        } else {
            this.session.setAttribute(DAYLIGHT_SAVING, (Object)"");
        }
        String protocol = this.request.getParameter(SYNC_PROTOCOL);
        config.setDefaultProperty("MobileEngine.Sync.Gateway.Protocol", protocol);
        this.request.setAttribute(SYNC_PROTOCOL, (Object)protocol);
        String host = this.request.getParameter(SYNC_HOST);
        config.setDefaultProperty("MobileEngine.Sync.Gateway.Host", host);
        this.request.setAttribute(SYNC_HOST, (Object)host);
        String port = this.request.getParameter(SYNC_PORT);
        config.setDefaultProperty("MobileEngine.Sync.Gateway.Port", port);
        this.request.setAttribute(SYNC_PORT, (Object)port);
        String system = this.request.getParameter(SYNC_SYSTEM);
        config.setDefaultProperty("MobileEngine.Sync.Gateway.System", system);
        this.request.setAttribute(SYNC_SYSTEM, (Object)system);
        config.setDefaultProperty("MobileEngine.Sync.Gateway", SyncSettings.getSyncGateway());
        String proxy = this.request.getParameter(SYNC_PROXY);
        boolean isProxyUsed = false;
        if ("X".equals(proxy)) {
            isProxyUsed = true;
        }
        if (isProxyUsed != config.getBoolean("MobileEngine.Sync.Proxyused", false)) {
            isRestartNecessary = true;
        }
        config.setDefaultProperty("MobileEngine.Sync.Proxyused", "" + isProxyUsed);
        this.request.setAttribute(SYNC_PROXY, (Object)proxy);
        String proxyHost = this.request.getParameter(PROXYHOST);
        if (!proxyHost.equals(config.getProperty("MobileEngine.Sync.Proxyhost")) && proxyHost != null && config.getProperty("MobileEngine.Sync.Proxyhost") != null) {
            isRestartNecessary = true;
        }
        config.setDefaultProperty("MobileEngine.Sync.Proxyhost", proxyHost);
        this.request.setAttribute(PROXYHOST, (Object)proxyHost);
        String proxyPort = this.request.getParameter(PROXYPORT);
        if (!proxyPort.equals(config.getProperty("MobileEngine.Sync.Proxyport")) && config.getProperty("MobileEngine.Sync.Proxyport") != null) {
            isRestartNecessary = true;
        }
        config.setDefaultProperty("MobileEngine.Sync.Proxyport", proxyPort);
        this.request.setAttribute(PROXYPORT, (Object)proxyPort);
        if (isRestartNecessary) {
            this.request.setAttribute("RESTARTREQUIRED", (Object)"RESTARTREQUIRED");
        }
        this.request.setAttribute(DEPL_ID, (Object)this.request.getParameter(DEPL_ID));
        return "/jsp/settings/settings.jsp";
    }

    public String doGetSettings() {
        Configuration config = Configuration.getInstance();
        this.request.setAttribute(SYNC_USER, (Object)UserManager.getInstance().getCurrentUser().getUniqueName());
        if (SyncPasswordHandlingOption.ONCE == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            this.request.setAttribute("SyncPasswordEntryField", (Object)"X");
            if (UserManagerImpl.getUserManagerImplInstance().isSyncCredentialAvailable()) {
                this.request.setAttribute("SyncPasswordChangeButton", (Object)"X");
            }
        }
        this.request.setAttribute(SYNC_CLIENT, (Object)config.getProperty("MobileEngine.Sync.Client"));
        this.session.setAttribute(LANGUAGE_LIST, (Object)Localization.getAllLanguages());
        this.request.setAttribute(CURRENT_LANGUAGE, (Object)Localization.getLanguage());
        this.session.setAttribute(COUNTRY_LIST, (Object)this.getAllCountries());
        this.request.setAttribute(CURRENT_COUNTRY, (Object)Localization.getCountry());
        this.session.setAttribute(TIMEZONE_LIST, (Object)Localization.getAllTimezones());
        this.request.setAttribute(CURRENT_TIMEZONE, (Object)Localization.getTimeZone());
        if (Localization.getTimeZone().useDaylightTime()) {
            this.session.setAttribute(DAYLIGHT_SAVING, (Object)"X");
        } else {
            this.session.setAttribute(DAYLIGHT_SAVING, (Object)"");
        }
        this.request.setAttribute(SYNC_PROTOCOL, (Object)config.getProperty("MobileEngine.Sync.Gateway.Protocol"));
        this.request.setAttribute(SYNC_HOST, (Object)config.getProperty("MobileEngine.Sync.Gateway.Host"));
        this.request.setAttribute(SYNC_PORT, (Object)config.getProperty("MobileEngine.Sync.Gateway.Port"));
        this.request.setAttribute(SYNC_SYSTEM, (Object)config.getProperty("MobileEngine.Sync.Gateway.System"));
        if (config.getBoolean("MobileEngine.Sync.Proxyused", false)) {
            this.request.setAttribute(SYNC_PROXY, (Object)"X");
        }
        this.request.setAttribute(PROXYHOST, (Object)config.getProperty("MobileEngine.Sync.Proxyhost", ""));
        this.request.setAttribute(PROXYPORT, (Object)config.getProperty("MobileEngine.Sync.Proxyport", ""));
        this.request.setAttribute(DEPL_ID, (Object)ConversationIdHandler.getDeviceId());
        return "/jsp/settings/settings.jsp";
    }

    public String doChangeSyncPassword() {
        this.request.setAttribute("ChangeSyncPasswordButtonPressed", (Object)"X");
        UserManagerImpl.getUserManagerImplInstance().removeSyncPasswordOfCurrentUser();
        return this.doUpdateSettings();
    }

    private Vector getAllCountries() {
        return Localization.getAllCountriesSorted();
    }
}

