/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.runtime.jsp.ParameterConverter;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.apps.jsp.Home;
import com.sap.ip.me.core.ChangePasswordException;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import com.sap.ip.me.core.UserManagerImpl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ManagePasswords {
    public static final String CHANGE_PASSWORD_FROM_LOGIN = "managePasswordsChangePasswordFromLogin";
    public static final String CHANGE_PASSWORD_FROM_HOME = "managePasswordsChangePasswordFromHome";
    public static final String CHANGE_LOCAL_PASSWORD = "managePasswordsChangeLocalPassword";
    public static final String CHANGE_SYNC_PASSWORD = "managePasswordsChangeSyncPassword";
    public static final String MANAGE_PASSWORDS = "managePasswordsManagePasswords";
    private static final String SAVE = "managePasswordsSave";
    private MEResourceBundle resource;
    private HttpServletRequest request;
    private ParameterConverter converter;
    private HttpSession session;

    public ManagePasswords(MEResourceBundle resource, ParameterConverter converter) {
        this.resource = resource;
        this.converter = converter;
        this.request = converter.getRequest();
        this.session = this.request.getSession();
    }

    public String performAction(String event) {
        String state = this.request.getParameter("STATE");
        if (state == null) {
            return this.displayInitialScreen(event);
        }
        if (CHANGE_PASSWORD_FROM_LOGIN.equals(state)) {
            return this.changePassword(event, false);
        }
        if (CHANGE_PASSWORD_FROM_HOME.equals(state)) {
            return this.changePassword(event, true);
        }
        if (CHANGE_LOCAL_PASSWORD.equals(state)) {
            return this.changeLocalPassword(event);
        }
        if (MANAGE_PASSWORDS.equals(state)) {
            return this.managePasswords(event);
        }
        if (CHANGE_SYNC_PASSWORD.equals(state)) {
            return this.changeSyncPassword(event);
        }
        return null;
    }

    private String displayInitialScreen(String event) {
        if (CHANGE_PASSWORD_FROM_LOGIN.equals(event)) {
            this.request.setAttribute("STATE", (Object)CHANGE_PASSWORD_FROM_LOGIN);
            this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_CHANGE_PASSWORD"));
            this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.FALSE);
            this.request.setAttribute("IS_ALSO_WEB_AS_PASSWORD_CHANGE", (Object)"X");
        } else if (CHANGE_PASSWORD_FROM_HOME.equals(event)) {
            this.request.setAttribute("STATE", (Object)CHANGE_PASSWORD_FROM_HOME);
            this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_CHANGE_PASSWORD"));
            this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.TRUE);
            this.request.setAttribute("IS_ALSO_WEB_AS_PASSWORD_CHANGE", (Object)"X");
        } else if (CHANGE_LOCAL_PASSWORD.equals(event)) {
            this.request.setAttribute("STATE", (Object)CHANGE_LOCAL_PASSWORD);
            this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_CHANGE_LOC_PASSWORD"));
            this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.FALSE);
        } else if (MANAGE_PASSWORDS.equals(event)) {
            this.request.setAttribute("STATE", (Object)MANAGE_PASSWORDS);
            this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_MANAGE_PASSWORDS"));
            this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.TRUE);
        } else if (CHANGE_SYNC_PASSWORD.equals(event)) {
            this.request.setAttribute("STATE", (Object)CHANGE_SYNC_PASSWORD);
            this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_CHANGE_SYNC_PASSWORD"));
            this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.TRUE);
            this.request.setAttribute("IS_DO_SYNC", (Object)"X");
        } else {
            throw new IllegalStateException("Illegal UI flow detected. This is an MI internal error.");
        }
        return "/jsp/home/managepasswords.jsp";
    }

    private String changePassword(String event, boolean isFromHome) {
        if (SAVE.equals(event)) {
            String oldPassword = this.converter.getParameter("OLD_PASSWORD");
            String newPassword = this.converter.getParameter("NEW_PASSWORD");
            String newPasswordConfirmation = this.converter.getParameter("NEW_PASSWORD_CONFIRMATION");
            String passwordChangeOnServer = this.converter.getParameter("IS_ALSO_WEB_AS_PASSWORD_CHANGE");
            boolean isChangeOnServerRequest = true;
            if (!"X".equals(passwordChangeOnServer)) {
                isChangeOnServerRequest = false;
            }
            try {
                UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
                if (isChangeOnServerRequest) {
                    userManager.changeSyncPassword(oldPassword, newPassword, newPasswordConfirmation);
                } else {
                    userManager.changeLocalPassword(oldPassword, newPassword, newPasswordConfirmation);
                }
                return new Home(this.resource, this.converter).doHome();
            }
            catch (ChangePasswordException e) {
                this.request.setAttribute("ERROR_MESSAGE_1", (Object)e.getLocalizedMessage());
                this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_CHANGE_PASSWORD"));
                if (isFromHome) {
                    this.request.setAttribute("STATE", (Object)CHANGE_PASSWORD_FROM_HOME);
                    this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.TRUE);
                } else {
                    this.request.setAttribute("STATE", (Object)CHANGE_PASSWORD_FROM_LOGIN);
                    this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.FALSE);
                }
                return "/jsp/home/managepasswords.jsp";
            }
        }
        return new Home(this.resource, this.converter).doHome();
    }

    private String changeLocalPassword(String event) {
        if (SAVE.equals(event)) {
            String oldPassword = this.converter.getParameter("OLD_LOCAL_PASSWORD");
            String newPassword = this.converter.getParameter("NEW_LOCAL_PASSWORD");
            String newPasswordConfirmation = this.converter.getParameter("NEW_LOCAL_PASSWORD_CONFIRMATION");
            try {
                UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
                userManager.changeLocalPassword(oldPassword, newPassword, newPasswordConfirmation);
                return new Home(this.resource, this.converter).doHome();
            }
            catch (ChangePasswordException e) {
                this.request.setAttribute("ERROR_MESSAGE_1", (Object)e.getLocalizedMessage());
                this.request.setAttribute("STATE", (Object)CHANGE_LOCAL_PASSWORD);
                this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_CHANGE_LOC_PASSWORD"));
                this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.FALSE);
                return "/jsp/home/managepasswords.jsp";
            }
        }
        return new Home(this.resource, this.converter).doHome();
    }

    private String managePasswords(String event) {
        if (SAVE.equals(event)) {
            String newPasswordConfirmation;
            String newPassword;
            String oldPassword;
            String localPasswordChange = this.converter.getParameter("IS_LOCAL_PASSWORD_CHANGE");
            String syncPasswordChange = this.converter.getParameter("IS_SYNC_PASSWORD_CHANGE");
            boolean isLocalPasswordChange = false;
            if ("X".equals(localPasswordChange)) {
                isLocalPasswordChange = true;
            }
            boolean isSyncPasswordChange = false;
            if ("X".equals(syncPasswordChange)) {
                isSyncPasswordChange = true;
            }
            UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
            if (isLocalPasswordChange) {
                try {
                    oldPassword = this.converter.getParameter("OLD_LOCAL_PASSWORD");
                    newPassword = this.converter.getParameter("NEW_LOCAL_PASSWORD");
                    newPasswordConfirmation = this.converter.getParameter("NEW_LOCAL_PASSWORD_CONFIRMATION");
                    userManager.changeLocalPassword(oldPassword, newPassword, newPasswordConfirmation);
                    this.request.setAttribute("INFO_MESSAGE_1", (Object)this.resource.getString("xmsg_SUCC_LOC_PASS_CHANGE"));
                    this.request.removeAttribute("IS_LOCAL_PASSWORD_CHANGE");
                }
                catch (ChangePasswordException e) {
                    this.request.setAttribute("ERROR_MESSAGE_1", (Object)e.getLocalizedMessage());
                }
            }
            if (isSyncPasswordChange) {
                try {
                    oldPassword = this.converter.getParameter("OLD_SYNC_PASSWORD");
                    newPassword = this.converter.getParameter("NEW_SYNC_PASSWORD");
                    newPasswordConfirmation = this.converter.getParameter("NEW_SYNC_PASSWORD_CONFIRMATION");
                    userManager.changeSyncPassword(oldPassword, newPassword, newPasswordConfirmation);
                    this.request.setAttribute("INFO_MESSAGE_2", (Object)this.resource.getString("xmsg_SUCC_SYNC_PASS_CHANGE"));
                    this.request.removeAttribute("IS_SYNC_PASSWORD_CHANGE");
                }
                catch (ChangePasswordException e) {
                    this.request.setAttribute("ERROR_MESSAGE_2", (Object)e.getLocalizedMessage());
                }
            }
            this.request.setAttribute("STATE", (Object)MANAGE_PASSWORDS);
            this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_MANAGE_PASSWORDS"));
            this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.TRUE);
            return "/jsp/home/managepasswords.jsp";
        }
        return new Home(this.resource, this.converter).doHome();
    }

    private String changeSyncPassword(String event) {
        if (SAVE.equals(event)) {
            String oldPassword = this.converter.getParameter("OLD_SYNC_PASSWORD");
            String newPassword = this.converter.getParameter("NEW_SYNC_PASSWORD");
            String newPasswordConfirmation = this.converter.getParameter("NEW_SYNC_PASSWORD_CONFIRMATION");
            try {
                UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
                userManager.changeSyncPassword(oldPassword, newPassword, newPasswordConfirmation);
                if (SyncPasswordHandlingOption.AT_SYNC == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
                    try {
                        userManager.setSyncPasswordOfCurrentUser(newPassword);
                    }
                    catch (SyncPasswordException e) {
                        throw new IllegalStateException("MI internal error occurred during the setting of the synchronization password.");
                    }
                }
                return new Home(this.resource, this.converter).doAction("homesync", this.request);
            }
            catch (ChangePasswordException e) {
                this.request.setAttribute("ERROR_MESSAGE_1", (Object)e.getLocalizedMessage());
                this.request.setAttribute("STATE", (Object)CHANGE_SYNC_PASSWORD);
                this.request.setAttribute("TITLE", (Object)this.resource.getString("xtit_CHANGE_SYNC_PASSWORD"));
                this.request.setAttribute("IS_BACK_LINK_VISIBLE", (Object)Boolean.TRUE);
                this.request.setAttribute("IS_DO_SYNC", (Object)"X");
                return "/jsp/home/managepasswords.jsp";
            }
        }
        return "/jsp/home/syncpassword.jsp";
    }
}

