/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import com.sap.ip.me.api.runtime.jsp.ParameterConverter;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.api.user.LogonException;
import com.sap.ip.me.apps.jsp.Home;
import com.sap.ip.me.apps.jsp.ManagePasswords;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginServlet
extends AbstractMEHttpServlet {
    public static final String CURRENT_LANGUAGE = "currentLanguage";
    public static final String LANGUAGE_LIST = "languageList";
    public static final String EVENT_LANGUAGE = "changeLanguage";
    public static final String LANGUAGE = "language";
    private static final String EVENT_LOGIN = "login";
    private static final String EVENT_LOGOUT = "logout";
    private static final String EVENT_CHANGE_PASSWORD = "changepw";
    private static final String EVENT_CONFIRM_NEW_USER = "confirmnewuser";
    private static final String EVENT_ADD_NEW_USER = "adduser";
    private static final String EVENT_CANCEL = "cancel";
    private static final String MYSAPSSO2_COOKIE_NAME = "MYSAPSSO2";
    private static final String EMPTY_STRING = "";
    private static final UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();

    public void doInitialize() {
        this.setResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine");
        this.cleanUpInstallationFiles();
    }

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String nextURL;
        block64: {
            HttpSession session = request.getSession();
            nextURL = null;
            Configuration.getInstance().setDefaultProperty("MobileEngine.Runtime.Application.StartAutomatically", "CONFIGEXAMPLEJSP");
            ParameterConverter converter = new ParameterConverter(request);
            try {
                converter.setCharacterEncoding("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                AppLog.getInstance("MI/FrameworkApplications").logException(50, "Error while setting 'UTF8' encoding; check installed Java VM.", e, true);
            }
            Configuration config = Configuration.getInstance();
            if (eventName.equals(EMPTY_STRING)) {
                if (UserManagerImpl.getUserManagerImplInstance().getCurrentUser() != null) {
                    nextURL = new Home(this.getResourceBundle(), converter).doHome();
                } else if (config.getBoolean("MobileEngine.UM.SingleUserMode", false) && config.getBoolean("MobileEngine.UM.SAPLogonTicketSupport", false)) {
                    try {
                        userManager.logOnSingleUser();
                        String ticket = this.getSSOTicket(request);
                        if (ticket != null) {
                            UserManagerImpl.getUserManagerImplInstance().setSSOTicket(ticket);
                        }
                        nextURL = new Home(this.getResourceBundle(), converter).doHome();
                    }
                    catch (LogonException e) {
                        String ticket = this.getSSOTicket(request);
                        if (ticket != null) {
                            try {
                                userManager.logOnUserViaSSOTicket(ticket);
                                nextURL = new Home(this.getResourceBundle(), converter).doHome();
                            }
                            catch (LogonException ex) {
                                Trace.getInstance("MI/FrameworkApplications").logException(50, (Throwable)ex, true);
                                session.setAttribute("MobileEngine.SSO.Message", (Object)ex.getLocalizedMessage());
                                nextURL = "/jsp/sso/SSOFailure.jsp";
                            }
                            break block64;
                        }
                        nextURL = "/jsp/sso/ticketRequest.jsp";
                    }
                } else if (!config.getBoolean("MobileEngine.UM.SingleUserMode", false) && config.getBoolean("MobileEngine.UM.SAPLogonTicketSupport", false)) {
                    String ticket = this.getSSOTicket(request);
                    if (ticket != null) {
                        try {
                            userManager.logOnUserViaSSOTicket(ticket);
                            nextURL = new Home(this.getResourceBundle(), converter).doHome();
                        }
                        catch (LogonException e) {
                            Trace trace = Trace.getInstance("MI/FrameworkApplications");
                            if (trace.isLogging(90)) {
                                trace.logException(50, (Throwable)e, true);
                            }
                            request.setAttribute("MESSAGE", (Object)e.getLocalizedMessage());
                            session.setAttribute(CURRENT_LANGUAGE, (Object)Localization.getLanguage());
                            session.setAttribute(LANGUAGE_LIST, (Object)Localization.getAllLanguages());
                            request.setAttribute("TITLE", (Object)"xtit_LOGIN");
                            nextURL = "/jsp/login/login.jsp";
                        }
                    } else {
                        session.setAttribute(CURRENT_LANGUAGE, (Object)Localization.getLanguage());
                        session.setAttribute(LANGUAGE_LIST, (Object)Localization.getAllLanguages());
                        request.setAttribute("TITLE", (Object)"xtit_LOGIN");
                        nextURL = "/jsp/login/login.jsp";
                    }
                } else {
                    session.setAttribute(CURRENT_LANGUAGE, (Object)Localization.getLanguage());
                    session.setAttribute(LANGUAGE_LIST, (Object)Localization.getAllLanguages());
                    request.setAttribute("TITLE", (Object)"xtit_LOGIN");
                    nextURL = "/jsp/login/login.jsp";
                }
            } else if (eventName.equalsIgnoreCase("ticketRequestAtSync")) {
                nextURL = "/jsp/sso/ticketRequest.jsp";
            } else if (eventName.equalsIgnoreCase("ticketRequestTimeout")) {
                String s = config.getProperty("MobileEngine.Core.MissingTicketAtSync");
                if (s != null && s.length() > 0) {
                    config.setTemporary("MobileEngine.Core.ticketRequestTimeout", "X");
                    request.setAttribute("MobileEngine.Core.MissingTicketAtSync", (Object)config.getProperty("MobileEngine.Core.MissingTicketAtSync"));
                    nextURL = "/jsp/sso/continueSync.jsp";
                } else {
                    session.setAttribute("MobileEngine.SSO.Message", (Object)this.getResourceBundle().getString("xmsg_TICKET_REQ_TIMEOUT"));
                    nextURL = "/jsp/sso/SSOFailure.jsp";
                }
            } else if (eventName.equalsIgnoreCase("ticketWaitingRefresh")) {
                Trace trace = Trace.getInstance("MI/FrameworkApplications");
                String ticket = this.getSSOTicket(request);
                Cookie[] cookies = request.getCookies();
                boolean sessionIdCookieFound = false;
                if (cookies != null) {
                    int i = 0;
                    while (i < cookies.length) {
                        if ("JSESSIONID".equalsIgnoreCase(cookies[i].getName()) && session.getId().equals(cookies[i].getValue())) {
                            sessionIdCookieFound = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!sessionIdCookieFound) {
                    Cookie c = new Cookie("JSESSIONID", session.getId());
                    String contextPath = request.getContextPath();
                    if (contextPath != null && contextPath.length() > 0) {
                        c.setPath(contextPath);
                    } else {
                        c.setPath("/");
                    }
                    c.setMaxAge(-1);
                    c.setVersion(1);
                    response.addCookie(c);
                    if (trace.isLogging(90)) {
                        trace.log(90, "Session ID (" + session.getId() + ") Cookie added.");
                    }
                }
                boolean isLogoffPerforming = config.getBoolean("MobileEngine.core.performLogoff", false);
                if (ticket != null && !isLogoffPerforming) {
                    String logoffURL = config.getProperty("MobileEngine.UM.SAPLogonTicketLogoffURL");
                    if (logoffURL != null && logoffURL.length() > 0) {
                        config.setTemporary("MobileEngine.core.performLogoff", "true");
                        config.setTemporary("MobileEngine.Core.MYSAPSSO2", ticket);
                        request.setAttribute("MobileEngine.UM.SAPLogonTicketLogoffURL", (Object)logoffURL);
                    } else {
                        this.performSSOAction(request, ticket);
                    }
                } else if (ticket == null && isLogoffPerforming) {
                    this.performSSOAction(request, config.getProperty("MobileEngine.Core.MYSAPSSO2"));
                    config.setTemporary("MobileEngine.Core.MYSAPSSO2", EMPTY_STRING);
                } else {
                    StringBuffer b = new StringBuffer(156);
                    b.append("http://").append(config.getProperty("MobileEngine.Runtime.Host"));
                    b.append(':').append(config.getProperty("MobileEngine.Runtime.Port"));
                    b.append("/me/servlet/com.sap.ip.me.apps.jsp.LoginServlet;jsessionid=" + session.getId() + "?event=ticketWaitingRefresh");
                    request.setAttribute("MobileEngine.UM.SAPLogonTicketRefreshPage", (Object)b.toString());
                }
                nextURL = "/jsp/sso/waitingForTicket.jsp";
            } else if (eventName.equalsIgnoreCase(EVENT_LOGIN)) {
                String username = converter.getParameter("USER");
                String password = converter.getParameter("LOCAL_PASSWORD");
                String syncPassword = converter.getParameter("SYNC_PASSWORD");
                try {
                    userManager.logOnUser(username, password);
                    this.setSyncPassword(syncPassword);
                    this.checkLanguage(converter);
                    nextURL = new Home(this.getResourceBundle(), converter).doHome();
                }
                catch (LogonException e) {
                    request.setAttribute("TITLE", (Object)"xtit_LOGIN");
                    request.setAttribute("MESSAGE", (Object)e.getLocalizedMessage());
                    nextURL = "/jsp/login/login.jsp";
                }
            } else if (eventName.equalsIgnoreCase(EVENT_CHANGE_PASSWORD)) {
                String username = converter.getParameter("USER");
                String password = converter.getParameter("LOCAL_PASSWORD");
                String syncPassword = converter.getParameter("SYNC_PASSWORD");
                try {
                    userManager.logOnUser(username, password);
                    this.setSyncPassword(syncPassword);
                    this.checkLanguage(converter);
                    if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
                        nextURL = new ManagePasswords(this.getResourceBundle(), converter).performAction("managePasswordsChangePasswordFromLogin");
                        break block64;
                    }
                    nextURL = new ManagePasswords(this.getResourceBundle(), converter).performAction("managePasswordsChangeLocalPassword");
                }
                catch (LogonException e) {
                    request.setAttribute("TITLE", (Object)"xtit_LOGIN");
                    request.setAttribute("MESSAGE", (Object)e.getLocalizedMessage());
                    nextURL = "/jsp/login/login.jsp";
                }
            } else if (eventName.equalsIgnoreCase(EVENT_ADD_NEW_USER)) {
                request.setAttribute("ADDNEWUSER", (Object)"X");
                request.setAttribute("TITLE", (Object)"xtit_CREATE_USER");
                nextURL = "/jsp/login/login.jsp";
            } else if (eventName.equalsIgnoreCase(EVENT_CONFIRM_NEW_USER)) {
                String username = converter.getParameter("USER");
                String password = converter.getParameter("LOCAL_PASSWORD");
                String passwordConfirmation = converter.getParameter("LOCAL_PASSWORD_CONFIRMATION");
                try {
                    userManager.addNewUser(username, password, passwordConfirmation);
                    userManager.logOnUser(username, password);
                    this.checkLanguage(converter);
                    nextURL = new Home(this.getResourceBundle(), converter).doHome();
                }
                catch (LogonException e) {
                    request.setAttribute("MESSAGE", (Object)e.getLocalizedMessage());
                    request.setAttribute("ADDNEWUSER", (Object)"X");
                    request.setAttribute("TITLE", (Object)"xtit_CREATE_USER");
                    nextURL = "/jsp/login/login.jsp";
                }
            } else if (eventName.equalsIgnoreCase(EVENT_CANCEL)) {
                request.setAttribute("TITLE", (Object)"xtit_LOGIN");
                nextURL = "/jsp/login/login.jsp";
            } else if (eventName.equalsIgnoreCase(EVENT_LOGOUT)) {
                userManager.logOutCurrentUser();
                session.invalidate();
                if (config.getBoolean("MobileEngine.UI.CloseBrowserWindowSupport", false)) {
                    nextURL = "/jsp/sso/logout.jsp";
                } else if (!config.getBoolean("MobileEngine.UM.SingleUserMode", false) && config.getBoolean("MobileEngine.UM.SAPLogonTicketSupport", false)) {
                    nextURL = "/jsp/sso/logout.jsp";
                } else {
                    session = request.getSession(true);
                    this.setResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine");
                    request.setAttribute("TITLE", (Object)"xtit_LOGIN");
                    session.setAttribute(CURRENT_LANGUAGE, (Object)Localization.getLanguage());
                    session.setAttribute(LANGUAGE_LIST, (Object)Localization.getAllLanguages());
                    nextURL = "/jsp/login/login.jsp";
                }
            }
        }
        return nextURL;
    }

    public String getApplicationName() {
        return ApplicationManager.getInstance().getFrameworkName();
    }

    private void checkLanguage(ParameterConverter converter) {
        String language = converter.getParameter(LANGUAGE);
        if (language == null) {
            language = Localization.getLanguage() != null ? Localization.getLanguage() : "en";
        }
        if (!language.equalsIgnoreCase(Localization.getLanguage())) {
            Localization.setLanguage(language);
            this.setResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine");
        }
    }

    private void cleanUpInstallationFiles() {
        String tomcathome = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
        String webappsfolder = tomcathome + File.separator + "webapps";
        String[] dirEntries = new File(webappsfolder).list();
        int i = 0;
        while (i < dirEntries.length) {
            File f = new File(webappsfolder, dirEntries[i]);
            if (!f.isDirectory() && f.isFile()) {
                String dirName = f.getName().substring(0, f.getName().lastIndexOf("."));
                File directory = new File(webappsfolder + File.separator + dirName);
                if (directory.exists()) {
                    f.delete();
                }
            }
            ++i;
        }
    }

    private void setSyncPassword(String syncPassword) {
        try {
            if (syncPassword != null && syncPassword.length() > 0) {
                userManager.setSyncPasswordOfCurrentUser(syncPassword);
            }
        }
        catch (SyncPasswordException e) {
            throw new IllegalStateException("To set the synchronization password failed: " + e.getMessage());
        }
    }

    private void performSSOAction(HttpServletRequest request, String ticket) {
        String nextURL = Configuration.getInstance().getProperty("MobileEngine.Core.MissingTicketAtSync");
        if (nextURL != null && nextURL.length() > 0) {
            userManager.setSSOTicket(ticket);
            request.setAttribute("MobileEngine.UM.SAPLogonTicketAvailable", (Object)"X");
            request.setAttribute("MobileEngine.UM.SAPLogonTicketRefreshPage", (Object)nextURL);
        } else {
            try {
                userManager.logOnUserViaSSOTicket(ticket);
                request.setAttribute("MobileEngine.UM.SAPLogonTicketAvailable", (Object)"X");
                request.setAttribute("MobileEngine.UM.SAPLogonTicketRefreshPage", (Object)"/me/servlet/com.sap.ip.me.apps.jsp.LoginServlet");
            }
            catch (LogonException e) {
                Trace trace = Trace.getInstance("MI/FrameworkApplications");
                if (trace.isLogging(90)) {
                    trace.logException(50, (Throwable)e, true);
                }
                request.getSession().setAttribute("MobileEngine.SSO.Message", (Object)e.getMessage());
                request.setAttribute("MobileEngine.UM.SAPLogonTicketAvailable", (Object)"X");
                request.setAttribute("MobileEngine.UM.SAPLogonTicketRefreshPage", (Object)"/me/jsp/sso/SSOFailure.jsp");
            }
        }
    }

    private String getSSOTicket(HttpServletRequest request) {
        String ticket;
        Cookie[] cookies = request.getCookies();
        Cookie mySAPSSO2Cookie = null;
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (MYSAPSSO2_COOKIE_NAME.equals(cookies[i].getName())) {
                    mySAPSSO2Cookie = cookies[i];
                    break;
                }
                ++i;
            }
        }
        if (mySAPSSO2Cookie != null && (ticket = mySAPSSO2Cookie.getValue()) != null && ticket.length() > 0) {
            return ticket;
        }
        return null;
    }
}

