/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.runtime.jsp.ParameterConverter;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.apps.SyncProtocol;
import com.sap.ip.me.apps.jsp.InstallationPackage;
import com.sap.ip.me.apps.jsp.SyncStatus;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.ServerExceptionMessage;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import com.sap.ip.me.sync.SyncLogImpl;
import com.sap.ip.me.sync.SyncManagerImpl;
import com.sapmarkets.web.liTS.util.reg.WafRegistry;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Home {
    public static final String IS_DISC_SYNC_ENABLED = "IS_DISC_SYNC_ENABLED";
    public static final String PORT = "PORT";
    public static final String EVENT_HOME = "homehome";
    public static final String EVENT_HOME_ABOUT = "homeabout";
    public static final String EVENT_HOME_SYNC = "homesync";
    public static final String EVENT_HOME_REFRESH = "homerefresh";
    public static final String EVENT_HOME_SYNC_LOG = "homesynclog";
    public static final String ON_APPLICATION_CHOICE = "homeonApplicationChoice";
    public static final String INSTALLED_APPS_LIST = "INSTALLED_APPS_LIST";
    public static final String USER_NAME = "USER_NAME";
    public static final String SYNC_LOG = "synclog";
    public static final String DEPLOYMENT_LOG = "deploymentlog";
    public static final String LIST_OF_APPS = "LIST_OF_APPS";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String APPLICATION_TYPE = "applicationType";
    public static final String APPLICATION_VERSION = "applicationVersion";
    public static final String APPLICATION_NAMESPACE = "applicationNamespace";
    public static final String URL_PATTERN = "/me/servlet/com.sap.ip.me.apps.jsp.ControllerServlet?action=";
    private static final String LOGIN = "login";
    public static String SYNCSUCCESSFULL = "SYNCSUCCESSFULL";
    public static String REFRESH = "REFRESH";
    public static String LANGUAGE_NOT_SUPPORTED = "LANGUAGENOTSUPPORTED";
    private static String CLIENT_INSTALLER_QUESTION = "CLINST_QUESTION";
    private MEResourceBundle resource = null;
    private HttpServletRequest request;
    private ParameterConverter converter;
    private HttpSession session;
    private static transient boolean alreadyRefreshed = false;

    public Home(MEResourceBundle resource, ParameterConverter converter) {
        this.resource = resource;
        this.converter = converter;
        this.request = converter.getRequest();
        this.session = this.request.getSession();
    }

    protected String doAction(String action, HttpServletRequest request) {
        this.request = request;
        String nextURL = "";
        if (action.equals(EVENT_HOME)) {
            nextURL = this.doHome();
        } else if (action.equals(LOGIN)) {
            nextURL = this.doHome();
        } else if (action.equals(EVENT_HOME_ABOUT)) {
            nextURL = this.doEventAbout();
        } else if (action.equals(EVENT_HOME_SYNC)) {
            nextURL = this.doEventSync();
        } else if (action.equals(EVENT_HOME_REFRESH)) {
            nextURL = this.doEventRefresh();
        } else if (action.equals(EVENT_HOME_SYNC_LOG)) {
            nextURL = this.doEventSyncLog();
        }
        request.setAttribute(IS_DISC_SYNC_ENABLED, (Object)new Boolean(SyncManagerImpl.isDiscSyncEnabled()));
        return nextURL;
    }

    protected String doHome() {
        Boolean isQuestionToBeDisplayed;
        if (InstallationPackage.isInstallationPackageAvailable() && ((isQuestionToBeDisplayed = (Boolean)this.session.getAttribute(CLIENT_INSTALLER_QUESTION)) == null || isQuestionToBeDisplayed.booleanValue())) {
            this.session.setAttribute(CLIENT_INSTALLER_QUESTION, (Object)new Boolean(false));
            InstallationPackage ip = new InstallationPackage();
            return ip.showQuestion();
        }
        String userName = this.getUserName();
        this.session.removeAttribute(SYNCSUCCESSFULL);
        this.session.setAttribute(USER_NAME, (Object)userName);
        this.request.setAttribute(IS_DISC_SYNC_ENABLED, (Object)new Boolean(SyncManagerImpl.isDiscSyncEnabled()));
        this.addAppsLastInstalled();
        return "/jsp/home/home.jsp";
    }

    private String getUserName() {
        User user = UserManager.getInstance().getCurrentUser();
        String userName = "".equals(user.getName()) ? user.getUniqueName() : user.getName();
        return userName;
    }

    private String doEventRefresh() {
        this.addAppsLastInstalled();
        this.session.setAttribute(USER_NAME, (Object)this.getUserName());
        if (SyncStatus.isSyncFinished() && alreadyRefreshed) {
            ServerExceptionMessage serverMessage;
            this.session.removeAttribute(REFRESH);
            SyncStatus.reset();
            alreadyRefreshed = false;
            SyncPasswordHandlingOption option = SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption();
            if ((option == SyncPasswordHandlingOption.ONCE || option == SyncPasswordHandlingOption.AT_SYNC) && (serverMessage = SyncLogImpl.getSyncLogImplInstance().getServerExceptionMessage()) != null && 0 == serverMessage.getMessageId()) {
                this.request.setAttribute("MESSAGE", (Object)serverMessage.getLocalizedMessage());
                SyncLogImpl.getSyncLogImplInstance().reset();
                return "/jsp/home/syncpassword.jsp";
            }
            if (this.isSyncProtocolToBeDisplayed()) {
                return "/jsp/home/synclog.jsp";
            }
            this.session.setAttribute(SYNCSUCCESSFULL, (Object)"X");
            return "/jsp/home/home.jsp";
        }
        this.session.setAttribute(REFRESH, (Object)"X");
        this.session.removeAttribute(SYNCSUCCESSFULL);
        alreadyRefreshed = true;
        return "/jsp/home/home.jsp";
    }

    private String doEventAbout() {
        return "/jsp/home/about.jsp";
    }

    private String doEventSyncLog() {
        SyncProtocol.refreshMessages();
        return this.doHome();
    }

    private String doEventSync() {
        SyncManager syncManager = SyncManager.getInstance();
        Object nextJSP = null;
        SyncEventRegistry.getInstance().addSyncEventListener(new SyncStatus());
        Configuration config = Configuration.getInstance();
        if (syncManager.isSyncCredentialAvailable() && this.converter.getParameter("SYNC_PASSWORD") == null) {
            alreadyRefreshed = false;
            return this.doSync(syncManager);
        }
        if (config.getBoolean("MobileEngine.UM.SAPLogonTicketSupport", false) && config.getBoolean("MobileEngine.UM.SingleUserMode", false)) {
            alreadyRefreshed = false;
            return this.doSync(syncManager);
        }
        if ("go".equalsIgnoreCase(this.request.getParameter("sync"))) {
            return "/jsp/home/syncpassword.jsp";
        }
        String syncPassword = this.converter.getParameter("SYNC_PASSWORD");
        try {
            syncManager.setSyncPasswordOfCurrentUser(syncPassword);
            alreadyRefreshed = false;
            return this.doSync(syncManager);
        }
        catch (SyncPasswordException e) {
            String message = null;
            switch (e.getMessageId()) {
                case 1: {
                    message = this.resource.getString("xmsg_EMPTY_SYNC_PASSWORD");
                    break;
                }
                case 2: {
                    message = e.getMessage();
                    break;
                }
                case 3: {
                    message = MessageFormat.format(this.resource.getString("xmsg_INVALID_SYNC_PASS_LEN"), e.getMessageParameters());
                    break;
                }
                case 0: {
                    message = e.getMessage();
                    break;
                }
                default: {
                    message = this.resource.getString("xmsg_UNKNOWN_ERROR");
                }
            }
            this.request.setAttribute("MESSAGE", (Object)message);
            return "/jsp/home/syncpassword.jsp";
        }
    }

    private boolean isSyncProtocolToBeDisplayed() {
        SyncProtocol syncProtocol = new SyncProtocol();
        if (syncProtocol.hasToBeDisplayed()) {
            this.session.setAttribute(SYNC_LOG, (Object)syncProtocol.getSynchronizationProtocol());
            return true;
        }
        this.session.setAttribute(SYNCSUCCESSFULL, (Object)"X");
        this.session.setAttribute(USER_NAME, (Object)WafRegistry.getUserLongName());
        return false;
    }

    private String doSync(SyncManager syncManager) {
        SyncLogImpl.getSyncLogImplInstance().reset();
        new WafRegistry().notifyR3();
        SyncRunnable runnable = new SyncRunnable();
        new Thread(runnable).start();
        if (this.isSyncProtocolToBeDisplayed()) {
            return "/jsp/home/synclog.jsp";
        }
        return this.doEventRefresh();
    }

    private void addAppsLastInstalled() {
        String[] names = DeploymentInbox.getInstance().getLastInstalledMSDNames();
        StringBuffer apps = new StringBuffer(names.length * 30);
        if (names.length > 0) {
            this.request.setAttribute("NEWAPPUPONSTARTUP", (Object)new Boolean(true));
            if (names.length > 1) {
                this.request.setAttribute("MORETHANONEAPP", (Object)new Boolean(true));
            } else {
                this.request.setAttribute("MORETHANONEAPP", (Object)new Boolean(false));
            }
            int i = 0;
            while (i < names.length) {
                apps.append(names[i] + "\t");
                ++i;
            }
            this.request.setAttribute("APPSLASTINSTALLED", (Object)apps.toString());
        } else {
            this.request.setAttribute("NEWAPPUPONSTARTUP", (Object)new Boolean(false));
            this.request.setAttribute("MORETHANONEAPP", (Object)new Boolean(false));
            this.request.setAttribute("APPSLASTINSTALLED", (Object)"");
        }
    }

    static {
        ApplicationManager.getInstance().cleanUpIncompleteApplications();
    }

    class SyncRunnable
    implements Runnable {
        SyncRunnable() {
        }

        public void run() {
            SyncManager.getInstance().synchronizeWithBackend();
        }
    }
}

