/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.apps.util.List;
import com.sap.ip.me.sync.DCPackagingConfiguration;
import javax.servlet.http.HttpServletRequest;

public class ExtendedSettings {
    private HttpServletRequest request;
    private List packagingList;
    private DCPackagingConfiguration packagingConfig = new DCPackagingConfiguration();

    public ExtendedSettings() {
        this.packagingList = new List("PACKAGING");
        this.packagingList.setSelectedKey(Integer.toString(this.packagingConfig.getSelectedOption()));
        String[] localizedObjects = this.packagingConfig.getLocalizedOptions();
        int i = 0;
        while (i < localizedObjects.length) {
            this.packagingList.addListEntry(localizedObjects[i], Integer.toString(i));
            ++i;
        }
        this.packagingList.closeList();
    }

    public boolean isPackagingActive() {
        return this.packagingConfig.isActivated();
    }

    public void setPackagingActive(boolean isActive) {
        this.packagingConfig.setActivated(isActive);
    }

    public boolean isDownloadSuppressed() {
        return SyncManager.getInstance().isSuppressDownload();
    }

    public void setDownloadSuppressed(boolean isActive) {
        SyncManager.getInstance().setSuppressDownload(isActive);
    }

    public List getPackagingList() {
        this.packagingList.reset();
        return this.packagingList;
    }

    protected String doAction(String action, HttpServletRequest request) {
        this.request = request;
        String nextURL = "";
        if (action.equalsIgnoreCase("extendedsettings")) {
            nextURL = "/jsp/settings/extendedsettings.jsp";
        } else if (action.equalsIgnoreCase("extendedsettingssave")) {
            this.saveExtendedSettings();
            nextURL = "/jsp/settings/extendedsettings.jsp";
        }
        request.setAttribute("PACKAGING_LIST", (Object)this.getPackagingList());
        request.setAttribute("IS_PACKAGING_ACTIVE", (Object)new Boolean(this.isPackagingActive()));
        request.setAttribute("IS_DOWNLOAD_SUPPRESSED", (Object)new Boolean(this.isDownloadSuppressed()));
        return nextURL;
    }

    private void saveExtendedSettings() {
        String currentPackaging = this.request.getParameter("PACKAGING");
        this.packagingList.setSelectedKey(currentPackaging);
        this.packagingConfig.setSelectedOption(Integer.parseInt(currentPackaging));
        if (this.request.getParameter("IS_PACKAGING_ACTIVE") != null) {
            this.setPackagingActive(true);
        } else {
            this.setPackagingActive(false);
        }
        if (this.request.getParameter("IS_DOWNLOAD_SUPPRESSED") != null) {
            this.setDownloadSuppressed(true);
        } else {
            this.setDownloadSuppressed(false);
        }
    }
}

