/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.apps.SyncProtocol;
import com.sap.ip.me.apps.jsp.JSPConstants;
import com.sap.ip.me.apps.jsp.WebUtil;
import com.sap.ip.me.apps.util.List;
import com.sap.ip.me.sync.DiscSyncController;
import com.sap.ip.me.sync.DiscSyncException;
import com.sap.ip.me.sync.MediaType;
import javax.servlet.http.HttpServletRequest;

public class DiscSync
implements JSPConstants {
    int indexOfCopiedFile = 0;
    private DiscSyncController discSyncController;
    private HttpServletRequest request;
    private boolean isCopyProcessCompleted = false;
    private MEResourceBundle resourceBundle;
    private boolean isSyncSuccessfull = true;
    private boolean exited = false;

    public DiscSync(MEResourceBundle bundle) {
        this.resourceBundle = bundle;
        this.discSyncController = new DiscSyncController();
    }

    boolean isExited() {
        return this.exited;
    }

    protected String doAction(String action, HttpServletRequest request) {
        String nextURL = "";
        this.request = request;
        if (action.equalsIgnoreCase("discsyncupload")) {
            this.fillRequestAttributesForDefineMediaSizeScreen();
            nextURL = "/jsp/discsync/definemediasize.jsp";
        } else if (action.equalsIgnoreCase("discsyncdownload")) {
            this.fillRequestAttributesForCopyToClientScreen();
            nextURL = "/jsp/discsync/copytoclient.jsp";
        } else if (action.equalsIgnoreCase("discsyncdownload_add")) {
            this.addFileToList();
            nextURL = "/jsp/discsync/copytoclient.jsp";
        } else if (action.equalsIgnoreCase("discsyncdownload_clear")) {
            if (this.discSyncController.getConfiguration().getUploadedFiles().length != 0) {
                request.setAttribute("QUESTION", (Object)this.resourceBundle.getString("xmsg.discsync.askclearlist"));
                request.setAttribute("EVENT_NAME", (Object)"discsyncclearlist");
                nextURL = "/jsp/questionaccept.jsp";
            } else {
                this.fillRequestAttributesForCopyToClientScreen();
                nextURL = "/jsp/discsync/copytoclient.jsp";
            }
        } else if (action.equalsIgnoreCase("discsyncclearlist_yes")) {
            this.clearFileList();
            nextURL = "/jsp/discsync/copytoclient.jsp";
        } else if (action.equalsIgnoreCase("discsyncclearlist_no")) {
            this.fillRequestAttributesForCopyToClientScreen();
            nextURL = "/jsp/discsync/copytoclient.jsp";
        } else if (action.equalsIgnoreCase("discsyncdownload_next")) {
            try {
                this.discSyncController.checkCompleteness();
                this.fillRequestAttributesForDefineMediaSizeScreen();
                nextURL = "/jsp/discsync/definemediasize.jsp";
            }
            catch (DiscSyncException ex) {
                request.setAttribute("MESSAGE", (Object)ex.getLocalizedMessage());
                this.fillRequestAttributesForCopyToClientScreen();
                nextURL = "/jsp/discsync/copytoclient.jsp";
            }
        } else if (action.equalsIgnoreCase("discsyncupload_sync")) {
            nextURL = this.callDiscSynchronization();
        } else if (action.equalsIgnoreCase("discsyncupload_back")) {
            this.fillRequestAttributesForCopyToClientScreen();
            nextURL = "/jsp/discsync/copytoclient.jsp";
        } else if (action.equalsIgnoreCase("discsync_cancel")) {
            this.cancelDiscSync();
        } else if (action.equalsIgnoreCase("discsynccopytodisc_copy")) {
            this.copyFileToDisc();
            nextURL = "/jsp/discsync/copytodisc.jsp";
        } else if (!action.equalsIgnoreCase("discsynccopytodisc_finish")) {
            if (action.equalsIgnoreCase("discsynccopytodisc_cancel")) {
                if (!this.isCopyProcessCompleted) {
                    request.setAttribute("QUESTION", (Object)this.resourceBundle.getString("xmsg.discsync.cancelcopy"));
                    request.setAttribute("EVENT_NAME", (Object)"discsynccopytodisc_cancel");
                    nextURL = "/jsp/questionaccept.jsp";
                } else {
                    this.exited = true;
                }
            } else if (action.equalsIgnoreCase("discsynccopytodisc_cancel_yes")) {
                this.cancelDiscSync();
            } else if (action.equalsIgnoreCase("discsynccopytodisc_cancel_no")) {
                this.fillRequestAttributesForCopyToDiscScreen();
                nextURL = "/jsp/discsync/copytodisc.jsp";
            }
        }
        return nextURL;
    }

    private String callDiscSynchronization() {
        int selectedMediaType = Integer.parseInt(this.request.getParameter("MEDIA_TYPE_LIST"));
        MediaType mediaType = this.discSyncController.getConfiguration().getMediaTypes()[selectedMediaType];
        String userDefinedSize = this.request.getParameter("USER_DEFINED_SIZE");
        if (mediaType.isUserDefined()) {
            int unit = Integer.parseInt(this.request.getParameter("MEDIA_SIZE_UNIT_LIST"));
            try {
                this.discSyncController.getConfiguration().setCurrentMediaSize(userDefinedSize, unit);
            }
            catch (DiscSyncException e) {
                this.request.setAttribute("MESSAGE", (Object)e.getLocalizedMessage());
                this.fillRequestAttributesForDefineMediaSizeScreen();
                return "/jsp/discsync/definemediasize.jsp";
            }
        } else {
            if (!userDefinedSize.equals("")) {
                this.request.setAttribute("MESSAGE", (Object)this.resourceBundle.getString("xmsg.discsync.notuserdef"));
                this.fillRequestAttributesForDefineMediaSizeScreen();
                return "/jsp/discsync/definemediasize.jsp";
            }
            this.discSyncController.getConfiguration().setCurrentMediaSize(mediaType.getSize());
        }
        try {
            this.discSyncController.callSync();
            this.indexOfCopiedFile = 0;
            this.isCopyProcessCompleted = false;
        }
        catch (DiscSyncException e) {
            this.request.setAttribute("MESSAGE", (Object)e.getLocalizedMessage());
            this.fillRequestAttributesForDefineMediaSizeScreen();
            return "/jsp/discsync/definemediasize.jsp";
        }
        this.wasSynchronizationSuccessfull();
        this.fillRequestAttributesForCopyToDiscScreen();
        return "/jsp/discsync/copytodisc.jsp";
    }

    private void fillRequestAttributesForDefineMediaSizeScreen() {
        MediaType[] mediaType = this.discSyncController.getConfiguration().getMediaTypes();
        List mediaTypeList = new List("MEDIA_TYPE_LIST");
        MediaType currentMediaType = this.discSyncController.getConfiguration().getCurrentMediaType();
        int i = 0;
        while (i < mediaType.length) {
            mediaTypeList.addListEntry(mediaType[i].toString(), Integer.toString(i));
            if (mediaType[i].equals(currentMediaType)) {
                mediaTypeList.setSelectedKey(Integer.toString(i));
            }
            ++i;
        }
        mediaTypeList.closeList();
        if (currentMediaType.isUserDefined()) {
            this.request.setAttribute("CURRENT_MEDIA_TYPE_SIZE", (Object)WebUtil.removeNull(Long.toString(currentMediaType.getSize())));
        } else {
            this.request.setAttribute("CURRENT_MEDIA_TYPE_SIZE", (Object)"");
        }
        String[] mediaSizeUnits = this.discSyncController.getConfiguration().getUnits();
        List mediaSizeUnitList = new List("MEDIA_SIZE_UNIT_LIST");
        int i2 = 0;
        while (i2 < mediaSizeUnits.length) {
            mediaSizeUnitList.addListEntry(mediaSizeUnits[i2], Integer.toString(i2));
            ++i2;
        }
        mediaSizeUnitList.setSelectedKey("");
        mediaSizeUnitList.closeList();
        this.request.setAttribute(mediaTypeList.getListKey(), (Object)mediaTypeList);
        this.request.setAttribute(mediaSizeUnitList.getListKey(), (Object)mediaSizeUnitList);
    }

    private void fillRequestAttributesForCopyToDiscScreen() {
        this.request.setAttribute("FILE_LIST", (Object)this.discSyncController.getConfiguration().getDownloadableFiles());
        this.request.setAttribute("CURRENT_FILE_INDEX", (Object)new Integer(this.indexOfCopiedFile));
        this.request.setAttribute("IS_COPY_PROCESS_COMPLETED", (Object)new Boolean(this.isCopyProcessCompleted));
        this.request.setAttribute("TARGET_LOCATION", (Object)this.discSyncController.getConfiguration().getTargetLocation());
        this.request.setAttribute("IS_SYNCHRONIZATION_SUCCESSFULL", (Object)new Boolean(this.isSyncSuccessfull));
    }

    private void fillRequestAttributesForCopyToClientScreen() {
        this.request.setAttribute("SOURCE_PATH", (Object)this.discSyncController.getConfiguration().getSourceLocation());
        this.request.setAttribute("FILE_LIST", (Object)this.discSyncController.getConfiguration().getUploadedFiles());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFileToList() {
        String sourceFile = this.request.getParameter("FILE_NAME");
        try {
            try {
                this.discSyncController.uploadFile(sourceFile);
            }
            catch (DiscSyncException discSyncExc) {
                this.request.setAttribute("MESSAGE", (Object)discSyncExc.getLocalizedMessage());
                Object var4_3 = null;
                this.request.setAttribute("FILE_LIST", (Object)this.discSyncController.getConfiguration().getUploadedFiles());
                this.request.setAttribute("CURRENT_FILE_INDEX", (Object)new Integer(this.indexOfCopiedFile));
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.request.setAttribute("FILE_LIST", (Object)this.discSyncController.getConfiguration().getUploadedFiles());
            this.request.setAttribute("CURRENT_FILE_INDEX", (Object)new Integer(this.indexOfCopiedFile));
            throw throwable;
        }
        this.request.setAttribute("FILE_LIST", (Object)this.discSyncController.getConfiguration().getUploadedFiles());
        this.request.setAttribute("CURRENT_FILE_INDEX", (Object)new Integer(this.indexOfCopiedFile));
    }

    private void clearFileList() {
        this.discSyncController.cleanUploadedFilesList();
        this.request.setAttribute("FILE_LIST", (Object)this.discSyncController.getConfiguration().getUploadedFiles());
    }

    private void copyFileToDisc() {
        String copiedFileIndex = this.request.getParameter("CURRENT_FILE_INDEX");
        String targetLocation = this.request.getParameter("TARGET_LOCATION");
        this.discSyncController.getConfiguration().setTargetLocation(targetLocation);
        String[] downloadableFileList = this.discSyncController.getConfiguration().getDownloadableFiles();
        if (copiedFileIndex != null) {
            this.indexOfCopiedFile = Integer.parseInt(copiedFileIndex);
        }
        if (downloadableFileList.length > 0 && downloadableFileList.length != this.indexOfCopiedFile) {
            String downloadableFile = downloadableFileList[this.indexOfCopiedFile];
            try {
                this.discSyncController.copyFileToMedia(downloadableFile);
                ++this.indexOfCopiedFile;
            }
            catch (DiscSyncException discSyncExc) {
                this.request.setAttribute("MESSAGE", (Object)discSyncExc.getLocalizedMessage());
            }
        } else {
            this.isCopyProcessCompleted = true;
        }
        if (this.indexOfCopiedFile == downloadableFileList.length) {
            this.isCopyProcessCompleted = true;
        }
        this.fillRequestAttributesForCopyToDiscScreen();
    }

    private void cancelDiscSync() {
        this.discSyncController.cancelDiscSyncProcess();
        this.exited = true;
    }

    private void wasSynchronizationSuccessfull() {
        this.isSyncSuccessfull = !new SyncProtocol().hasToBeDisplayed();
    }
}

