/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps.jsp;

import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import com.sap.ip.me.api.runtime.jsp.ParameterConverter;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.apps.jsp.DiscSync;
import com.sap.ip.me.apps.jsp.ExtendedSettings;
import com.sap.ip.me.apps.jsp.Home;
import com.sap.ip.me.apps.jsp.InstallationPackage;
import com.sap.ip.me.apps.jsp.ManagePasswords;
import com.sap.ip.me.apps.jsp.Settings;
import com.sap.ip.me.apps.jsp.SingleActivityTracing;
import com.sap.ip.me.apps.jsp.Trace;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationNotAvailableException;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ControllerServlet
extends AbstractMEHttpServlet {
    protected boolean DEBUG = false;
    private String TOMCATPORT = "tomcatport";
    private ExtendedSettings extendedSettings;
    private DiscSync discSync;

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextURL = null;
        AppLog appLog = AppLog.getInstance("MI/FrameworkApplications");
        ParameterConverter converter = new ParameterConverter(request);
        try {
            converter.setCharacterEncoding("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            appLog.logException(10, (Throwable)e, true);
        }
        if (UserManagerImpl.getUserManagerImplInstance().getCurrentUser() != null) {
            if (eventName.startsWith("managePasswords")) {
                nextURL = new ManagePasswords(this.getResourceBundle(), converter).performAction(eventName);
                this.checkResourceBundle();
                return nextURL;
            }
            String event = this.getEventName(request, response, eventName);
            if (event.startsWith("home")) {
                if (event.equals("homeonApplicationChoice")) {
                    nextURL = this.startApplication(request, response);
                } else {
                    Home home = new Home(this.getResourceBundle(), converter);
                    nextURL = home.doAction(event, request);
                }
            } else if (event.startsWith("settings")) {
                Settings settings = new Settings(this.getResourceBundle(), converter);
                if ("settingschangesyncpassword".equalsIgnoreCase(eventName)) {
                    nextURL = settings.doChangeSyncPassword();
                } else if (event.equals("settingssettings")) {
                    nextURL = settings.doGetSettings();
                } else if (event.equals("settingsupdate")) {
                    nextURL = settings.doUpdateSettings();
                }
            } else if (event.startsWith("extended")) {
                nextURL = this.extendedSettings.doAction(event, request);
            } else if (event.startsWith("discsync")) {
                DiscSync discSync = this.getDiscSync();
                nextURL = discSync.doAction(event, request);
                if (discSync.isExited()) {
                    this.discSync = null;
                }
            } else if (event.startsWith("sat")) {
                SingleActivityTracing sat = new SingleActivityTracing();
                nextURL = sat.doAction(event, request);
            } else if (event.startsWith("clinst")) {
                InstallationPackage ip = new InstallationPackage();
                nextURL = ip.doAction(event, request);
                Home home = new Home(this.getResourceBundle(), converter);
                nextURL = home.doHome();
            } else if (event.equalsIgnoreCase("deploymentinboxlog")) {
                String appName = request.getParameter("name");
                request.setAttribute("name", (Object)appName);
                nextURL = "/jsp/deploymentinbox/installlog.jsp?name=" + appName + "&time=" + System.currentTimeMillis();
            } else if (event.startsWith("deploymentinbox")) {
                nextURL = "/jsp/deploymentinbox/deploymentinbox.jsp";
            } else if (event.startsWith("trace")) {
                Trace trace = new Trace();
                if (event.equals("tracetrace")) {
                    nextURL = trace.doTrace(request);
                } else if (event.equals("tracechangeTraceLevel")) {
                    nextURL = trace.doSetTraceSettings(request);
                } else if (event.equals("tracedisplay")) {
                    nextURL = trace.doTraceDisplayList(request);
                } else if (event.equals("tracereset")) {
                    nextURL = trace.doTraceReset(request);
                } else if (event.equals("traceprintPerformanceLog")) {
                    nextURL = trace.doPrintPerformanceLog(request);
                } else if (event.equals("tracesendToR3")) {
                    nextURL = trace.doSendTraceToR3(request);
                }
            } else if (event.equals("/jsp/home/home.jsp")) {
                Home home = new Home(this.getResourceBundle(), converter);
                nextURL = home.doHome();
            } else if (event.equals("/jsp/login/login.jsp")) {
                nextURL = event;
            } else if (event.equals("login")) {
                Home home = new Home(this.getResourceBundle(), converter);
                nextURL = home.doHome();
            } else if (event.equals("confirmchangedpw")) {
                Home home = new Home(this.getResourceBundle(), converter);
                nextURL = home.doHome();
            } else if (event.equals("confirmnewuser")) {
                Home home = new Home(this.getResourceBundle(), converter);
                nextURL = home.doHome();
            }
        } else {
            nextURL = "/jsp/login/login.jsp";
        }
        this.checkResourceBundle();
        return nextURL;
    }

    public void doInitialize() {
        this.setResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine");
        this.extendedSettings = new ExtendedSettings();
    }

    private DiscSync getDiscSync() {
        if (this.discSync == null) {
            this.discSync = new DiscSync(this.getResourceBundle());
        }
        return this.discSync;
    }

    public String getApplicationName() {
        return ApplicationManager.getInstance().getFrameworkName();
    }

    public void checkResourceBundle() {
        if (!this.getResourceBundle().getLocale().getLanguage().equalsIgnoreCase(Localization.getLanguage())) {
            this.setResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine");
        }
    }

    public String startApplication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        AppLog appLog = AppLog.getInstance("MI/FrameworkApplications");
        if (!"127.0.0.1".equalsIgnoreCase(httpServletRequest.getRemoteAddr())) {
            appLog.log(60, "Attempt to get access from remote machine with IP address {0} was successfully defeated.", (Object)httpServletRequest.getRemoteAddr());
            httpServletResponse.sendError(403);
            return "";
        }
        httpServletRequest.getSession().setMaxInactiveInterval(-1);
        Properties props = System.getProperties();
        String port = Integer.toString(httpServletRequest.getServerPort());
        ((Hashtable)props).put(this.TOMCATPORT, port);
        if (this.DEBUG) {
            appLog.log(90, "TOMCATPORT:  {0}", (Object)props.getProperty(this.TOMCATPORT));
        }
        String urlwgate = httpServletRequest.getContextPath().concat(httpServletRequest.getServletPath());
        if (this.DEBUG) {
            appLog.log(90, "URLWGATE:  {0}", (Object)System.getProperty(urlwgate));
        }
        if (UserManager.getInstance().getCurrentUser() == null) {
            return "/servlet/com.sap.ip.me.apps.jsp.LoginServlet";
        }
        String applicationToBeStarted = httpServletRequest.getParameter("applicationName");
        String applicationNamespace = httpServletRequest.getParameter("applicationNamespace");
        String applicationVersion = httpServletRequest.getParameter("applicationVersion");
        String applicationType = httpServletRequest.getParameter("applicationType");
        if (applicationToBeStarted != null) {
            int startable = ApplicationManager.getInstance().checkStartable(applicationToBeStarted, applicationNamespace, applicationVersion);
            if (startable == 0) {
                if (applicationType.equalsIgnoreCase("microits")) {
                    try {
                        ApplicationManager.getInstance().startApplication(applicationToBeStarted);
                    }
                    catch (ApplicationNotAvailableException e) {
                        appLog.logException(50, e);
                    }
                    StringBuffer applicationUrl = new StringBuffer(70);
                    applicationUrl.append(httpServletRequest.getScheme()).append("://");
                    applicationUrl.append(httpServletRequest.getServerName()).append(":");
                    applicationUrl.append(httpServletRequest.getServerPort()).append("/me/run/");
                    applicationUrl.append(applicationToBeStarted).append("/!");
                    return applicationUrl.toString();
                }
                if (applicationType.equalsIgnoreCase("jsp")) {
                    StringBuffer applicationUrl = new StringBuffer(60);
                    applicationUrl.append(httpServletRequest.getScheme()).append("://");
                    applicationUrl.append(httpServletRequest.getServerName()).append(":");
                    applicationUrl.append(httpServletRequest.getServerPort()).append("/");
                    applicationUrl.append(applicationToBeStarted).append("/start");
                    return applicationUrl.toString();
                }
                if (httpServletRequest.getParameter("applicationType").equalsIgnoreCase("webdynpro")) {
                    StringBuffer applicationUrl = new StringBuffer(60);
                    applicationUrl.append(httpServletRequest.getScheme()).append("://");
                    applicationUrl.append(httpServletRequest.getServerName()).append(":");
                    applicationUrl.append(httpServletRequest.getServerPort()).append("/");
                    applicationUrl.append("WEBDYNPRO/Servlet/");
                    MobileSolutionDescriptor msd = ApplicationManager.getInstance().getMobileSolutionDescriptor(applicationToBeStarted, applicationVersion);
                    String projectName = msd.getWebDynproProjectName();
                    String applicationName = msd.getWebDynproApplicationName();
                    applicationUrl.append(projectName);
                    applicationUrl.append("/" + applicationName);
                    try {
                        ApplicationManager.getInstance().startApplication(applicationToBeStarted);
                    }
                    catch (ApplicationNotAvailableException e) {
                        appLog.logException(50, e);
                    }
                    return applicationUrl.toString();
                }
            } else if (startable == 1) {
                httpServletRequest.getSession().setAttribute(Home.LANGUAGE_NOT_SUPPORTED, (Object)"X");
                return "/jsp/home/home.jsp";
            }
        } else {
            if (this.DEBUG) {
                appLog.log(90, "Calling super.service()...");
            }
            super.service(httpServletRequest, httpServletResponse);
        }
        return "";
    }

    private String getEventName(HttpServletRequest request, HttpServletResponse response, String eventName) throws ServletException, IOException {
        String event = request.getParameter("action") != null ? request.getParameter("action") : "";
        if (eventName.equals("")) {
            if (event.equals("")) {
                event = UserManager.getInstance().getCurrentUser() != null ? "/jsp/home/home.jsp" : "/jsp/login/login.jsp";
            }
        } else {
            event = eventName;
        }
        if (!event.equals("login") && request.getSession().isNew()) {
            event = "/jsp/login/login.jsp";
        }
        return event;
    }
}

