/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.services.MEResourceBundle;
import com.sap.ip.me.api.sync.SyncLog;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.sync.SyncLogImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SyncProtocol {
    private static final Hashtable MESSAGE_MAP = new Hashtable();
    private static final String RESOURCE_BUNDLE_NAME = "com/sap/ip/me/awtapps/home/mobile_engine";
    private static Hashtable MESSAGE_MAP_STARTED = new Hashtable();
    private static Hashtable MESSAGE_MAP_CONNECTED = new Hashtable();
    private static Hashtable MESSAGE_MAP_REQUEST_CONTAINER_CREATED = new Hashtable();
    private static MEResourceBundle bundle;
    private static String language;

    public SyncProtocol() {
        SyncProtocol.initializeMessages();
    }

    private static void initializeMessages() {
        if (!Localization.getLanguage().equals(language)) {
            bundle = new MEResourceBundle(RESOURCE_BUNDLE_NAME);
        } else if (bundle == null) {
            bundle = new MEResourceBundle(RESOURCE_BUNDLE_NAME);
        }
        language = Localization.getLanguage();
        if (Configuration.getInstance().getBoolean("MobileEngine.Sync.Proxyused", false)) {
            MESSAGE_MAP_STARTED.put("MESSAGE_2", bundle.getString("PROXY") + " " + SyncSettings.getSyncGateway());
        } else {
            MESSAGE_MAP_STARTED.put("MESSAGE_2", bundle.getString("NOPROXY") + " " + SyncSettings.getSyncGateway());
        }
        MESSAGE_MAP_STARTED.put("MESSAGE_1", bundle.getString("SYNCSTART"));
        MESSAGE_MAP_STARTED.put("ERROR_1", bundle.getString("CONNECTNOSUCCESS"));
        MESSAGE_MAP_REQUEST_CONTAINER_CREATED.put("ERROR_1", bundle.getString("CONNECTNOSUCCESS"));
        MESSAGE_MAP_CONNECTED.put("MESSAGE_1", bundle.getString("CONNECTSUCCESS"));
        MESSAGE_MAP_CONNECTED.put("MESSAGE_2", bundle.getString("INBOUNDPROCSTART"));
    }

    public String[] getSynchronizationProtocol() {
        String[] deplLogMessages;
        String[] infoMessages;
        Vector<String> messages = new Vector<String>();
        String[] syncMessages = this.getMessages();
        int i = 0;
        while (i < syncMessages.length) {
            messages.addElement(syncMessages[i]);
            ++i;
        }
        String[] syncLogMessages = SyncLog.getInstance().getFailureMessages();
        if (syncLogMessages != null) {
            int i2 = 0;
            while (i2 < syncLogMessages.length) {
                messages.addElement(syncLogMessages[i2]);
                ++i2;
            }
        }
        if ((infoMessages = SyncLog.getInstance().getInfoMessages()) != null) {
            int i3 = 0;
            while (i3 < infoMessages.length) {
                messages.addElement(infoMessages[i3]);
                ++i3;
            }
        }
        if ((deplLogMessages = DeploymentMessages.getInstance().getMessages()) != null) {
            int i4 = 0;
            while (i4 < deplLogMessages.length) {
                messages.addElement(deplLogMessages[i4]);
                ++i4;
            }
        }
        Object[] syncProtocol = new String[messages.size()];
        messages.copyInto(syncProtocol);
        return syncProtocol;
    }

    public boolean hasToBeDisplayed() {
        String[] failureMessages = SyncLog.getInstance().getFailureMessages();
        String[] infoMessages = SyncLog.getInstance().getInfoMessages();
        return failureMessages.length != 0 || DeploymentMessages.getInstance().hasToBeDisplayed() || infoMessages.length != 0;
    }

    public static void refreshMessages() {
        DeploymentMessages.getInstance().refreshMessages();
    }

    private String[] getMessages() {
        Vector<String> synchronizationMessages = new Vector<String>();
        boolean isConnected = false;
        Enumeration enumeration = SyncLogImpl.getSyncLogImplInstance().getProcessedStates().elements();
        while (enumeration.hasMoreElements()) {
            Hashtable messageMapFromSequenceEntry;
            Object messageSequenceEntry = enumeration.nextElement();
            if (isConnected && messageSequenceEntry.equals(SyncLogImpl.CONNECTED)) continue;
            if (messageSequenceEntry.equals(SyncLogImpl.CONNECTED)) {
                isConnected = true;
            }
            if ((messageMapFromSequenceEntry = (Hashtable)MESSAGE_MAP.get(messageSequenceEntry)) == null) continue;
            boolean hasMoreMessageEntries = true;
            int i = 1;
            while (hasMoreMessageEntries) {
                String message = (String)messageMapFromSequenceEntry.get("MESSAGE_" + i);
                if (message == null) {
                    hasMoreMessageEntries = false;
                } else {
                    synchronizationMessages.addElement(message);
                }
                ++i;
            }
            if (enumeration.hasMoreElements()) continue;
            boolean hasMoreErrorEntries = true;
            int i2 = 1;
            while (hasMoreErrorEntries) {
                String message = (String)messageMapFromSequenceEntry.get("ERROR_" + i2);
                if (message == null) {
                    hasMoreErrorEntries = false;
                } else {
                    synchronizationMessages.addElement(message);
                }
                ++i2;
            }
        }
        Object[] messages = new String[synchronizationMessages.size()];
        synchronizationMessages.copyInto(messages);
        return messages;
    }

    static {
        language = Localization.getLanguage();
        MESSAGE_MAP.put(SyncLogImpl.STARTED, MESSAGE_MAP_STARTED);
        MESSAGE_MAP.put(SyncLogImpl.REQUEST_CONTAINER_CREATED, MESSAGE_MAP_REQUEST_CONTAINER_CREATED);
        MESSAGE_MAP.put(SyncLogImpl.CONNECTED, MESSAGE_MAP_CONNECTED);
        SyncProtocol.initializeMessages();
    }
}

