/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.apps.InstallationScenario;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.sync.OldSyncLog;
import java.io.File;

public class InstallationScenarioApplicationType
implements ApplicationType {
    private static OldSyncLog syncLog = OldSyncLog.getInstance();

    public static void downloadAllInstallationFiles(InstallationScenario is) throws InstallationException {
        String downLoadDirectory = Configuration.getInstallationDirectory().concat(File.separator).concat("pending");
        File pendingDir = new File(downLoadDirectory);
        if (!pendingDir.exists()) {
            pendingDir.mkdir();
        }
        MeIteratorVectorImpl msdIterator = new MeIteratorVectorImpl(is.getUnorderedMSDList());
        while (msdIterator.hasNext()) {
            MobileSolutionDescriptor nextMSD = (MobileSolutionDescriptor)msdIterator.next();
            String url = nextMSD.getInstallationUrl();
            if ("".equals(url)) {
                syncLog.addMessage(nextMSD.getName() + " " + nextMSD.getVersion() + " could not be downloaded because no download URL was sent");
                continue;
            }
            String fileextension = url.substring(url.lastIndexOf(46), url.length());
            if (nextMSD.isInstallationFileAlreadyDownloaded()) continue;
            String localPath = downLoadDirectory.concat(File.separator).concat(nextMSD.getName().concat(fileextension));
            try {
                IOUtils.httpGet(nextMSD.getInstallationUrl(), localPath);
                syncLog.downloadApp(nextMSD.getName() + " " + nextMSD.getVersion() + ": " + nextMSD.getDescription());
                InstallationScenarioApplicationType.setLocalPath(nextMSD, localPath);
            }
            catch (HttpConnectionException e) {
                syncLog.addMessage(nextMSD.getName() + " " + nextMSD.getVersion() + " could not be downloaded because " + e.getMessage());
            }
        }
    }

    public void install(String source, MobileSolutionDescriptor msd) throws InstallationException {
        if (!(msd instanceof InstallationScenario)) {
            throw new InstallationException(msd + " is not an instance of InstallationScenario", null);
        }
        InstallationScenario is = (InstallationScenario)msd;
        syncLog.addInstApp(is.getName() + " " + is.getVersion() + ": " + is.getDescription());
        this.install(is);
    }

    public void uninstall(MobileSolutionDescriptor msd) throws InstallationException {
        DeploymentMessages.getInstance().addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLING", msd.getName() + " : " + msd.getVersion());
    }

    private static void setLocalPath(MobileSolutionDescriptor msd, String localPath) {
        msd.setInstallationFileAlreadyDownloaded(true);
        msd.setCustomizingValue("LOCALPATH", localPath);
    }

    private void install(InstallationScenario is) throws InstallationException {
        if (!is.allMSDsAreAlreadyDowloaded()) {
            throw new InstallationException("Problems while installing " + is.getName() + "; not all application installation files have already been downloaded", null);
        }
        MobileSolutionDescriptor[] msdsToInstall = is.getNextMSDGroup();
        MobileSolutionDescriptor msd = null;
        int i = 0;
        while (i < msdsToInstall.length) {
            try {
                msd = msdsToInstall[i];
                ApplicationManager.getInstance().installApplication(msd);
            }
            catch (Exception e) {
                msd.setInstallationFileAlreadyDownloaded(false);
                throw new InstallationException("Problems while installing " + msdsToInstall[i].getName() + " out of InstallationScenario " + is.getName(), e);
            }
            ++i;
        }
    }
}

