/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps;

import com.sap.ip.me.apps.InstallationScenarioApplicationType;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.MobileSolutionDescriptorApplicationDependency;
import java.util.Enumeration;
import java.util.Vector;

public class InstallationScenario
extends MobileSolutionDescriptor {
    static final long serialVersionUID = -4327788096751119418L;
    private Vector orderedMSDList;
    private Vector msdCollections = new Vector(1, 1);

    public InstallationScenario(String nameSpace, String name, String version) {
        super(nameSpace, name, version);
    }

    public void addMSDInSequence(MobileSolutionDescriptor msd, int index) {
        if (this.orderedMSDList == null) {
            return;
        }
        Vector orderedMSDGroup = null;
        orderedMSDGroup = (Vector)this.orderedMSDList.elementAt(index);
        orderedMSDGroup.addElement(msd);
        this.msdCollections.addElement(msd);
    }

    public void addMSDInSequence(MobileSolutionDescriptor msd) {
        this.addMSDInSequence(msd, 1);
    }

    public MobileSolutionDescriptor[] getNextMSDGroup() {
        int size = this.orderedMSDList.size();
        MobileSolutionDescriptor[] msdGroup = null;
        int i = 0;
        while (i < size) {
            Vector nextGroup = (Vector)this.orderedMSDList.elementAt(i);
            int nextGroupSize = nextGroup.size();
            boolean msdAdded = false;
            msdGroup = new MobileSolutionDescriptor[nextGroupSize];
            int j = 0;
            while (j < nextGroupSize) {
                MobileSolutionDescriptor nextMSDInGroup = (MobileSolutionDescriptor)nextGroup.elementAt(j);
                if (!nextMSDInGroup.isInstalled()) {
                    msdGroup[j] = nextMSDInGroup;
                    msdAdded = true;
                }
                ++j;
            }
            if (msdAdded) {
                return msdGroup;
            }
            ++i;
        }
        return new MobileSolutionDescriptor[0];
    }

    public void setInstalled(boolean installedValue) {
        if (!installedValue) {
            super.setInstalled(installedValue);
        } else {
            boolean areDependantAppInstalled = true;
            int i = 0;
            while (i < this.msdCollections.size()) {
                if (!((MobileSolutionDescriptor)this.msdCollections.elementAt(i)).isInstalled()) {
                    areDependantAppInstalled = false;
                    break;
                }
                ++i;
            }
            super.setInstalled(areDependantAppInstalled);
        }
    }

    public boolean isMSDPartOfInstallationScenario(MobileSolutionDescriptor msd) {
        if (this.orderedMSDList == null) {
            return false;
        }
        int i = 0;
        while (i < this.msdCollections.size()) {
            MobileSolutionDescriptor nextMSD = (MobileSolutionDescriptor)this.msdCollections.elementAt(i);
            if (nextMSD.getName().equalsIgnoreCase(msd.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initialize() throws InstallationException {
        this.initializeInstallationOrder();
        InstallationScenarioApplicationType.downloadAllInstallationFiles(this);
    }

    public Vector getInstallationOrder() {
        return this.msdCollections;
    }

    public Vector getUnorderedMSDList() {
        return this.msdCollections;
    }

    public Vector getAllMSDAtSequence(int index) {
        try {
            return (Vector)this.orderedMSDList.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            return new Vector(1, 1);
        }
    }

    public void setIncomplete(boolean status) {
        if (status) {
            super.setIncomplete(status);
        } else {
            boolean areDependantAppIncomplete = false;
            Object nextMSD = null;
            int i = 0;
            while (i < this.msdCollections.size()) {
                if (((MobileSolutionDescriptor)this.msdCollections.elementAt(i)).isIncomplete()) {
                    areDependantAppIncomplete = true;
                }
                ++i;
            }
            super.setIncomplete(areDependantAppIncomplete);
        }
    }

    public Vector getOrderedMSDList() {
        return this.orderedMSDList;
    }

    public boolean isInstalled() {
        return super.isInstalled();
    }

    public boolean isIncomplete() {
        return super.isIncomplete();
    }

    public boolean allMSDsAreAlreadyDowloaded() {
        int size = this.msdCollections.size();
        if (size == 0) {
            return true;
        }
        int i = 0;
        while (i < size) {
            MobileSolutionDescriptor msd = (MobileSolutionDescriptor)this.msdCollections.elementAt(i);
            if (!msd.isInstallationFileAlreadyDownloaded()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initializeInstallationOrder() throws InstallationException {
        if (this.orderedMSDList == null) {
            Vector listOfDependencies = this.getListOfDependency();
            int noOfApplication = listOfDependencies.size() + 1;
            this.orderedMSDList = new Vector(noOfApplication);
            int i = 0;
            while (i < noOfApplication) {
                this.orderedMSDList.addElement(new Vector());
                ++i;
            }
            Object orderedMSDGroup = null;
            Enumeration e = listOfDependencies.elements();
            while (e.hasMoreElements()) {
                MobileSolutionDescriptorApplicationDependency msdDep = (MobileSolutionDescriptorApplicationDependency)e.nextElement();
                String namespace = msdDep.getDependencyValueForName("NAMESPACE");
                String name = msdDep.getDependencyValueForName("NAME");
                String instIndex = msdDep.getDependencyValueForName("INSTALL_SEQUENCE");
                MobileSolutionDescriptor msd = ApplicationManager.getInstance().getMobileSolutionDescriptor(name);
                if (msd == null) {
                    throw new InstallationException("Installation of " + this.getName() + " is aborted because it contains dependency to non-existing Mobile Component Descriptor " + name, new NullPointerException());
                }
                int insSeqNumber = Integer.parseInt(instIndex);
                this.addMSDInSequence(msd, insSeqNumber);
            }
        }
    }
}

