/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.apps;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.apps.DeploymentInstallLog;
import com.sap.ip.me.apps.InstallationScenario;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class DeploymentInbox {
    private final String DEP_LOG_FILE = "Installation.log";
    private static DeploymentInbox instance = new DeploymentInbox();
    private InstallationScenario installScenario = null;
    private Vector lastInstalledMSDs = new Vector(5);
    private Vector applicationLogs = new Vector(5);
    private Trace t = Trace.getInstance("MI/Deployment");

    private DeploymentInbox() {
        this.installScenario = (InstallationScenario)ApplicationManager.getInstance().getInstallationSequence();
        this.applicationLogs = new Vector(5);
        if (this.installScenario != null) {
            try {
                this.loadApplicationLogs();
            }
            catch (FileNotFoundException fe) {
                this.t.logException(fe);
                this.t.log(50, "Creating new app. logs for Installation Scenario - file was not found");
                this.applicationLogs = new Vector();
            }
            catch (IOException io) {
                this.t.logException(io);
                this.t.log(50, "Creating new app. logs for Installation Scenario - problem in accessing the file");
                this.applicationLogs = new Vector();
            }
            catch (ClassNotFoundException ce) {
                this.t.logException(ce);
                this.t.log(50, "Creating new app. logs for Installation Scenario - wrong data for class Vector of InstallLog");
                this.applicationLogs = new Vector();
            }
        } else {
            this.clearApplicationLogs();
        }
    }

    public static DeploymentInbox getInstance() {
        if (instance.getInstallationScenario() == null) {
            instance = new DeploymentInbox();
        }
        return instance;
    }

    public Vector getAllAppStatus() {
        if (this.installScenario == null) {
            return null;
        }
        MobileSolutionDescriptor msd = null;
        Vector<String> appStatus = null;
        Vector msdList = null;
        Vector dependantMSDs = new Vector();
        msdList = this.installScenario.getUnorderedMSDList();
        int i = 0;
        while (i < msdList.size()) {
            msd = (MobileSolutionDescriptor)msdList.elementAt(i);
            appStatus = new Vector<String>(1, 1);
            appStatus.addElement(msd.getName());
            if (msd.isInstalled()) {
                appStatus.addElement("I");
            } else {
                appStatus.addElement("T");
            }
            dependantMSDs.addElement(appStatus);
            ++i;
        }
        return dependantMSDs;
    }

    public Vector getInstallScenarioStatus() {
        Vector<String> scenarioStatus = new Vector<String>(1, 1);
        if (this.installScenario == null) {
            return null;
        }
        scenarioStatus.addElement(this.installScenario.getName());
        if (!this.installScenario.isInstalled()) {
            scenarioStatus.addElement("P");
        } else {
            scenarioStatus.addElement("I");
        }
        return scenarioStatus;
    }

    public String[] getLastInstalledMSDNames() {
        String[] result = new String[this.lastInstalledMSDs.size()];
        int i = 0;
        while (i < this.lastInstalledMSDs.size()) {
            result[i] = ((MobileSolutionDescriptor)this.lastInstalledMSDs.elementAt(i)).getName();
            ++i;
        }
        return result;
    }

    public void addMSDToListOfLastInstalled(MobileSolutionDescriptor msd) {
        this.lastInstalledMSDs.addElement(msd);
    }

    public DeploymentInstallLog getApplicationLog(String appName) {
        DeploymentInstallLog instLog = null;
        int i = 0;
        while (i < this.applicationLogs.size()) {
            instLog = (DeploymentInstallLog)this.applicationLogs.elementAt(i);
            if (instLog.getAppName().equals(appName)) {
                return instLog;
            }
            ++i;
        }
        return null;
    }

    public void setApplicationLog(DeploymentInstallLog log) {
        this.applicationLogs.addElement(log);
        try {
            this.saveApplicationLogs();
        }
        catch (FileNotFoundException e) {
            this.t.logException(e);
            this.t.log(50, "Trying to Save application logs - Problem in opening the file");
        }
        catch (IOException io) {
            this.t.logException(io);
            this.t.log(50, "Trying to Save application logs - Problem in accessing the file");
        }
    }

    public void clearApplicationLogs() {
        this.applicationLogs.removeAllElements();
        Configuration config = Configuration.getInstance();
        String folder = Configuration.getSettingsFolder();
        String deplog = config.getProperty("Installation.log");
        StringBuffer depLogFileName = new StringBuffer(folder.length() + deplog.length());
        depLogFileName.append(folder).append(deplog);
        File file = new File(depLogFileName.toString());
        if (file.exists()) {
            file.delete();
        }
    }

    public String getInstallationSequenceName() {
        if (this.installScenario == null) {
            return null;
        }
        return this.installScenario.getName();
    }

    private InstallationScenario getInstallationScenario() {
        return this.installScenario;
    }

    private void loadApplicationLogs() throws FileNotFoundException, IOException, ClassNotFoundException {
        Configuration config = Configuration.getInstance();
        String folder = Configuration.getSettingsFolder();
        String deplog = config.getProperty("Installation.log");
        StringBuffer depLogFileName = new StringBuffer(folder.length() + deplog.length());
        depLogFileName.append(folder).append(deplog);
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(depLogFileName.toString()));
        this.applicationLogs = (Vector)in.readObject();
    }

    private void saveApplicationLogs() throws FileNotFoundException, IOException {
        if (this.applicationLogs.size() == 0) {
            return;
        }
        Configuration config = Configuration.getInstance();
        String folder = Configuration.getSettingsFolder();
        String deplog = config.getProperty("Installation.log");
        StringBuffer depLogFileName = new StringBuffer(folder.length() + deplog.length());
        depLogFileName.append(folder).append(deplog);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(depLogFileName.toString()));
        out.writeObject(this.applicationLogs);
        out.flush();
        out.close();
    }
}

