/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.user;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MEException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LogonException
extends MEException {
    public static final int UNKNOWNMESSAGE = -1;
    public static final int INVALID_LOGONNAME = 0;
    public static final int INVALID_PASSWORD = 1;
    public static final int WRONG_PASSWORD = 2;
    public static final int USER_UNKNOWN = 9;
    public static final int USER_ALREADY_EXISTS = 4;
    public static final int EMPTY_USER_NAME = 0;
    public static final int RESERVED_USER_NAME = 5;
    public static final int INVALID_USER_NAME = 6;
    public static final int EMPTY_LOCAL_PASSWORD = 7;
    public static final int INVALID_LOCAL_PASSWORD_LENGTH = 8;
    public static final int LOGON_FAILED = 9;
    public static final int LOCAL_PASSWORD_CONFIRMATION_DIFFERS = 10;
    public static final int NEW_LOCAL_PASSWORD_CONFIRMATION_DIFFERS = 11;
    public static final int USER_IS_LOCKED = 12;
    public static final int SSO_LOGON_FAILURE = 13;
    public static final int SSO_SERVER_NOT_REACHABLE = 14;
    public static final int SSO_MALFORMED_URL = 15;
    public static final int SSO_IO_EXCEPTION = 16;
    public static final int USER_CREATION_NOT_ALLOWED = 17;
    public static final int SSO_USER_UNKNOWN = 18;
    private static final int UNDEFINED = -1;
    private final int messageId;
    private final Object[] arguments;
    private static final String[] MESSAGES = new String[]{"xmsg_EMPTY_USER_NAME", "User name must not be ''null'' or empty.", "xmsg_INVALID_PASSWORD", "Logon password does not comply with the SAP password rules in the Security Guide.", "xmsg_INVALID_PASSWORD", "Wrong old logon password. Password has not been changed.", "xmsg_USER_UNKNOWN", "User ''{0}'' is unknown.", "xmsg_USER_ALREADY_EXISTS", "The user ''{0}'' already exists.", "xmsg_RESERVED_USER_NAME", "User name ''{0}'' is reserved by SAP.", "xmsg_INVALID_USER_NAME", "User name ''{0}'' contains invalid character ''{1}''.", "xmsg_EMPTY_LOCAL_PASSWORD", "Logon password must not be ''null'' or empty.", "xmsg_INVALID_LOC_PASS_LENG", "Logon password has invalid length. There must be at least {0} and at most {1} characters.", "xmsg_WRONG_USER_OR_PASS", "Logon failed. User name or password are wrong.", "xmsg_LOC_PASS_CONF_DIFFERS", "Logon password differs from its confirmation.", "xmsg_NEW_LOC_PASS_CONF_DIF", "New password differs from its confirmation.", "xmsg_USER_IS_LOCKED", "User is locked.", "xmsg_SSO_LOGON_FAILURE", "SSO logon failure", "xmsg_SERVER_NOT_REACHABLE", "The MI server is currently not reachable.", "xmsg_MALFORMED_URL", "Malformed URL detected. Check your synchronization settings.", "xmsg_IO_EXCEPTION", "IO Exception detected. Check your synchronization settings.", "xmsg_USER_CREATION_FAILED", "Creation of multiple users is not allowed in single user mode.", "xmsg_USER_UNKNOWN", "User ''{0}'' is unknown."};
    private static final String RESOURCEBUNDLE_NAME = "com/sap/ip/me/awtapps/home/mobile_engine";

    public LogonException(int messageId) {
        this(messageId, null);
    }

    public LogonException(int messageId, Object[] arguments) {
        this(messageId, arguments, null);
    }

    public LogonException(int messageId, Object[] arguments, Throwable nestedException) {
        super(LogonException.getDefaultMessage(messageId, arguments), nestedException);
        this.messageId = messageId < 0 || messageId >= MESSAGES.length / 2 ? -1 : messageId;
        this.arguments = arguments;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public String getLocalizedMessage() {
        if (this.messageId == -1) {
            return this.getMessage();
        }
        try {
            ResourceBundle resources = ResourceBundle.getBundle(RESOURCEBUNDLE_NAME);
            String localizedMessage = resources.getString(MESSAGES[2 * this.messageId]);
            if (this.arguments != null) {
                localizedMessage = MessageFormat.format(localizedMessage, this.arguments);
            }
            return localizedMessage;
        }
        catch (Exception e) {
            Trace.getInstance("MI/API/User").log(60, "Cannot create a localized error message.");
            Trace.getInstance("MI/API/User").logException(60, e);
            return this.getMessage();
        }
    }

    public int getMessageId() {
        return this.messageId;
    }

    public Object[] getMessageParameters() {
        if (this.arguments == null) {
            return new Object[0];
        }
        return this.arguments;
    }

    private static String getDefaultMessage(int messageId, Object[] arguments) {
        if (messageId < 0 || messageId >= MESSAGES.length / 2) {
            return null;
        }
        String defaultMessage = MESSAGES[2 * messageId + 1];
        if (arguments != null) {
            defaultMessage = MessageFormat.format(defaultMessage, arguments);
        }
        return defaultMessage;
    }
}

