/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.sync;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.sync.SyncEventListener;
import java.util.Hashtable;
import java.util.Properties;

public abstract class SyncEventRegistry {
    private static final String IMPLEMENTOR_PROPERTY_KEY = "MobileEngine.Sync.Implementation.SyncEventRegistry";
    protected static final Trace trace = Trace.getInstance("MI/API/Sync");
    private static SyncEventRegistry instance;

    public static SyncEventRegistry getInstance() {
        if (instance == null) {
            Properties props = System.getProperties();
            SyncEventRegistry singletonInstance = (SyncEventRegistry)((Hashtable)props).get(IMPLEMENTOR_PROPERTY_KEY);
            if (singletonInstance == null) {
                try {
                    Class<?> clazz = Class.forName("com.sap.ip.me.sync.SyncEventRegistryImpl");
                    singletonInstance = (SyncEventRegistry)clazz.newInstance();
                    ((Hashtable)props).put(IMPLEMENTOR_PROPERTY_KEY, singletonInstance);
                }
                catch (Exception ex) {
                    trace.logException("Cannot instantiate SyncEventRegistry", (Throwable)ex, true);
                    throw new RuntimeException("Cannot instantiate SyncEventRegistry");
                }
            }
            instance = singletonInstance;
        }
        return instance;
    }

    public abstract boolean isRegistered(SyncEventListener var1);

    public abstract void addSyncEventListener(SyncEventListener var1);

    public abstract void removeSyncEventListener(SyncEventListener var1);
}

