/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.smartsync;

public final class RowChangeActionType {
    private static final String INSERT_STR = "I";
    private static final String MODIFY_STR = "M";
    private static final String REPLACE_STR = "R";
    private static final String DELETE_STR = "D";
    private static final String NOOPER_STR = "N";
    private static final String ERROR_STR = "E";
    private static final String INSERT_XMLSTR = "add";
    private static final String MODIFY_XMLSTR = "modify";
    private static final String REPLACE_XMLSTR = "replace";
    private static final String DELETE_XMLSTR = "delete";
    private RowChangeActionType[] mergeAction;
    private final String string;
    private final int index;
    private final String xmlString;
    public static RowChangeActionType INSERT = new RowChangeActionType("I", 0, "add");
    public static RowChangeActionType MODIFY = new RowChangeActionType("M", 1, "modify");
    public static RowChangeActionType DELETE = new RowChangeActionType("D", 2, "delete");
    public static RowChangeActionType REPLACE = new RowChangeActionType("R", 3, null);
    public static RowChangeActionType NOOPER = new RowChangeActionType("N", 4, null);
    public static RowChangeActionType ERROR = new RowChangeActionType("E", 5, null);

    private RowChangeActionType(String string, int index, String xmlString) {
        this.string = string;
        this.index = index;
        this.xmlString = xmlString;
    }

    private void setMergeAction(RowChangeActionType[] mergeAction) {
        this.mergeAction = mergeAction;
    }

    public RowChangeActionType getMerged(RowChangeActionType actionToMerge) {
        return this.mergeAction[actionToMerge.index];
    }

    public static RowChangeActionType forString(String string) {
        if (INSERT_STR.equals(string)) {
            return INSERT;
        }
        if (MODIFY_STR.equals(string)) {
            return MODIFY;
        }
        if (DELETE_STR.equals(string)) {
            return DELETE;
        }
        if (REPLACE_STR.equals(string)) {
            return REPLACE;
        }
        if (NOOPER_STR.equals(string)) {
            return NOOPER;
        }
        return NOOPER;
    }

    public static RowChangeActionType forXMLString(String string) {
        if (INSERT_XMLSTR.equals(string)) {
            return INSERT;
        }
        if (MODIFY_XMLSTR.equals(string)) {
            return MODIFY;
        }
        if (DELETE_XMLSTR.equals(string)) {
            return DELETE;
        }
        if (REPLACE_XMLSTR.equals(string)) {
            return REPLACE;
        }
        throw new RuntimeException("not supported xml: " + string);
    }

    public String toString() {
        return this.string;
    }

    public String toXMLString() {
        return this.xmlString;
    }

    static {
        INSERT.setMergeAction(new RowChangeActionType[]{ERROR, INSERT, NOOPER, INSERT, INSERT, ERROR});
        MODIFY.setMergeAction(new RowChangeActionType[]{ERROR, MODIFY, DELETE, REPLACE, MODIFY, ERROR});
        DELETE.setMergeAction(new RowChangeActionType[]{NOOPER, ERROR, ERROR, ERROR, DELETE, ERROR});
        REPLACE.setMergeAction(new RowChangeActionType[]{ERROR, REPLACE, DELETE, REPLACE, REPLACE, ERROR});
        NOOPER.setMergeAction(new RowChangeActionType[]{INSERT, MODIFY, DELETE, REPLACE, NOOPER, ERROR});
        ERROR.setMergeAction(new RowChangeActionType[]{ERROR, ERROR, ERROR, ERROR, ERROR, ERROR});
    }
}

