/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.smartsync;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class FixedDecimal
implements Serializable {
    public static final long serialVersionUID = Long.MIN_VALUE;
    private int _length = -1;
    private int _decimals = -1;
    private BigDecimal _value = null;

    public FixedDecimal(String iStringVal, int iLen, int iDec) throws NumberFormatException {
        if (iStringVal == null) {
            throw new NumberFormatException("Nullpoint!");
        }
        this._init(iStringVal.trim(), iLen, iDec);
    }

    public FixedDecimal(String iFormattedVal, Locale local, int iLen, int iDec) throws NumberFormatException {
        if (iFormattedVal == null) {
            throw new NumberFormatException("Nullpoint!");
        }
        NumberFormat format = NumberFormat.getInstance(local);
        try {
            double value = format.parse(iFormattedVal.trim()).doubleValue();
            this._init(Double.toString(value), iLen, iDec);
        }
        catch (ParseException pe) {
            throw new NumberFormatException(pe.getMessage());
        }
        catch (NumberFormatException ne) {
            throw ne;
        }
    }

    public FixedDecimal add(FixedDecimal iVal) {
        return new FixedDecimal(this._value.add(iVal.getBigDecimal()).toString(), this.getLength() > iVal.getLength() ? this.getLength() : iVal.getLength(), this.getDecimals() > iVal.getDecimals() ? this.getDecimals() : iVal.getDecimals());
    }

    public FixedDecimal multiply(FixedDecimal iVal) {
        return new FixedDecimal(this._value.multiply(iVal.getBigDecimal()).toString(), this.getLength() > iVal.getLength() ? this.getLength() : iVal.getLength(), this.getDecimals() > iVal.getDecimals() ? this.getDecimals() : iVal.getDecimals());
    }

    public FixedDecimal divide(FixedDecimal iVal) {
        return new FixedDecimal(this._value.divide(iVal.getBigDecimal(), 4).toString(), this._length, this._decimals);
    }

    public FixedDecimal negate() {
        return new FixedDecimal(this._value.negate().toString(), this._length, this._decimals);
    }

    public int compareTo(FixedDecimal iVal) {
        return this._value.compareTo(iVal.getBigDecimal());
    }

    public String toString() {
        return this.stringValue();
    }

    public String stringValue() {
        BigDecimal bd = new BigDecimal(this._value.toString());
        if (this._decimals >= 0) {
            bd = bd.setScale(this._decimals);
        }
        return new String(bd.toString());
    }

    public FixedDecimal copy() {
        FixedDecimal fd = new FixedDecimal(this.toString(), this._length, this._decimals);
        return fd;
    }

    public String formattedString(Locale local) {
        NumberFormat format = NumberFormat.getInstance(local);
        double dval = this.doubleValue();
        return new String(format.format(dval));
    }

    public double doubleValue() {
        return this._value.doubleValue();
    }

    public float floatValue() {
        return this._value.floatValue();
    }

    public BigDecimal bigDecimalValue() {
        return this._value;
    }

    public int getLength() {
        return this._length;
    }

    public int getDecimals() {
        return this._decimals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedDecimal)) {
            return false;
        }
        FixedDecimal fd = (FixedDecimal)o;
        return this._value.equals(fd.getBigDecimal()) && this._length == fd.getLength() && this._decimals == fd.getDecimals();
    }

    public int hashCode() {
        return this._value.hashCode() + this._length + this._decimals;
    }

    boolean _checkValue(String iVal, int iLen, int iDec) {
        if (iLen <= 0 || iDec < 0) {
            return false;
        }
        if (iLen < iDec) {
            return false;
        }
        String isVal = null;
        isVal = iVal.charAt(0) == '+' || iVal.charAt(0) == '-' ? new String(iVal.substring(1)) : new String(iVal);
        int decimal = isVal.indexOf(".");
        if (decimal == -1) {
            return isVal.length() <= iLen;
        }
        return decimal <= iLen - iDec;
    }

    void _init(String iStringVal, int iLen, int iDec) throws NumberFormatException {
        this._length = iLen;
        this._decimals = iDec;
        try {
            this._value = new BigDecimal(iStringVal);
            if (!this._checkValue(iStringVal, iLen, iDec)) {
                throw new NumberFormatException("The length or decimal length is invalid.");
            }
            this._value = this._value.setScale(this._decimals, 1);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (ArithmeticException ae) {
            throw new NumberFormatException(ae.getMessage());
        }
    }

    BigDecimal getBigDecimal() {
        return this._value;
    }
}

