/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

class UrlConnectionTest {
    private static final UrlConnectionTest INSTANCE = new UrlConnectionTest();
    private Trace trace = Trace.getInstance("MI/API/Services");
    private URL testURL = null;
    private String lastHostChecked = " ";
    private long lastTimeOfCheck = 0L;
    private boolean successfull = false;
    private long sleepingTime;
    private String lastMessage;

    String getLastMessage() {
        return this.lastMessage;
    }

    private UrlConnectionTest() {
        long connectionTimeout = Configuration.getInstance().getLong("MobileEngine.Sync.ConnectionTimeout", -1L);
        if (connectionTimeout > 0L) {
            this.sleepingTime = connectionTimeout / 12L;
            if (this.trace.isLogging(70)) {
                this.trace.log(70, "UrlConnectionTest: Set sleeping time for future connection tests to {0}", (Object)Long.toString(this.sleepingTime, 10));
            }
        } else {
            this.sleepingTime = 500L;
            if (this.trace.isLogging(70)) {
                this.trace.log(70, "UrlConnectionTest: hardcoded sleeping time for future connection tests is {0}", (Object)Long.toString(this.sleepingTime, 10));
            }
        }
    }

    static UrlConnectionTest getInstance(URL urlToTest) {
        if (UrlConnectionTest.INSTANCE.testURL == null) {
            UrlConnectionTest.INSTANCE.testURL = urlToTest;
            if (UrlConnectionTest.INSTANCE.trace.isLogging(90)) {
                UrlConnectionTest.INSTANCE.trace.log(90, "UrlConnectionTest: returning instance for host {0}", (Object)urlToTest.getHost());
            }
            return INSTANCE;
        }
        if (UrlConnectionTest.INSTANCE.testURL.equals(urlToTest)) {
            if (UrlConnectionTest.INSTANCE.trace.isLogging(90)) {
                UrlConnectionTest.INSTANCE.trace.log(90, "UrlConnectionTest: returning instance for same host {0}", (Object)urlToTest.getHost());
            }
            return INSTANCE;
        }
        if (UrlConnectionTest.INSTANCE.trace.isLogging(90)) {
            UrlConnectionTest.INSTANCE.trace.log(90, "UrlConnectionTest: returning instance for new host {0} replacing {1}", (Object)urlToTest.getHost(), (Object)UrlConnectionTest.INSTANCE.testURL.getHost());
        }
        UrlConnectionTest.INSTANCE.testURL = urlToTest;
        return INSTANCE;
    }

    boolean wasSuccessfull() {
        return this.successfull;
    }

    void runTest() {
        long currentTestStartTime = System.currentTimeMillis();
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "UrlConnectionTest: lastHostChecked was {0}", (Object)this.lastHostChecked);
            this.trace.log(90, "UrlConnectionTest: lastTimeOfCheck was {0}", (Object)Long.toString(this.lastTimeOfCheck, 10));
            this.trace.log(90, "UrlConnectionTest: last check was {0} ms ago", (Object)Long.toString(currentTestStartTime - this.lastTimeOfCheck, 10));
        }
        if (this.testURL.getHost().equalsIgnoreCase(this.lastHostChecked) && currentTestStartTime - this.lastTimeOfCheck < 3000L) {
            this.successfull = true;
            if (this.trace.isLogging(80)) {
                this.trace.log(80, "UrlConnectionTest: skipping test for {0}", (Object)this.testURL.getHost());
            }
            return;
        }
        this.lastTimeOfCheck = currentTestStartTime;
        this.lastHostChecked = this.testURL.getHost();
        UrlConnectionTestThread testConnection = new UrlConnectionTestThread(this.testURL);
        testConnection.setStopIndicator(false);
        testConnection.start();
        long starttime = System.currentTimeMillis();
        for (int tries = 1; tries <= 12 && testConnection.doOneMoreTime(); ++tries) {
            if (this.trace.isLogging(90)) {
                this.trace.log(90, "UrlConnectionTest: try number: {0}", (Object)Integer.toString(tries, 10));
            }
            try {
                if (!testConnection.doOneMoreTime()) break;
                Thread.sleep(this.sleepingTime);
                continue;
            }
            catch (InterruptedException inex) {
                if (!this.trace.isLogging(70)) break;
                this.trace.log(70, "UrlConnectionTest: caught exception {0}", (Object)inex.getMessage());
                break;
            }
        }
        testConnection.setStopIndicator(true);
        long endtime = System.currentTimeMillis();
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "UrlConnectionTest: it took {0} ms to test the connection", (Object)Long.toString(endtime - starttime, 10));
        }
        this.successfull = testConnection.isConnected();
        if (this.trace.isLogging(80)) {
            if (this.successfull) {
                this.trace.log(80, "UrlConnectionTest: Connection could be established!!!");
                this.lastMessage = "successfully connected";
            } else {
                this.trace.log(80, "UrlConnectionTest: Connection could not be established!!!");
                if (this.lastMessage == null) {
                    this.lastMessage = "URL connection test timeout";
                }
            }
        }
    }

    class UrlConnectionTestThread
    extends Thread {
        private URL urlToConnect;
        private boolean connected;
        private boolean oneMoreTime;
        private boolean stopIndicator;

        UrlConnectionTestThread(URL urlToConnect) {
            this.urlToConnect = urlToConnect;
            this.setDaemon(true);
            this.connected = false;
            this.oneMoreTime = true;
        }

        public void run() {
            InputStream is = null;
            UrlConnectionTest.this.lastMessage = null;
            boolean logit = UrlConnectionTest.this.trace.isLogging(90);
            while (!this.stopIndicator) {
                try {
                    if (logit) {
                        UrlConnectionTest.this.trace.log(90, " UrlConnectionTestThread: method run() started...");
                    }
                    String protocol = this.urlToConnect.getProtocol();
                    URLConnection uc = this.urlToConnect.openConnection();
                    uc.connect();
                    is = uc.getInputStream();
                    if (is == null || !"http".equalsIgnoreCase(protocol)) continue;
                    if (logit) {
                        UrlConnectionTest.this.trace.log(90, " UrlConnectionTestThread: URL protocol is {0}", (Object)protocol);
                    }
                    HttpURLConnection httpCon = (HttpURLConnection)uc;
                    int responseCode = httpCon.getResponseCode();
                    if (logit) {
                        UrlConnectionTest.this.trace.log(90, " UrlConnectionTestThread: HTTP responsecode is {0}", (Object)Integer.toString(responseCode, 10));
                    }
                    switch (responseCode) {
                        case 400: {
                            this.logErrorAndReset("Bad request 400; The request had bad syntax or was inherently impossible to be satisfied");
                            break;
                        }
                        case 401: {
                            this.logErrorAndReset("Unauthorized 401; The parameter to this message gives a specification of authorization schemes which are acceptable. The client should retry the request with a suitable Authorization header");
                            break;
                        }
                        case 402: {
                            this.logErrorAndReset("PaymentRequired 402; The parameter to this message gives a specification of charging schemes acceptable. The client may retry the request with a suitable ChargeTo header");
                            break;
                        }
                        case 403: {
                            this.logErrorAndReset("Forbidden 403; The request is for something forbidden. Authorization will not help");
                            break;
                        }
                        case 404: {
                            this.logErrorAndReset("Not found 404; The server has not found anything matching the URI given");
                            break;
                        }
                        case 500: {
                            this.logErrorAndReset("Internal Error 500; The server encountered an unexpected condition which prevented it from fulfilling the request");
                            break;
                        }
                        case 501: {
                            this.logErrorAndReset("Not implemented 501; The server does not support the facility required");
                            break;
                        }
                        case 502: {
                            this.logErrorAndReset("Service temporarily overloaded 502; The server cannot process the request due to a high load (whether HTTP servicing or other requests). The implication is that this is a temporary condition which maybe alleviated at other times");
                            break;
                        }
                        case 503: {
                            this.logErrorAndReset("Gateway timeout 503; This is equivalent to Internal Error 500, but in the case of a server which is in turn accessing some other service, this indicates that the respose from the other service did not return within a time that the gateway was prepared to wait. As from the point of view of the clientand the HTTP transaction the other service is hidden within the server, this maybe treated identically to Internal error 500, but has more diagnostic value.");
                            break;
                        }
                        default: {
                            this.connected = true;
                            this.oneMoreTime = false;
                            this.setStopIndicator(true);
                        }
                    }
                    is.close();
                }
                catch (Exception ex) {
                    UrlConnectionTest.this.lastMessage = "cannot connect (" + ex.getClass().getName() + ": " + IOUtils.asterixForPassword(ex.getMessage() + ")");
                    if (UrlConnectionTest.this.trace.isLogging(1000)) {
                        UrlConnectionTest.this.trace.logException(1000, "URLConnectionThread: caught exception {0}: {1}", new Object[]{ex.getClass().getName(), IOUtils.asterixForPassword(ex.getMessage())}, ex, true);
                    }
                    this.connected = false;
                    this.oneMoreTime = false;
                    this.setStopIndicator(true);
                }
            }
        }

        void setStopIndicator(boolean flag) {
            this.stopIndicator = flag;
        }

        boolean getStopIndicator() {
            return this.stopIndicator;
        }

        boolean isConnected() {
            return this.connected;
        }

        boolean doOneMoreTime() {
            return this.oneMoreTime;
        }

        private void logErrorAndReset(String message) {
            UrlConnectionTest.this.trace.log(60, message);
            UrlConnectionTest.this.lastMessage = message;
            this.oneMoreTime = false;
            this.connected = false;
        }
    }
}

