/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.services.Log;
import java.io.IOException;
import java.io.InputStream;

class StreamTimeout
implements Runnable {
    private InputStream is;
    private long timeSlept;
    private boolean finished = false;

    StreamTimeout() {
    }

    public void setFinished(boolean value) {
        this.finished = value;
    }

    public void run() {
        long waitForResultsTimeout = Configuration.getInstance().getLong("MobileEngine.Sync.WaitForResultsTimeout", -1L);
        Log.log("WaitForResultsTimeout is " + waitForResultsTimeout);
        while (!this.finished) {
            try {
                long sleeptime = waitForResultsTimeout / 50L;
                Thread.sleep(sleeptime);
                this.increaseTimeSlept(sleeptime);
            }
            catch (InterruptedException e) {
                Log.logException(e);
            }
            if (this.timeSlept <= waitForResultsTimeout) continue;
            Log.log(this.toString() + " timeSlept is bigger than WaitForResultsTimeout: " + this.timeSlept);
            try {
                Log.log(this.toString() + " is closing the stream " + this.is);
                this.is.close();
            }
            catch (IOException e1) {
                Log.logException(e1);
            }
            Log.log(this.toString() + " leaving the run method");
            break;
        }
        Log.log(this.toString() + " is finished !!!");
    }

    public void setInputStream(InputStream is) {
        this.is = is;
    }

    public synchronized void increaseTimeSlept(long newValue) {
        this.timeSlept = newValue > 0L ? (this.timeSlept += newValue) : 0L;
    }
}

