/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import com.sap.ip.me.api.conf.Configuration;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Stack;

public abstract class PerformanceLog {
    private static final String[] INDENT = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  "};
    private static final String[] BLANK = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private static final int INDENT_MAX = INDENT.length - 1;
    private static final int BLANK_MAX = BLANK.length - 1;
    private static final Object DEFAULT_MASTER = new Object();
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static PerformanceLog instance;
    private final Stack stack = new Stack();
    private PrintWriter out;
    private Object master = null;
    private long line = 0L;
    private int entryCount = 0;

    protected PerformanceLog() {
        Configuration config = Configuration.getInstance();
        if (config.getBoolean("MobileEngine.Trace.PerformanceLog.Enabled", false)) {
            try {
                try {
                    StringBuffer sb = new StringBuffer(256);
                    sb.append(config.getProperty("MobileEngine.InstallationPath"));
                    sb.append(File.separatorChar).append("log");
                    sb.append(File.separatorChar).append("performance.log");
                    File logFile = new File(sb.toString());
                    if (!logFile.exists()) {
                        new File(logFile.getParent()).mkdirs();
                    }
                    this.out = new PrintWriter((Writer)new FileWriter(logFile), false);
                }
                catch (Exception ex) {
                    System.err.println("Cannot create performance.log file. Printing to System.out.");
                    this.out = new PrintWriter(System.out);
                    Object var5_6 = null;
                    this.printHeader();
                }
                Object var5_5 = null;
                this.printHeader();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.printHeader();
                throw throwable;
            }
        } else {
            this.out = null;
        }
    }

    private void printHeader() {
        if (this.out != null) {
            this.out.print("# time=");
            this.out.println(new Date());
            this.out.println('#');
            this.out.println("#Line:   total(netto) #    delta(    used) # class@name");
            this.out.println("#======================================================");
        }
    }

    protected static final PerformanceLog getInstance() {
        if (instance == null) {
            try {
                Class<?> c = Class.forName("com.sap.ip.me.ccms.sat.SatLog");
                instance = (PerformanceLog)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    static final PerformanceLog _createInstance(PrintWriter writer) {
        instance = null;
        instance = PerformanceLog.getInstance();
        PerformanceLog.instance.out = writer;
        instance.printHeader();
        return instance;
    }

    public static final boolean isOn() {
        return PerformanceLog.getInstance().isLogging();
    }

    public static final void reset() {
        PerformanceLog plog;
        PerformanceLog performanceLog = plog = PerformanceLog.getInstance();
        synchronized (performanceLog) {
            plog.unsetMaster(DEFAULT_MASTER);
        }
    }

    public static final void print() {
    }

    public static final void methodStarted() {
        PerformanceLog.getInstance().instanceMethodStarted();
    }

    protected void instanceMethodStarted() {
        if (this.isLogging()) {
            PerformanceLog performanceLog = this;
            synchronized (performanceLog) {
                this.setMaster(DEFAULT_MASTER);
                this.openEntry(null);
            }
        }
    }

    public static final Object methodStarted(Object self) {
        return PerformanceLog.getInstance().instanceMethodStarted(self);
    }

    protected Object instanceMethodStarted(Object self) {
        if (this.isLogging()) {
            PerformanceLog performanceLog = this;
            synchronized (performanceLog) {
                Object obj = null;
                if (!this.isMasterSet()) {
                    obj = new Object();
                    this.setMaster(obj);
                }
                this.openEntry(self);
                Object object = obj;
                return object;
            }
        }
        return null;
    }

    public static void methodFinished(String text) {
        PerformanceLog.getInstance().instanceMethodFinished(text);
    }

    protected void instanceMethodFinished(String text) {
        if (this.isLogging()) {
            PerformanceLog performanceLog = this;
            synchronized (performanceLog) {
                this.closeEntry(text == null ? "<<unknown>>" : text);
            }
        }
    }

    public static void methodFinished(Object traceTag, String text) {
        PerformanceLog.getInstance().instanceMethodFinished(traceTag, text);
    }

    protected void instanceMethodFinished(Object traceTag, String text) {
        if (this.isLogging()) {
            PerformanceLog performanceLog = this;
            synchronized (performanceLog) {
                this.closeEntry(text == null ? "<<unknown>>" : text);
                if (traceTag != null) {
                    this.unsetMaster(traceTag);
                }
            }
        }
    }

    private static final void padLong(long val, int len, PrintWriter out) {
        String str = String.valueOf(val);
        len = Math.max(0, len - str.length());
        len = Math.min(len, BLANK_MAX);
        out.print(BLANK[len]);
        out.print(str);
    }

    private final boolean isLogging() {
        return this.out != null;
    }

    private final boolean isMasterSet() {
        return this.master != null;
    }

    private final void setMaster(Object master) {
        if (this.isLogging() && this.master == null) {
            this.clearStack();
            this.master = master != null ? master : DEFAULT_MASTER;
            this.emptyLine(2, this.out);
        }
    }

    private final void openEntry(Object caller) {
        if (this.isLogging()) {
            if (this.master != null) {
                LogEntry parent = this.stack.empty() ? null : (LogEntry)this.stack.peek();
                this.stack.push(new LogEntry(this.entryCount++, parent, caller));
            } else {
                this.out.println("ERROR: openEntry in state idle (" + caller.getClass().getName() + ")");
                this.clearStack();
            }
        }
    }

    private final void closeEntry(String text) {
        if (this.isLogging()) {
            if (this.master != null && !this.stack.empty()) {
                LogEntry logEntry = (LogEntry)this.stack.pop();
                logEntry.end(text);
                this.startLine(this.out);
                logEntry.log(this.out);
                if (this.stack.empty()) {
                    this.clearStack();
                }
            } else {
                this.out.println("ERROR: closeEntry() text=" + text + ")");
                this.clearStack();
            }
        }
    }

    private final void unsetMaster(Object master) {
        if (this.isLogging() && this.master != null && this.master == master) {
            this.clearStack();
        }
    }

    private final void clearStack() {
        if (this.isLogging()) {
            if (!this.stack.empty()) {
                this.out.println("ERROR: clearStack stack size not 0");
            }
            this.master = null;
            this.stack.removeAllElements();
            this.entryCount = 0;
            this.out.flush();
        }
    }

    private final void startLine(PrintWriter out) {
        PerformanceLog.padLong(this.line++, 5, out);
        out.print(':');
    }

    private final void emptyLine(int count, PrintWriter out) {
        int i = 0;
        while (i < count) {
            this.startLine(out);
            out.println();
            ++i;
        }
    }

    final void _closeLogFile() {
        if (this.isLogging()) {
            this.out.close();
            this.stack.removeAllElements();
        }
    }

    final Stack _getStack() {
        return this.stack;
    }

    final Object _getMaster() {
        return this.master;
    }

    private class LogEntry {
        private LogEntry parent;
        private final int indent;
        private final int number;
        private final int parentNum;
        private final String className;
        private String name;
        private long timeTotal;
        private long memoryDelta;
        private long memoryUsed;
        private long timeChildren = 0L;

        private LogEntry(int number, LogEntry parent, Object caller) {
            this.number = number;
            this.parent = parent;
            this.indent = parent != null ? parent.getIndent() + 1 : 0;
            this.parentNum = parent != null ? parent.getEntryNumber() : 0;
            this.className = caller == null ? "null" : caller.getClass().getName();
            this.memoryDelta = this.calculateUsedMemory();
            this.timeTotal = System.currentTimeMillis();
            this.timeChildren = 0L;
        }

        private final int getIndent() {
            return this.indent;
        }

        private final int getEntryNumber() {
            return this.number;
        }

        private void end(String name) {
            this.name = name;
            this.memoryUsed = this.calculateUsedMemory();
            this.memoryDelta = this.memoryUsed - this.memoryDelta;
            this.timeTotal = System.currentTimeMillis() - this.timeTotal;
            if (this.parent != null) {
                this.parent.timeChildren += this.timeTotal;
                this.parent = null;
            }
        }

        private final long calculateUsedMemory() {
            return RUNTIME.totalMemory() - RUNTIME.freeMemory();
        }

        public final void log(PrintWriter out) {
            PerformanceLog.padLong(this.timeTotal, 7, out);
            out.print('(');
            PerformanceLog.padLong(this.timeTotal - this.timeChildren, 5, out);
            out.print(") # ");
            PerformanceLog.padLong(this.memoryDelta, 8, out);
            out.print('(');
            PerformanceLog.padLong(this.memoryUsed, 8, out);
            out.print(") # ");
            int d = Math.max(0, this.indent);
            while (d > 0) {
                int i = Math.min(INDENT_MAX, d);
                out.print(INDENT[i]);
                d -= i;
            }
            out.print(this.number);
            out.print('(');
            out.print(this.parentNum);
            out.print(") ");
            out.print(this.className);
            out.print('@');
            out.print(this.name);
            out.println();
        }

        public final String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.indent);
            sb.append(";");
            sb.append(this.className);
            return sb.toString();
        }
    }
}

