/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.services;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class MultiObjectFileStorage {
    private static final String ROOT_DIRECTORY = Configuration.getInstallationDirectory() + File.separator + "data";
    private static final String REG_FILENAME = "datreg.obj";
    private static final char MOD_INSERT = 'i';
    private static final char MOD_DELETE = 'd';
    private static final Hashtable folders = new Hashtable();
    private final Hashtable currentStateBuffer = new Hashtable();
    private final Hashtable modificationBuffer = new Hashtable();
    private String directory = null;
    private int objectFileCounter = 0;
    private Hashtable objectFilenameMapping = new Hashtable();
    private boolean objectMappingHasChanged = false;
    private boolean allObjectsInBuffer = false;

    private MultiObjectFileStorage(String subDirectory) throws FileNotFoundException {
        this.initDirectory(subDirectory);
        this.readRegFile();
    }

    public static synchronized MultiObjectFileStorage createInstance(String subDirectory) {
        if (subDirectory == null) {
            return null;
        }
        MultiObjectFileStorage instance = (MultiObjectFileStorage)folders.get(subDirectory);
        if (instance == null) {
            try {
                instance = new MultiObjectFileStorage(subDirectory);
                folders.put(subDirectory, instance);
            }
            catch (FileNotFoundException fnf) {
                AppLog.getInstance("MI/API/Services").logException(fnf);
                instance = null;
            }
        }
        return instance;
    }

    public Object read(String key) {
        return this.read(key, false);
    }

    public Object read(String key, boolean bypassCache) {
        String fileName;
        Object rObject = null;
        if (!bypassCache) {
            rObject = this.currentStateBuffer.get(key);
        }
        if (rObject == null && (fileName = this.getObjectFileName(key)) != null && (rObject = this.readObjectFromFile(fileName)) != null) {
            this.currentStateBuffer.put(key, rObject);
        }
        return rObject;
    }

    public void write(String key, Object value) {
        String fileName = this.registerAndGetFilename(key, value);
        this.writeObjectToFile(fileName, value);
        this.writeRegFile();
    }

    public void delete(String key) {
        String fileName = this.unregisterAndGetFilename(key);
        if (fileName != null) {
            this.writeRegFile();
            this.deleteObjectFile(fileName);
        }
    }

    public void writeOnCommit(String key, Object value) {
        this.modificationBuffer.put(key, new _ModificationContainer(key, value, 'i'));
        this.currentStateBuffer.put(key, value);
    }

    public void deleteOnCommit(String key) {
        Object value = this.currentStateBuffer.get(key);
        if (value != null) {
            this.modificationBuffer.put(key, new _ModificationContainer(key, value, 'd'));
            this.currentStateBuffer.remove(key);
        }
    }

    public void commit() {
        Enumeration mods = this.modificationBuffer.elements();
        while (mods.hasMoreElements()) {
            _ModificationContainer mod = (_ModificationContainer)mods.nextElement();
            if (mod.operation == 'i') {
                this.writeObjectToFile(this.registerAndGetFilename(mod.key, mod.value), mod.value);
                continue;
            }
            if (mod.operation != 'd') continue;
            this.deleteObjectFile(this.unregisterAndGetFilename(mod.key));
        }
        this.writeRegFile();
        this.modificationBuffer.clear();
    }

    public Enumeration bufferedObjects() {
        return this.currentStateBuffer.elements();
    }

    public Enumeration allObjects() {
        if (!this.allObjectsInBuffer) {
            Enumeration objectKeys = this.objectFilenameMapping.keys();
            while (objectKeys.hasMoreElements()) {
                String key = (String)objectKeys.nextElement();
                this.read(key, false);
            }
            this.allObjectsInBuffer = true;
        }
        return this.bufferedObjects();
    }

    public void rollback() {
        Enumeration rollbackObjNames = this.currentStateBuffer.keys();
        while (rollbackObjNames.hasMoreElements()) {
            String key = (String)rollbackObjNames.nextElement();
            this.read(key, true);
        }
        this.modificationBuffer.clear();
    }

    private void setDirectory(String directory) {
        this.directory = directory;
    }

    private String getDirectory() {
        return this.directory;
    }

    private void setObjectFileCounter(int objectFileCounter) {
        this.objectFileCounter = objectFileCounter;
    }

    private int getObjectFileCounter() {
        return this.objectFileCounter;
    }

    private void increaseObjectFileCounter() {
        ++this.objectFileCounter;
    }

    private void initDirectory(String subDirectory) throws FileNotFoundException {
        StringBuffer sbDir = new StringBuffer(ROOT_DIRECTORY);
        sbDir.append(File.separator);
        sbDir.append(subDirectory);
        File dir = new File(sbDir.toString());
        this.setDirectory(dir.getAbsolutePath());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new FileNotFoundException("MultiObjectFileStorage cannot create directory: " + dir.getAbsolutePath());
        }
    }

    private void readRegFile() {
        File f = new File(this.getDirectory(), REG_FILENAME);
        try {
            FileInputStream fs = new FileInputStream(f.getAbsolutePath());
            ObjectInputStream is = new ObjectInputStream(fs);
            this.setObjectFileCounter((Integer)is.readObject());
            this.objectFilenameMapping = (Hashtable)is.readObject();
            is.close();
            fs.close();
        }
        catch (Exception t) {
            AppLog.getInstance("MI/API/Services").logException(50, "MultiObjectFileStorage: Error in data read access to mapping file " + f.getAbsolutePath() + " - Generating initial mapping", t, false);
            this.setObjectFileCounter(0);
            this.objectFilenameMapping = new Hashtable();
        }
    }

    private void writeRegFile() {
        if (this.objectMappingHasChanged) {
            File f = new File(this.getDirectory(), REG_FILENAME);
            try {
                FileOutputStream fs = new FileOutputStream(f.getAbsolutePath());
                ObjectOutputStream os = new ObjectOutputStream(fs);
                os.writeObject(new Integer(this.getObjectFileCounter()));
                os.writeObject(this.objectFilenameMapping);
                os.flush();
                fs.flush();
                os.close();
                fs.close();
                this.objectMappingHasChanged = false;
            }
            catch (Exception t) {
                AppLog.getInstance("MI/API/Services").logException(50, "MultiObjectFileStorage: Error in data write access to mapping file " + f.getAbsolutePath(), t, false);
            }
        }
    }

    private String getObjectFileName(String key) {
        Object intObj = this.objectFilenameMapping.get(key);
        if (intObj == null) {
            return null;
        }
        int intVal = (Integer)intObj;
        return Integer.toHexString(intVal) + ".obj";
    }

    private Object readObjectFromFile(String iFileName) {
        try {
            File f = new File(this.getDirectory(), iFileName);
            FileInputStream fs = new FileInputStream(f.getAbsolutePath());
            ObjectInputStream is = new ObjectInputStream(fs);
            Object obj = is.readObject();
            is.close();
            fs.close();
            return obj;
        }
        catch (Exception t) {
            if (!(t instanceof FileNotFoundException)) {
                AppLog.getInstance("MI/API/Services").logException(50, "MultiObjectFileStorage: Cannot read object from file", t, false);
            }
            return null;
        }
    }

    private String registerAndGetFilename(String key, Object value) {
        String rFileName = this.getObjectFileName(key);
        if (rFileName == null) {
            this.increaseObjectFileCounter();
            this.objectFilenameMapping.put(key, new Integer(this.getObjectFileCounter()));
            rFileName = Integer.toHexString(this.getObjectFileCounter()) + ".obj";
            this.currentStateBuffer.put(key, value);
            this.objectMappingHasChanged = true;
        }
        return rFileName;
    }

    private String unregisterAndGetFilename(String key) {
        String rFileName = this.getObjectFileName(key);
        if (rFileName != null) {
            this.objectFilenameMapping.remove(key);
            this.currentStateBuffer.remove(key);
            this.objectMappingHasChanged = true;
        }
        return rFileName;
    }

    private void writeObjectToFile(String fileName, Object value) {
        try {
            File f = new File(this.getDirectory(), fileName);
            FileOutputStream fs = new FileOutputStream(f.getAbsolutePath());
            ObjectOutputStream os = new ObjectOutputStream(fs);
            os.writeObject(value);
            os.flush();
            fs.flush();
            os.close();
            fs.close();
        }
        catch (Exception t) {
            AppLog.getInstance("MI/API/Services").logException(50, "MultiObjectFileStorage: Cannot write object to file", t, true);
        }
    }

    private void deleteObjectFile(String iFileName) {
        try {
            File f = new File(this.getDirectory(), iFileName);
            f.delete();
        }
        catch (Exception t) {
            AppLog.getInstance("MI/API/Services").logException(50, "MultiObjectFileStorage: Cannot delete object file", t, true);
        }
    }

    private class _ModificationContainer {
        String key;
        Object value;
        char operation;

        _ModificationContainer(String iKey, Object iValue, char iOperation) {
            this.key = iKey;
            this.value = iValue;
            this.operation = iOperation;
        }
    }
}

